/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.detector.ngram.profiles;

import com.intellij.grazie.detector.model.Language;
import com.intellij.grazie.detector.model.LanguageISO;
import com.intellij.grazie.detector.ngram.NgramDetector;
import com.intellij.grazie.detector.ngram.profiles.LanguageProfile;
import com.intellij.grazie.detector.ngram.profiles.LanguageProfileImpl;
import com.intellij.grazie.detector.ngram.profiles.LanguageProfileReader$SerializedProfile$;
import com.intellij.grazie.detector.utils.JSON;
import com.intellij.grazie.detector.utils.TextKt;
import com.intellij.grazie.detector.utils.resources.ResourceLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.MissingFieldException;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.IntSerializer;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J6\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u000ej\b\u0012\u0004\u0012\u00020\u000b`\u000f2\u0016\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\t0\u000ej\b\u0012\u0004\u0012\u00020\t`\u000f2\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00122\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/grazie/detector/ngram/profiles/LanguageProfileReader;", "", "()V", "PROFILES_DIR", "", "getResource", "loader", "Lcom/intellij/grazie/detector/utils/resources/ResourceLoader;", "language", "Lcom/intellij/grazie/detector/model/Language;", "read", "Lcom/intellij/grazie/detector/ngram/profiles/LanguageProfile;", "input", "readAll", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "languages", "readAllBuiltIn", "", "SerializedProfile", "nlp-detector"})
public final class LanguageProfileReader {
    private static final String PROFILES_DIR = "ngrams";
    @NotNull
    public static final LanguageProfileReader INSTANCE;

    private final String getResource(ResourceLoader loader, Language language) {
        return loader.file(ResourceLoader.Type.NgramProfile, language);
    }

    @NotNull
    public final LinkedHashSet<LanguageProfile> readAll(@NotNull LinkedHashSet<Language> languages2, @NotNull ResourceLoader loader) {
        Intrinsics.checkNotNullParameter(languages2, (String)"languages");
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        LinkedHashSet<LanguageProfile> loaded = new LinkedHashSet<LanguageProfile>();
        Iterator iterator = languages2.iterator();
        while (iterator.hasNext()) {
            Language lang;
            Language language = lang = (Language)((Object)iterator.next());
            Intrinsics.checkNotNullExpressionValue((Object)((Object)language), (String)"lang");
            loaded.add(this.read(this.getResource(loader, language)));
        }
        return loaded;
    }

    @NotNull
    public final List<LanguageProfile> readAllBuiltIn(@NotNull ResourceLoader loader) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        ArrayList<LanguageProfile> loaded = new ArrayList<LanguageProfile>();
        for (Language lang : NgramDetector.Companion.getSupported()) {
            loaded.add(this.read(this.getResource(loader, lang)));
        }
        return loaded;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LanguageProfile read(@NotNull String input2) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)input2, (String)"input");
        JSON jSON = JSON.INSTANCE;
        Object serializer$iv = (DeserializationStrategy)SerializedProfile.Companion.serializer();
        boolean $i$f$parse = false;
        SerializedProfile profile = (SerializedProfile)this_$iv.getJson().decodeFromString(serializer$iv, input2);
        try {
            serializer$iv = Language.Companion.getByIsoCode6391(LanguageISO.valueOf(TextKt.toInvariantUpperCase(profile.getName())));
        }
        catch (Exception e) {
            throw (Throwable)new IllegalStateException("Profile file name logic was changed in v0.5, please update your custom profiles!", e);
        }
        Object locale = serializer$iv;
        HashMap ngrams = new HashMap();
        Map<String, Integer> map2 = profile.getFreq();
        boolean bl = false;
        for (Map.Entry<String, Integer> entry : map2.entrySet()) {
            Object object;
            void $this$getOrPut$iv;
            Map map3 = ngrams;
            Integer key$iv = entry.getKey().length();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Map answer$iv = new HashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Map ngramMap = (Map)object;
            Integer n = (Integer)ngramMap.get(entry.getKey());
            ngramMap.put(entry.getKey(), (n != null ? n : 0) + ((Number)entry.getValue()).intValue());
        }
        return new LanguageProfileImpl((Language)((Object)locale), ngrams);
    }

    private LanguageProfileReader() {
    }

    static {
        LanguageProfileReader languageProfileReader;
        INSTANCE = languageProfileReader = new LanguageProfileReader();
    }

    @Serializable
    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0087\b\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001d\u001eBI\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fB/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J9\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/intellij/grazie/detector/ngram/profiles/LanguageProfileReader$SerializedProfile;", "", "seen1", "", "name", "", "freq", "", "n_words", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/util/Map;Ljava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/List;)V", "getFreq", "()Ljava/util/Map;", "getN_words", "()Ljava/util/List;", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "$serializer", "Companion", "nlp-detector"})
    public static final class SerializedProfile {
        @NotNull
        private final String name;
        @NotNull
        private final Map<String, Integer> freq;
        @NotNull
        private final List<Integer> n_words;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Map<String, Integer> getFreq() {
            return this.freq;
        }

        @NotNull
        public final List<Integer> getN_words() {
            return this.n_words;
        }

        public SerializedProfile(@NotNull String name, @NotNull Map<String, Integer> freq, @NotNull List<Integer> n_words) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(freq, (String)"freq");
            Intrinsics.checkNotNullParameter(n_words, (String)"n_words");
            this.name = name;
            this.freq = freq;
            this.n_words = n_words;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final Map<String, Integer> component2() {
            return this.freq;
        }

        @NotNull
        public final List<Integer> component3() {
            return this.n_words;
        }

        @NotNull
        public final SerializedProfile copy(@NotNull String name, @NotNull Map<String, Integer> freq, @NotNull List<Integer> n_words) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(freq, (String)"freq");
            Intrinsics.checkNotNullParameter(n_words, (String)"n_words");
            return new SerializedProfile(name, freq, n_words);
        }

        public static /* synthetic */ SerializedProfile copy$default(SerializedProfile serializedProfile, String string, Map map2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = serializedProfile.name;
            }
            if ((n & 2) != 0) {
                map2 = serializedProfile.freq;
            }
            if ((n & 4) != 0) {
                list = serializedProfile.n_words;
            }
            return serializedProfile.copy(string, map2, list);
        }

        @NotNull
        public String toString() {
            return "SerializedProfile(name=" + this.name + ", freq=" + this.freq + ", n_words=" + this.n_words + ")";
        }

        public int hashCode() {
            String string = this.name;
            Map<String, Integer> map2 = this.freq;
            List<Integer> list = this.n_words;
            return ((string != null ? string.hashCode() : 0) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof SerializedProfile)) break block3;
                    SerializedProfile serializedProfile = (SerializedProfile)object;
                    if (!Intrinsics.areEqual((Object)this.name, (Object)serializedProfile.name) || !Intrinsics.areEqual(this.freq, serializedProfile.freq) || !Intrinsics.areEqual(this.n_words, serializedProfile.n_words)) break block3;
                }
                return true;
            }
            return false;
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ SerializedProfile(int seen1, String name, Map<String, Integer> freq, List<Integer> n_words, SerializationConstructorMarker serializationConstructorMarker) {
            if ((seen1 & 1) == 0) {
                throw (Throwable)new MissingFieldException("name");
            }
            this.name = name;
            if ((seen1 & 2) == 0) {
                throw (Throwable)new MissingFieldException("freq");
            }
            this.freq = freq;
            if ((seen1 & 4) == 0) {
                throw (Throwable)new MissingFieldException("n_words");
            }
            this.n_words = n_words;
        }

        @JvmStatic
        public static final void write$Self(@NotNull SerializedProfile self, @NotNull CompositeEncoder output2, @NotNull SerialDescriptor serialDesc) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)output2, (String)"output");
            Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
            output2.encodeStringElement(serialDesc, 0, self.name);
            output2.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, (KSerializer)IntSerializer.INSTANCE), self.freq);
            output2.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)new ArrayListSerializer((KSerializer)IntSerializer.INSTANCE), self.n_words);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lcom/intellij/grazie/detector/ngram/profiles/LanguageProfileReader$SerializedProfile$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/grazie/detector/ngram/profiles/LanguageProfileReader$SerializedProfile;", "nlp-detector"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @NotNull
            public final KSerializer<SerializedProfile> serializer() {
                return (KSerializer)SerializedProfile$$serializer.INSTANCE;
            }
        }
    }
}

