/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.translate;

import java.io.IOException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.translate.SinglePassTranslator;

public final class CsvTranslators {
    private static final char CSV_DELIMITER = ',';
    private static final char CSV_QUOTE = '\"';
    private static final String CSV_QUOTE_STR = String.valueOf('\"');
    private static final String CSV_ESCAPED_QUOTE_STR = CSV_QUOTE_STR + CSV_QUOTE_STR;
    private static final char[] CSV_SEARCH_CHARS = new char[]{',', '\"', '\r', '\n'};

    private CsvTranslators() {
    }

    public static class CsvUnescaper
    extends SinglePassTranslator {
        @Override
        void translateWhole(CharSequence input2, Writer out) throws IOException {
            if (input2.charAt(0) != '\"' || input2.charAt(input2.length() - 1) != '\"') {
                out.write(input2.toString());
                return;
            }
            String quoteless = input2.subSequence(1, input2.length() - 1).toString();
            if (StringUtils.containsAny((CharSequence)quoteless, (char[])CSV_SEARCH_CHARS)) {
                out.write(StringUtils.replace((String)quoteless, (String)CSV_ESCAPED_QUOTE_STR, (String)CSV_QUOTE_STR));
            } else {
                out.write(input2.toString());
            }
        }
    }

    public static class CsvEscaper
    extends SinglePassTranslator {
        @Override
        void translateWhole(CharSequence input2, Writer out) throws IOException {
            String inputSting = input2.toString();
            if (StringUtils.containsNone((CharSequence)inputSting, (char[])CSV_SEARCH_CHARS)) {
                out.write(inputSting);
            } else {
                out.write(34);
                out.write(StringUtils.replace((String)inputSting, (String)CSV_QUOTE_STR, (String)CSV_ESCAPED_QUOTE_STR));
                out.write(34);
            }
        }
    }
}

