/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.Nullable;
import org.languagetool.GlobalConfig;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.language.English;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Rule;
import org.languagetool.rules.en.BritishReplaceRule;
import org.languagetool.rules.en.MorfologikBritishSpellerRule;
import org.languagetool.rules.en.UnitConversionRuleImperial;
import org.languagetool.rules.spelling.SpellingCheckRule;

public class BritishEnglish
extends English {
    @Override
    public String[] getCountries() {
        return new String[]{"GB"};
    }

    @Override
    public String getName() {
        return "English (GB)";
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules2 = new ArrayList<Rule>();
        rules2.addAll(super.getRelevantRules(messages, userConfig, motherTongue, altLanguages));
        rules2.add(new BritishReplaceRule(messages, "/en/en-GB/replace.txt"));
        rules2.add(new UnitConversionRuleImperial(messages));
        return rules2;
    }

    @Override
    public SpellingCheckRule createDefaultSpellingRule(ResourceBundle messages) throws IOException {
        return new MorfologikBritishSpellerRule(messages, this, null, Collections.emptyList());
    }

    @Override
    public List<Rule> getRelevantLanguageModelCapableRules(ResourceBundle messages, @Nullable LanguageModel lm, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> rules2 = new ArrayList<Rule>(super.getRelevantLanguageModelCapableRules(messages, lm, globalConfig, userConfig, motherTongue, altLanguages));
        rules2.add(new MorfologikBritishSpellerRule(messages, this, globalConfig, userConfig, altLanguages, lm, motherTongue));
        return rules2;
    }

    @Override
    protected int getPriorityForId(String id) {
        switch (id) {
            case "OXFORD_SPELLING_ISATION_NOUNS": {
                return -20;
            }
            case "OXFORD_SPELLING_ISE_VERBS": {
                return -21;
            }
            case "OXFORD_SPELLING_IZE": {
                return -22;
            }
        }
        return super.getPriorityForId(id);
    }
}

