/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.Language;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.RuleMatchFilter;
import org.languagetool.rules.patterns.RuleSet;

public class LanguageDependentFilter
implements RuleMatchFilter {
    protected Language language;
    protected Set<String> enabledRules;
    protected Set<CategoryId> disabledCategories;
    private static final Pattern CA_OLD_DIACRITICS = Pattern.compile(".*\\b(d\u00f3na|v\u00e9nen|v\u00e9ns|f\u00f3ra)\\b.*", 66);
    private static final Pattern ES_CONTRACTIONS = Pattern.compile("\\b([Aa]|[Dd]e) e(l)\\b");

    public LanguageDependentFilter(Language lang, RuleSet rules2) {
        this.language = lang;
        this.enabledRules = rules2.allRuleIds();
    }

    @Override
    public List<RuleMatch> filter(List<RuleMatch> ruleMatches) {
        if (this.language.getShortCode().equals("ca")) {
            if (this.enabledRules.contains("APOSTROF_TIPOGRAFIC") || !this.enabledRules.contains("DIACRITICS_TRADITIONAL_RULES")) {
                ArrayList<RuleMatch> newRuleMatches = new ArrayList<RuleMatch>();
                for (RuleMatch rm : ruleMatches) {
                    List<String> replacements = rm.getSuggestedReplacements();
                    ArrayList<String> newReplacements = new ArrayList<String>();
                    for (String s : replacements) {
                        if (this.enabledRules.contains("APOSTROF_TIPOGRAFIC") && s.length() > 1) {
                            s = s.replace("'", "\u2019");
                        }
                        Matcher m = CA_OLD_DIACRITICS.matcher(s);
                        if (!this.enabledRules.contains("DIACRITICS_TRADITIONAL_RULES") && m.matches()) continue;
                        newReplacements.add(s);
                    }
                    RuleMatch newMatch = new RuleMatch(rm, newReplacements);
                    newRuleMatches.add(newMatch);
                }
                return newRuleMatches;
            }
        } else if (this.language.getShortCode().equals("fr")) {
            if (this.enabledRules.contains("APOS_TYP")) {
                ArrayList<RuleMatch> newRuleMatches = new ArrayList<RuleMatch>();
                for (RuleMatch rm : ruleMatches) {
                    List<String> replacements = rm.getSuggestedReplacements();
                    ArrayList<String> newReplacements = new ArrayList<String>();
                    for (String s : replacements) {
                        if (s.length() > 1) {
                            s = s.replace("'", "\u2019");
                        }
                        newReplacements.add(s);
                    }
                    RuleMatch newMatch = new RuleMatch(rm, newReplacements);
                    newRuleMatches.add(newMatch);
                }
                return newRuleMatches;
            }
        } else if (this.language.getShortCode().equals("es")) {
            ArrayList<RuleMatch> newRuleMatches = new ArrayList<RuleMatch>();
            for (RuleMatch rm : ruleMatches) {
                List<String> replacements = rm.getSuggestedReplacements();
                ArrayList<String> newReplacements = new ArrayList<String>();
                for (String s : replacements) {
                    Matcher m = ES_CONTRACTIONS.matcher(s);
                    s = m.replaceAll("$1$2");
                    newReplacements.add(s);
                }
                RuleMatch newMatch = new RuleMatch(rm, newReplacements);
                newRuleMatches.add(newMatch);
            }
            return newRuleMatches;
        }
        return ruleMatches;
    }
}

