/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.Tag;
import org.languagetool.UserConfig;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tools.Tools;

public class LongParagraphRule
extends TextLevelRule {
    public static final String RULE_ID = "TOO_LONG_PARAGRAPH";
    private static final boolean DEFAULT_ACTIVATION = false;
    private static final int DEFAULT_MAX_WORDS = 220;
    private final Language lang;
    private int maxWords = 220;

    public LongParagraphRule(ResourceBundle messages, Language lang, UserConfig userConfig, int defaultWords, boolean defaultActive) {
        super(messages);
        int confWords;
        super.setCategory(Categories.STYLE.getCategory(messages));
        this.lang = lang;
        if (!defaultActive) {
            this.setDefaultOff();
        }
        if (defaultWords > 0) {
            this.maxWords = defaultWords;
        }
        if (userConfig != null && (confWords = userConfig.getConfigValueByID(this.getId())) > 0) {
            this.maxWords = confWords;
        }
        this.setLocQualityIssueType(ITSIssueType.Style);
        this.setTags(Arrays.asList(Tag.picky));
    }

    public LongParagraphRule(ResourceBundle messages, Language lang, UserConfig userConfig, int defaultWords) {
        this(messages, lang, userConfig, defaultWords, false);
    }

    public LongParagraphRule(ResourceBundle messages, Language lang, UserConfig userConfig) {
        this(messages, lang, userConfig, -1, true);
    }

    @Override
    public String getDescription() {
        return MessageFormat.format(this.messages.getString("long_paragraph_rule_desc"), this.maxWords);
    }

    @Override
    public String getId() {
        return RULE_ID;
    }

    @Override
    public int getDefaultValue() {
        return this.maxWords;
    }

    @Override
    public boolean hasConfigurableValue() {
        return true;
    }

    @Override
    public int getMinConfigurableValue() {
        return 5;
    }

    @Override
    public int getMaxConfigurableValue() {
        return 300;
    }

    @Override
    public String getConfigureText() {
        return this.messages.getString("guiLongParagraphsText");
    }

    public String getMessage() {
        return MessageFormat.format(this.messages.getString("long_paragraph_rule_msg"), this.maxWords);
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences2) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int pos = 0;
        int startPos = 0;
        int endPos = 0;
        int wordCount = 0;
        boolean paraHasLinebreaks = false;
        for (int n = 0; n < sentences2.size(); ++n) {
            AnalyzedTokenReadings[] tokens;
            AnalyzedSentence sentence = sentences2.get(n);
            boolean paragraphEnd = Tools.isParagraphEnd(sentences2, n, this.lang);
            if (!paragraphEnd && sentence.getText().replaceFirst("^\n+", "").contains("\n")) {
                paraHasLinebreaks = true;
            }
            for (AnalyzedTokenReadings token : tokens = sentence.getTokensWithoutWhitespace()) {
                if (token.isWhitespace() || token.isSentenceStart() || token.isNonWord() || ++wordCount != this.maxWords) continue;
                startPos = token.getStartPos() + pos;
                endPos = token.getEndPos() + pos;
            }
            if (paragraphEnd) {
                if (wordCount > this.maxWords + 5 && !paraHasLinebreaks) {
                    RuleMatch ruleMatch = new RuleMatch(this, sentence, startPos, endPos, this.getMessage());
                    ruleMatches.add(ruleMatch);
                }
                wordCount = 0;
                paraHasLinebreaks = false;
            }
            pos += sentence.getCorrectedTextLength();
        }
        if (wordCount > this.maxWords) {
            RuleMatch ruleMatch = new RuleMatch(this, startPos, endPos, this.getMessage());
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return 0;
    }
}

