/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class RemoteRuleConfig {
    private static final int DEFAULT_PORT = 443;
    private static final int DEFAULT_RETRIES = 0;
    private static final long DEFAULT_BASE_TIMEOUT = 1000L;
    private static final float DEFAULT_TIMEOUT_PER_CHAR = 0.0f;
    private static final long DEFAULT_TIMEOUT_LIMIT_INTERVAL = 60000L;
    private static final long DEFAULT_TIMEOUT_LIMIT_TOTAL = 10000L;
    private static final int DEFAULT_FALL = 1;
    private static final int DEFAULT_DOWN = 5000;
    private static final LoadingCache<File, List<RemoteRuleConfig>> configCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<File, List<RemoteRuleConfig>>(){

        public List<RemoteRuleConfig> load(File path) throws Exception {
            try (FileInputStream in = new FileInputStream(path);){
                List<RemoteRuleConfig> list = RemoteRuleConfig.parse(in);
                return list;
            }
        }
    });
    private final String ruleId;
    private final String url;
    private final Integer port;
    private final Integer maxRetries;
    private final Long baseTimeoutMilliseconds;
    private final Float timeoutPerCharacterMilliseconds;
    private final Integer fall;
    private final Long downMilliseconds;
    private final Long timeoutLimitTotalMilliseconds;
    private final Long timeoutLimitIntervalMilliseconds;
    private final Map<String, String> options;

    @JsonCreator
    public RemoteRuleConfig(@JsonProperty(value="ruleId") String ruleId, @JsonProperty(value="url") String url2, @JsonProperty(value="port") Integer port, @JsonProperty(value="maxRetries") Integer maxRetries, @JsonProperty(value="baseTimeoutMilliseconds") Long baseTimeoutMilliseconds, @JsonProperty(value="timeoutPerCharacterMilliseconds") Float timeoutPerCharacterMilliseconds, @JsonProperty(value="fall") Integer fall, @JsonProperty(value="downMilliseconds") Long downMilliseconds, @JsonProperty(value="timeoutLimitTotalMilliseconds") Long timeoutLimitTotalMilliseconds, @JsonProperty(value="timeoutLimitIntervalMilliseconds") Long timeoutLimitIntervalMilliseconds, @JsonProperty(value="options") Map<String, String> options) {
        this.ruleId = ruleId;
        this.url = url2;
        this.port = port;
        this.maxRetries = maxRetries;
        this.baseTimeoutMilliseconds = baseTimeoutMilliseconds;
        this.timeoutPerCharacterMilliseconds = timeoutPerCharacterMilliseconds;
        this.fall = fall;
        this.downMilliseconds = downMilliseconds;
        this.timeoutLimitTotalMilliseconds = timeoutLimitTotalMilliseconds;
        this.timeoutLimitIntervalMilliseconds = timeoutLimitIntervalMilliseconds;
        this.options = Collections.unmodifiableMap(options != null ? options : Collections.emptyMap());
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getUrl() {
        return this.url;
    }

    public int getPort() {
        return this.port != null ? this.port : 443;
    }

    public int getMaxRetries() {
        return this.maxRetries != null ? this.maxRetries : 0;
    }

    public int getFall() {
        return this.fall != null ? this.fall : 1;
    }

    public long getDownMilliseconds() {
        return this.downMilliseconds != null ? this.downMilliseconds : 5000L;
    }

    public long getBaseTimeoutMilliseconds() {
        return this.baseTimeoutMilliseconds != null ? this.baseTimeoutMilliseconds : 1000L;
    }

    public float getTimeoutPerCharacterMilliseconds() {
        return this.timeoutPerCharacterMilliseconds != null ? this.timeoutPerCharacterMilliseconds.floatValue() : 0.0f;
    }

    public Long getTimeoutLimitIntervalMilliseconds() {
        return this.timeoutLimitIntervalMilliseconds != null ? this.timeoutLimitIntervalMilliseconds : 60000L;
    }

    public Long getTimeoutLimitTotalMilliseconds() {
        return this.timeoutLimitTotalMilliseconds != null ? this.timeoutLimitTotalMilliseconds : 10000L;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteRuleConfig that = (RemoteRuleConfig)o;
        return new EqualsBuilder().append((Object)this.ruleId, (Object)that.ruleId).append((Object)this.url, (Object)that.url).append((Object)this.port, (Object)that.port).append((Object)this.maxRetries, (Object)that.maxRetries).append((Object)this.baseTimeoutMilliseconds, (Object)that.baseTimeoutMilliseconds).append((Object)this.timeoutPerCharacterMilliseconds, (Object)that.timeoutPerCharacterMilliseconds).append((Object)this.timeoutLimitIntervalMilliseconds, (Object)that.timeoutLimitIntervalMilliseconds).append((Object)this.timeoutLimitTotalMilliseconds, (Object)that.timeoutLimitTotalMilliseconds).append((Object)this.fall, (Object)that.fall).append((Object)this.downMilliseconds, (Object)that.downMilliseconds).append(this.options, that.options).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.ruleId).append((Object)this.url).append((Object)this.port).append((Object)this.maxRetries).append((Object)this.baseTimeoutMilliseconds).append((Object)this.timeoutPerCharacterMilliseconds).append((Object)this.timeoutLimitIntervalMilliseconds).append((Object)this.timeoutLimitTotalMilliseconds).append((Object)this.fall).append((Object)this.downMilliseconds).append(this.options).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("ruleId", (Object)this.ruleId).append("url", (Object)this.url).append("port", (Object)this.port).append("maxRetries", (Object)this.maxRetries).append("baseTimeout", (Object)this.baseTimeoutMilliseconds).append("timeoutPerCharacter", (Object)this.timeoutPerCharacterMilliseconds).append("timeoutLimitTotal", (Object)this.timeoutLimitTotalMilliseconds).append("timeoutLimitInterval", (Object)this.timeoutLimitIntervalMilliseconds).append("fall", (Object)this.fall).append("down", (Object)this.downMilliseconds).append("options", this.options).build();
    }

    public static RemoteRuleConfig getRelevantConfig(String rule, List<RemoteRuleConfig> configs) {
        return configs.stream().filter(config -> config.getRuleId().equals(rule)).findFirst().orElse(null);
    }

    public static List<RemoteRuleConfig> parse(InputStream json) throws IOException {
        ObjectMapper mapper = new ObjectMapper(new JsonFactory().enable(JsonParser.Feature.ALLOW_COMMENTS));
        return (List)mapper.readValue(json, (TypeReference)new TypeReference<List<RemoteRuleConfig>>(){});
    }

    public static List<RemoteRuleConfig> load(File configFile) throws ExecutionException {
        return (List)configCache.get((Object)configFile);
    }
}

