/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.language.English;
import org.languagetool.rules.PartialPosTagFilter;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;

public class EnglishPartialPosTagFilter
extends PartialPosTagFilter {
    private final Tagger tagger = new English().getTagger();
    private final Disambiguator disambiguator = new English().getDisambiguator();

    @Override
    protected List<AnalyzedTokenReadings> tag(String token) {
        try {
            List<AnalyzedTokenReadings> tags = this.tagger.tag(Collections.singletonList(token));
            AnalyzedTokenReadings[] atr = tags.toArray(new AnalyzedTokenReadings[tags.size()]);
            AnalyzedSentence disambiguated = this.disambiguator.disambiguate(new AnalyzedSentence(atr));
            return Arrays.asList(disambiguated.getTokens());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not tag and disambiguate '" + token + "'", e);
        }
    }
}

