/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Example;
import org.languagetool.rules.WordRepeatBeginningRule;

public class EnglishWordRepeatBeginningRule
extends WordRepeatBeginningRule {
    private static final Set<String> ADD_ADVERBS = new HashSet<String>();
    private static final Set<String> CONTRAST_ADVERBS = new HashSet<String>();
    private static final Set<String> EMPHASIS_ADVERBS = new HashSet<String>();
    private static final Set<String> EXPLAIN_ADVERBS = new HashSet<String>();
    private static final List<String> ADD_EXPRESSIONS = Arrays.asList("In addition", "As well as");
    private static final List<String> CONTRAST_EXPRESSIONS = Arrays.asList("Even so", "On the other hand");

    public EnglishWordRepeatBeginningRule(ResourceBundle messages, Language language) {
        super(messages, language);
        this.addExamplePair(Example.wrong("Moreover, the street is almost entirely residential. <marker>Moreover</marker>, it was named after a poet."), Example.fixed("Moreover, the street is almost entirely residential. <marker>It</marker> was named after a poet."));
    }

    @Override
    public String getId() {
        return "ENGLISH_WORD_REPEAT_BEGINNING_RULE";
    }

    @Override
    public boolean isException(String token) {
        return super.isException(token) || token.equals("The") || token.equals("A") || token.equals("An");
    }

    @Override
    protected boolean isAdverb(AnalyzedTokenReadings token) {
        String tok = token.getToken();
        return ADD_ADVERBS.contains(tok) || CONTRAST_ADVERBS.contains(tok) || EMPHASIS_ADVERBS.contains(tok) || EXPLAIN_ADVERBS.contains(tok);
    }

    @Override
    protected List<String> getSuggestions(AnalyzedTokenReadings token) {
        String tok = token.getToken();
        if (token.hasPosTag("PRP")) {
            String adaptedToken = tok.equals("I") ? tok : tok.toLowerCase();
            return Arrays.asList("Furthermore, " + adaptedToken, "Likewise, " + adaptedToken, "Not only that, but " + adaptedToken);
        }
        if (ADD_ADVERBS.contains(tok)) {
            List<String> addSuggestions = this.getDifferentAdverbsOfSameCategory(tok, ADD_ADVERBS);
            addSuggestions.addAll(ADD_EXPRESSIONS);
            return addSuggestions;
        }
        if (CONTRAST_ADVERBS.contains(tok)) {
            List<String> contrastSuggestions = this.getDifferentAdverbsOfSameCategory(tok, CONTRAST_ADVERBS);
            contrastSuggestions.addAll(CONTRAST_EXPRESSIONS);
            return contrastSuggestions;
        }
        if (EMPHASIS_ADVERBS.contains(tok)) {
            return this.getDifferentAdverbsOfSameCategory(tok, EMPHASIS_ADVERBS);
        }
        if (EXPLAIN_ADVERBS.contains(tok)) {
            return this.getDifferentAdverbsOfSameCategory(tok, EXPLAIN_ADVERBS);
        }
        return Collections.emptyList();
    }

    private List<String> getDifferentAdverbsOfSameCategory(String adverb, Set<String> adverbsOfCategory) {
        return adverbsOfCategory.stream().filter(adv -> !adv.equals(adverb)).collect(Collectors.toList());
    }

    static {
        ADD_ADVERBS.add("Additionally");
        ADD_ADVERBS.add("Besides");
        ADD_ADVERBS.add("Furthermore");
        ADD_ADVERBS.add("Moreover");
        ADD_ADVERBS.add("Also");
        CONTRAST_ADVERBS.add("Nevertheless");
        CONTRAST_ADVERBS.add("Nonetheless");
        CONTRAST_ADVERBS.add("Alternatively");
        EMPHASIS_ADVERBS.add("Undoubtedly");
        EMPHASIS_ADVERBS.add("Indeed");
        EMPHASIS_ADVERBS.add("Obviously");
        EMPHASIS_ADVERBS.add("Clearly");
        EMPHASIS_ADVERBS.add("Importantly");
        EMPHASIS_ADVERBS.add("Absolutely");
        EMPHASIS_ADVERBS.add("Definetely");
        EXPLAIN_ADVERBS.add("Particularly");
        EXPLAIN_ADVERBS.add("Especially");
        EXPLAIN_ADVERBS.add("Specifically");
    }
}

