/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.synthesis.en;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedToken;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.rules.en.AvsAnRule;
import org.languagetool.synthesis.BaseSynthesizer;
import org.languagetool.tools.StringTools;

public class EnglishSynthesizer
extends BaseSynthesizer {
    private static final String RESOURCE_FILENAME = "/en/english_synth.dict";
    private static final String TAGS_FILE_NAME = "/en/english_tags.txt";
    private static final String SOR_FILE_NAME = "/en/en.sor";
    private static final List<String> exceptions = Arrays.asList("e'er", "o'er", "ol'", "ma'am", "n't", "informations");
    private static final String ADD_DETERMINER = "+DT";
    private static final String ADD_IND_DETERMINER = "+INDT";
    private final AvsAnRule aVsAnRule = new AvsAnRule(JLanguageTool.getMessageBundle(Languages.getLanguageForShortCode("en")));

    public EnglishSynthesizer(Language lang) {
        super(SOR_FILE_NAME, RESOURCE_FILENAME, TAGS_FILE_NAME, lang);
    }

    @Override
    public String[] synthesize(AnalyzedToken token, String posTag) throws IOException {
        if (posTag.startsWith("_spell_number_")) {
            return super.synthesize(token, posTag);
        }
        String aOrAn = this.aVsAnRule.suggestAorAn(token.getToken());
        if (ADD_DETERMINER.equals(posTag)) {
            return new String[]{aOrAn, "the " + StringTools.lowercaseFirstCharIfCapitalized(token.getToken())};
        }
        if (ADD_IND_DETERMINER.equals(posTag)) {
            return new String[]{aOrAn};
        }
        return this.removeExceptions(super.synthesize(token, posTag));
    }

    @Override
    public String[] synthesize(AnalyzedToken token, String posTag, boolean posTagRegExp) throws IOException {
        if (posTag.startsWith("_spell_number_")) {
            return this.synthesize(token, posTag);
        }
        if (posTagRegExp) {
            String myPosTag = posTag;
            String det = "";
            if (posTag.endsWith(ADD_IND_DETERMINER)) {
                myPosTag = myPosTag.substring(0, myPosTag.indexOf(ADD_IND_DETERMINER) - "\\".length());
                det = this.aVsAnRule.suggestAorAn(token.getLemma());
                det = det.substring(0, det.indexOf(32) + " ".length());
            } else if (posTag.endsWith(ADD_DETERMINER)) {
                myPosTag = myPosTag.substring(0, myPosTag.indexOf(ADD_DETERMINER) - "\\".length());
                det = "the ";
            }
            this.initPossibleTags();
            Pattern p2 = Pattern.compile(myPosTag);
            ArrayList<String> results = new ArrayList<String>();
            for (String tag : this.possibleTags) {
                Matcher m = p2.matcher(tag);
                if (!m.matches() || token.getLemma() == null) continue;
                this.lookup(token.getLemma(), tag, results, det);
            }
            return this.removeExceptions(results.toArray(new String[0]));
        }
        return this.removeExceptions(this.synthesize(token, posTag));
    }

    private void lookup(String lemma, String posTag, List<String> results, String determiner) {
        List<String> lookup = super.lookup(lemma, posTag);
        for (String result2 : lookup) {
            results.add(determiner + result2);
        }
    }

    @Override
    protected boolean isException(String w) {
        return w.startsWith("'") || exceptions.contains(w);
    }
}

