/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.UnitConverter;
import tec.uom.lib.common.function.DoubleFactorSupplier;
import tec.uom.lib.common.function.ValueSupplier;
import tech.units.indriya.AbstractConverter;

public final class MultiplyConverter
extends AbstractConverter
implements ValueSupplier<Double>,
DoubleFactorSupplier {
    private static final long serialVersionUID = 6588759878444545649L;
    private final double factor;

    public MultiplyConverter(double factor) {
        this.factor = factor;
    }

    public static MultiplyConverter of(double factor) {
        return new MultiplyConverter(factor);
    }

    @Override
    public double getFactor() {
        return this.factor;
    }

    @Override
    public boolean isIdentity() {
        return this.factor == 1.0;
    }

    @Override
    protected boolean isSimpleCompositionWith(AbstractConverter that) {
        return that instanceof MultiplyConverter;
    }

    @Override
    protected AbstractConverter simpleCompose(AbstractConverter that) {
        return new MultiplyConverter(this.factor * ((MultiplyConverter)that).factor);
    }

    @Override
    public MultiplyConverter inverseWhenNotIdentity() {
        return new MultiplyConverter(1.0 / this.factor);
    }

    @Override
    public double convertWhenNotIdentity(double value) {
        return value * this.factor;
    }

    @Override
    public BigDecimal convertWhenNotIdentity(BigDecimal value, MathContext ctx) throws ArithmeticException {
        return value.multiply(BigDecimal.valueOf(this.factor), ctx);
    }

    @Override
    public final String transformationLiteral() {
        return String.format("x -> x * %s", this.factor);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MultiplyConverter) {
            MultiplyConverter that = (MultiplyConverter)obj;
            return Objects.equals(this.factor, that.factor);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.factor);
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public Double getValue() {
        return this.factor;
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof MultiplyConverter) {
            return this.getValue().compareTo(((MultiplyConverter)o).getValue());
        }
        return -1;
    }
}

