/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Objects;
import javax.measure.UnitConverter;
import tech.units.indriya.AbstractConverter;
import tech.units.indriya.function.Constants;

public final class PowersOfPiConverter
extends AbstractConverter {
    private static final long serialVersionUID = 5000593326722785126L;
    private final int exponent;
    private final int hashCode;
    private final double doubleFactor;

    public static PowersOfPiConverter of(int exponent) {
        return new PowersOfPiConverter(exponent);
    }

    protected PowersOfPiConverter(int exponent) {
        this.exponent = exponent;
        this.doubleFactor = Math.pow(Math.PI, exponent);
        this.hashCode = Objects.hash(exponent);
    }

    public int getExponent() {
        return this.exponent;
    }

    @Override
    public boolean isIdentity() {
        return this.exponent == 0;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public AbstractConverter inverseWhenNotIdentity() {
        return new PowersOfPiConverter(-this.exponent);
    }

    @Override
    public BigDecimal convertWhenNotIdentity(BigDecimal value, MathContext ctx) throws ArithmeticException {
        int nbrDigits = ctx.getPrecision();
        if (nbrDigits == 0) {
            throw new ArithmeticException("Pi multiplication with unlimited precision");
        }
        BigDecimal pi = Constants.Pi.ofNumDigits(nbrDigits);
        return pi.pow(this.exponent, ctx).multiply(value);
    }

    @Override
    public double convertWhenNotIdentity(double value) {
        return value * this.doubleFactor;
    }

    @Override
    protected boolean isSimpleCompositionWith(AbstractConverter that) {
        return that instanceof PowersOfPiConverter;
    }

    @Override
    protected AbstractConverter simpleCompose(AbstractConverter that) {
        return new PowersOfPiConverter(this.exponent + ((PowersOfPiConverter)that).exponent);
    }

    @Override
    public boolean equals(Object obj) {
        UnitConverter other;
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnitConverter) {
            other = (UnitConverter)obj;
            if (this.isIdentity() && other.isIdentity()) {
                return true;
            }
        }
        if (obj instanceof PowersOfPiConverter) {
            other = (PowersOfPiConverter)obj;
            return this.exponent == ((PowersOfPiConverter)other).exponent;
        }
        return false;
    }

    @Override
    public final String transformationLiteral() {
        return String.format("x -> x * \u03c0^%s", this.exponent);
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (this.isIdentity() && o.isIdentity()) {
            return 0;
        }
        if (o instanceof PowersOfPiConverter) {
            PowersOfPiConverter other = (PowersOfPiConverter)o;
            return Integer.compare(this.exponent, other.exponent);
        }
        return this.getClass().getName().compareTo(o.getClass().getName());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }
}

