/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util.classFinder;

import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.classFinder.ClassEntry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathEntry {
    private final ClassLoader myClassLoader;
    private final String myClassPathEntry;
    private static final DirectoryEntryProcessor myDirectoryProcessor = new DirectoryEntryProcessor();
    private static final ZipEntryProcessor myZipProcessor = new ZipEntryProcessor();
    private static final String CLASS_FILE_SUFFIX = ".class";

    public ClassPathEntry(String classPathEntry, ClassLoader classLoader) {
        this.myClassPathEntry = classPathEntry;
        this.myClassLoader = classLoader;
    }

    Collection<ClassEntry> getClassesIterator(List<Pattern> includePatterns, List<Pattern> excludePatterns) throws IOException {
        ClassPathEntryProcessor processor = ClassPathEntry.createEntryProcessor(this.myClassPathEntry);
        if (processor == null) {
            return Collections.emptyList();
        }
        processor.setFilter(includePatterns, excludePatterns);
        processor.setClassLoader(this.myClassLoader);
        return processor.findClasses(this.myClassPathEntry);
    }

    private static ClassPathEntryProcessor createEntryProcessor(String entry) {
        File file = new File(entry);
        if (file.isDirectory()) {
            return myDirectoryProcessor;
        }
        if (file.isFile() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"))) {
            return myZipProcessor;
        }
        return null;
    }

    private static String removeClassSuffix(String name) {
        return name.substring(0, name.length() - CLASS_FILE_SUFFIX.length());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassPathEntry that = (ClassPathEntry)o;
        if (this.myClassLoader != null ? !this.myClassLoader.equals(that.myClassLoader) : that.myClassLoader != null) {
            return false;
        }
        return this.myClassPathEntry.equals(that.myClassPathEntry);
    }

    public int hashCode() {
        int result = this.myClassLoader != null ? this.myClassLoader.hashCode() : 0;
        result = 31 * result + this.myClassPathEntry.hashCode();
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZipEntryProcessor
    extends AbstractClassPathEntryProcessor {
        private ZipEntryProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<String> extractClassNames(String classPathEntry) throws IOException {
            ArrayList<String> result = new ArrayList<String>(100);
            ZipFile zipFile = new ZipFile(new File(classPathEntry));
            try {
                Enumeration<? extends ZipEntry> zenum = zipFile.entries();
                while (zenum.hasMoreElements()) {
                    ZipEntry ze = zenum.nextElement();
                    if (ze.isDirectory() || !ze.getName().endsWith(ClassPathEntry.CLASS_FILE_SUFFIX)) continue;
                    result.add(ClassNameUtil.convertToFQName(ClassPathEntry.removeClassSuffix(ze.getName())));
                }
            }
            finally {
                zipFile.close();
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DirectoryEntryProcessor
    extends AbstractClassPathEntryProcessor {
        private DirectoryEntryProcessor() {
        }

        @Override
        protected Collection<String> extractClassNames(String classPathEntry) {
            File dir = new File(classPathEntry);
            ArrayList<String> result = new ArrayList<String>(100);
            String curPath = "";
            DirectoryEntryProcessor.collectClasses(curPath, dir, result);
            return result;
        }

        private static void collectClasses(String curPath, File parent, List<String> result) {
            File[] files = parent.listFiles();
            if (files != null) {
                String prefix = curPath.length() == 0 ? "" : curPath + ".";
                for (File f : files) {
                    String name = f.getName();
                    if (name.endsWith(ClassPathEntry.CLASS_FILE_SUFFIX)) {
                        result.add(prefix + ClassPathEntry.removeClassSuffix(name));
                        continue;
                    }
                    if (!f.isDirectory()) continue;
                    DirectoryEntryProcessor.collectClasses(prefix + name, f, result);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ClassPathEntryProcessor {
        public void setFilter(List<Pattern> var1, List<Pattern> var2);

        public void setClassLoader(ClassLoader var1);

        public Collection<ClassEntry> findClasses(String var1) throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractClassPathEntryProcessor
    implements ClassPathEntryProcessor {
        private List<Pattern> myIncludePatterns;
        private List<Pattern> myExcludePatterns;
        private ClassLoader myClassLoader;

        private AbstractClassPathEntryProcessor() {
        }

        @Override
        public void setFilter(List<Pattern> includePatterns, List<Pattern> excludePatterns) {
            this.myIncludePatterns = includePatterns;
            this.myExcludePatterns = excludePatterns;
        }

        @Override
        public void setClassLoader(ClassLoader classLoader) {
            this.myClassLoader = classLoader;
        }

        protected abstract Collection<String> extractClassNames(String var1) throws IOException;

        @Override
        public Collection<ClassEntry> findClasses(String classPathEntry) throws IOException {
            HashSet<ClassEntry> includedClasses = new HashSet<ClassEntry>();
            for (String o : this.extractClassNames(classPathEntry)) {
                String className = o;
                if (!this.shouldInclude(className)) continue;
                includedClasses.add(new ClassEntry(className, this.myClassLoader));
            }
            return includedClasses;
        }

        private boolean shouldInclude(String className) {
            if (ClassNameUtil.matchesPatterns(className, this.myExcludePatterns)) {
                return false;
            }
            String outerClassName = ClassNameUtil.getOuterClassName(className);
            if (ClassNameUtil.matchesPatterns(outerClassName, this.myIncludePatterns)) {
                return true;
            }
            return this.myIncludePatterns.isEmpty();
        }
    }
}

