/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotatedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticProperty;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderInternals;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderInternals;
import org.jetbrains.kotlin.fir.resolve.providers.impl.FirProviderImpl;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProvider;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.impl.FirAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u0019J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00122\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!H\u0016J\u0016\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020%H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001d\u001a\u00020%H\u0016J\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00120\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010)\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010)\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020-H\u0017J\u0018\u0010.\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020/H\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u00020\u0012*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "kotlinScopeProvider", "Lorg/jetbrains/kotlin/fir/scopes/KotlinScopeProvider;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/scopes/KotlinScopeProvider;)V", "getKotlinScopeProvider", "()Lorg/jetbrains/kotlin/fir/scopes/KotlinScopeProvider;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "state", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "getSymbolProvider", "()Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;", "getFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnnotatedDeclaration;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "ensureConsistent", "", "files", "", "getClassNamesInPackage", "", "Lorg/jetbrains/kotlin/name/Name;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "getFirCallableContainerFile", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "getFirClassifierByFqName", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getFirClassifierContainerFile", "getFirClassifierContainerFileIfAny", "getFirFilesByPackage", "recordFile", "recordGeneratedClass", "owner", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "recordGeneratedMember", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "FirRecorder", "State", "SymbolProvider", "resolve"})
public final class FirProviderImpl
extends FirProvider {
    @NotNull
    private final FirSession session;
    @NotNull
    private final KotlinScopeProvider kotlinScopeProvider;
    @NotNull
    private final FirSymbolProvider symbolProvider;
    @NotNull
    private final State state;

    public FirProviderImpl(@NotNull FirSession session, @NotNull KotlinScopeProvider kotlinScopeProvider2) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)kotlinScopeProvider2, (String)"kotlinScopeProvider");
        this.session = session;
        this.kotlinScopeProvider = kotlinScopeProvider2;
        this.symbolProvider = new SymbolProvider();
        this.state = new State();
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final KotlinScopeProvider getKotlinScopeProvider() {
        return this.kotlinScopeProvider;
    }

    @Override
    @NotNull
    public FirSymbolProvider getSymbolProvider() {
        return this.symbolProvider;
    }

    @Override
    @Nullable
    public FirFile getFirCallableContainerFile(@NotNull FirCallableSymbol<?> symbol2) {
        FirProperty fir;
        FirCallableSymbol firCallableSymbol;
        FirCallableDeclaration firCallableDeclaration;
        FirCallableDeclaration firCallableDeclaration2;
        Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
        FirCallableSymbol<?> $this$originalIfFakeOverride$iv = symbol2;
        boolean $i$f$originalIfFakeOverride = false;
        FirCallableDeclaration $this$originalIfFakeOverride$iv$iv = (FirCallableDeclaration)$this$originalIfFakeOverride$iv.getFir();
        boolean $i$f$originalIfFakeOverride2 = false;
        FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
        boolean $i$f$getOriginalForSubstitutionOverride = false;
        FirCallableDeclaration firCallableDeclaration3 = firCallableDeclaration2 = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv) : null;
        if (firCallableDeclaration2 == null) {
            FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
            boolean $i$f$getBaseForIntersectionOverride = false;
            firCallableDeclaration = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
        } else {
            firCallableDeclaration = firCallableDeclaration2;
        }
        FirCallableDeclaration firCallableDeclaration4 = firCallableDeclaration;
        FirCallableSymbol firCallableSymbol2 = firCallableSymbol = firCallableDeclaration4 == null ? null : firCallableDeclaration4.getSymbol();
        if (firCallableSymbol != null) {
            FirCallableSymbol firCallableSymbol3 = firCallableSymbol;
            boolean bl = false;
            boolean bl2 = false;
            FirCallableSymbol it = firCallableSymbol3;
            boolean bl3 = false;
            return this.getFirCallableContainerFile(it);
        }
        if (symbol2 instanceof FirAccessorSymbol && (fir = (FirProperty)((FirAccessorSymbol)symbol2).getFir()) instanceof FirSyntheticProperty) {
            return this.getFirCallableContainerFile(((FirSyntheticProperty)fir).getGetter().getDelegate().getSymbol());
        }
        return this.state.getCallableContainerMap().get(symbol2);
    }

    @Override
    @NotNull
    public FirFile getFirClassifierContainerFile(@NotNull ClassId fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        FirFile firFile = this.state.getClassifierContainerFileMap().get(fqName2);
        if (firFile == null) {
            String string2 = Intrinsics.stringPlus((String)"Couldn't find container for ", (Object)fqName2);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return firFile;
    }

    @Override
    @Nullable
    public FirFile getFirClassifierContainerFileIfAny(@NotNull ClassId fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return this.state.getClassifierContainerFileMap().get(fqName2);
    }

    public final void recordFile(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.recordFile(file2, this.state);
    }

    @Override
    @FirProviderInternals
    public void recordGeneratedClass(@NotNull FirAnnotatedDeclaration owner, @NotNull FirRegularClass klass) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        klass.accept(FirRecorder.INSTANCE, TuplesKt.to((Object)this.state, (Object)this.getFile(owner)));
    }

    @Override
    @FirProviderInternals
    public void recordGeneratedMember(@NotNull FirAnnotatedDeclaration owner, @NotNull FirDeclaration klass) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        klass.accept(FirRecorder.INSTANCE, TuplesKt.to((Object)this.state, (Object)this.getFile(owner)));
    }

    private final FirFile getFile(FirAnnotatedDeclaration $this$file) {
        FirFile firFile;
        FirAnnotatedDeclaration firAnnotatedDeclaration = $this$file;
        if (firAnnotatedDeclaration instanceof FirFile) {
            firFile = (FirFile)$this$file;
        } else if (firAnnotatedDeclaration instanceof FirRegularClass) {
            firFile = this.getFirClassifierContainerFile(((FirRegularClass)$this$file).getSymbol().getClassId());
        } else {
            String string2 = "Should not be here";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return firFile;
    }

    private final void recordFile(FirFile file2, State state) {
        FqName packageName = file2.getPackageFqName();
        state.getFileMap().merge(packageName, CollectionsKt.listOf((Object)file2), FirProviderImpl::recordFile$lambda-1);
        file2.acceptChildren(FirRecorder.INSTANCE, TuplesKt.to((Object)state, (Object)file2));
    }

    @Override
    @NotNull
    public List<FirFile> getFirFilesByPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        List list2 = this.state.getFileMap().get(fqName2);
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    @Override
    @Nullable
    public FirClassLikeDeclaration<?> getFirClassifierByFqName(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        boolean bl = !classId.isLocal();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Local " + classId + " should never be used to find its corresponding classifier";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        return this.state.getClassifierMap().get(classId);
    }

    public final void ensureConsistent(@NotNull List<? extends FirFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        State newState = new State();
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirFile it = (FirFile)element$iv;
            boolean bl = false;
            this.recordFile(it, newState);
        }
        boolean bl = false;
        List failures = new ArrayList();
        FirProviderImpl.ensureConsistent$checkMMapDiff(failures, "fileMap", this.state.getFileMap(), newState.getFileMap());
        FirProviderImpl.ensureConsistent$checkMapDiff$default(failures, "classifierMap", this.state.getClassifierMap(), newState.getClassifierMap(), null, 16, null);
        FirProviderImpl.ensureConsistent$checkMapDiff$default(failures, "classifierContainerFileMap", this.state.getClassifierContainerFileMap(), newState.getClassifierContainerFileMap(), null, 16, null);
        FirProviderImpl.ensureConsistent$checkMMapDiff(failures, "callableMap", this.state.getFunctionMap(), newState.getFunctionMap());
        FirProviderImpl.ensureConsistent$checkMMapDiff(failures, "callableMap", this.state.getPropertyMap(), newState.getPropertyMap());
        FirProviderImpl.ensureConsistent$checkMMapDiff(failures, "callableMap", this.state.getConstructorMap(), newState.getConstructorMap());
        FirProviderImpl.ensureConsistent$checkMapDiff$default(failures, "callableContainerMap", this.state.getCallableContainerMap(), newState.getCallableContainerMap(), null, 16, null);
        this.state.setFrom(newState);
    }

    @Override
    @NotNull
    public Set<Name> getClassNamesInPackage(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Set<Name> set = this.state.getClassesInPackage().get(fqName2);
        return set == null ? SetsKt.emptySet() : set;
    }

    private static final List recordFile$lambda-1(List a, List b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return CollectionsKt.plus((Collection)a, (Iterable)b);
    }

    /*
     * WARNING - void declaration
     */
    private static final <K, V> void ensureConsistent$checkMapDiff(List<String> failures, String title, Map<K, ? extends V> a, Map<K, ? extends V> b, Function2<? super V, ? super V, Boolean> equal) {
        void $this$mapTo$iv$iv;
        boolean hasTitle = false;
        Set unionKeys = SetsKt.plus(a.keySet(), (Iterable)b.keySet());
        Iterable $this$map$iv = unionKeys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Object object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = object.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Triple triple = new Triple((Object)it, a.get(it), b.get(it));
            collection.add(triple);
        }
        for (Triple triple : (List)destination$iv$iv) {
            Object bValue;
            Object key = triple.component1();
            Object aValue = triple.component2();
            if (((Boolean)equal.invoke(aValue, bValue = triple.component3())).booleanValue()) continue;
            if (!hasTitle) {
                Collection collection = failures;
                boolean bl = false;
                collection.add(title);
                hasTitle = true;
            }
            Collection collection = failures;
            object = "diff at key = '" + key + "': was: '" + aValue + "', become: '" + bValue + '\'';
            boolean bl = false;
            collection.add(object);
        }
    }

    static /* synthetic */ void ensureConsistent$checkMapDiff$default(List list2, String string2, Map map, Map map2, Function2 function2, int n, Object object) {
        if ((n & 0x10) != 0) {
            function2 = ensureConsistent.checkMapDiff.1.INSTANCE;
        }
        FirProviderImpl.ensureConsistent$checkMapDiff(list2, string2, map, map2, function2);
    }

    /*
     * WARNING - void declaration
     */
    private static final <K, V> void ensureConsistent$checkMMapDiff(List<String> failures, String title, Map<K, ? extends List<? extends V>> a, Map<K, ? extends List<? extends V>> b) {
        void $this$mapTo$iv$iv;
        boolean hasTitle = false;
        Set unionKeys = SetsKt.plus(a.keySet(), (Iterable)b.keySet());
        Iterable $this$map$iv = unionKeys;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        Object object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = object.next();
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            Triple triple = new Triple((Object)it, a.get(it), b.get(it));
            collection.add(triple);
        }
        for (Triple triple : (List)destination$iv$iv) {
            boolean bl;
            String string2;
            Collection collection;
            Object it;
            Object element$iv;
            Object key = triple.component1();
            List aValue = (List)triple.component2();
            List bValue = (List)triple.component3();
            if (aValue == null || bValue == null) {
                if (!hasTitle) {
                    Collection $i$f$mapTo2 = failures;
                    boolean bl2 = false;
                    $i$f$mapTo2.add(title);
                    hasTitle = true;
                }
                Collection $i$f$mapTo2 = failures;
                object = "diff at key = '" + key + "': was: " + aValue + ", become: " + bValue;
                boolean item$iv$iv = false;
                $i$f$mapTo2.add(object);
                continue;
            }
            Set aSet = CollectionsKt.toSet((Iterable)aValue);
            Set bSet = CollectionsKt.toSet((Iterable)bValue);
            Set aLost = SetsKt.minus((Set)aSet, (Iterable)bSet);
            Set bNew = SetsKt.minus((Set)bSet, (Iterable)aSet);
            Collection bl3 = aLost;
            boolean bl4 = false;
            if (!(!bl3.isEmpty())) {
                bl3 = bNew;
                bl4 = false;
                if (!(!bl3.isEmpty())) continue;
            }
            bl3 = failures;
            String string3 = "diff at key = '" + key + "':";
            boolean bl5 = false;
            bl3.add(string3);
            bl3 = failures;
            string3 = "    Lost:";
            bl5 = false;
            bl3.add(string3);
            Iterable $this$forEach$iv = aLost;
            boolean $i$f$forEach22 = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                it = element$iv = iterator2.next();
                boolean bl6 = false;
                collection = failures;
                string2 = Intrinsics.stringPlus((String)"     ", it);
                bl = false;
                collection.add(string2);
            }
            $this$forEach$iv = failures;
            String $i$f$forEach22 = "    New:";
            boolean bl7 = false;
            $this$forEach$iv.add($i$f$forEach22);
            $this$forEach$iv = bNew;
            boolean $i$f$forEach = false;
            Iterator iterator3 = $this$forEach$iv.iterator();
            while (iterator3.hasNext()) {
                it = element$iv = iterator3.next();
                boolean bl8 = false;
                collection = failures;
                string2 = Intrinsics.stringPlus((String)"     ", it);
                bl = false;
                collection.add(string2);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0016J*\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J&\u0010\u0012\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017J&\u0010\u0014\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00150\r2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0017\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$SymbolProvider;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "(Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl;)V", "getClassLikeSymbolByFqName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "getPackage", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "getTopLevelCallableSymbolsTo", "", "destination", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "packageFqName", "name", "Lorg/jetbrains/kotlin/name/Name;", "getTopLevelFunctionSymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getTopLevelPropertySymbolsTo", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "resolve"})
    private final class SymbolProvider
    extends FirSymbolProvider {
        public SymbolProvider() {
            Intrinsics.checkNotNullParameter((Object)FirProviderImpl.this, (String)"this$0");
            super(FirProviderImpl.this.getSession());
        }

        @Override
        @Nullable
        public FirClassLikeSymbol<?> getClassLikeSymbolByFqName(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            FirClassLikeDeclaration<?> firClassLikeDeclaration = FirProviderImpl.this.getFirClassifierByFqName(classId);
            return firClassLikeDeclaration == null ? null : firClassLikeDeclaration.getSymbol();
        }

        @Override
        @FirSymbolProviderInternals
        public void getTopLevelCallableSymbolsTo(@NotNull List<FirCallableSymbol<?>> destination, @NotNull FqName packageFqName, @NotNull Name name) {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Collection collection = destination;
            Iterable<FirCallableSymbol> iterable = FirProviderImpl.this.state.getFunctionMap().get(new CallableId(packageFqName, null, name, null, 8, null));
            iterable = iterable == null ? (Iterable)CollectionsKt.emptyList() : (Iterable)iterable;
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, iterable);
            collection = destination;
            iterable = FirProviderImpl.this.state.getPropertyMap().get(new CallableId(packageFqName, null, name, null, 8, null));
            iterable = iterable == null ? (Iterable)CollectionsKt.emptyList() : (Iterable)iterable;
            bl = false;
            CollectionsKt.addAll((Collection)collection, iterable);
        }

        @Override
        @FirSymbolProviderInternals
        public void getTopLevelFunctionSymbolsTo(@NotNull List<FirNamedFunctionSymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Collection collection = destination;
            Iterable<FirNamedFunctionSymbol> iterable = FirProviderImpl.this.state.getFunctionMap().get(new CallableId(packageFqName, null, name, null, 8, null));
            iterable = iterable == null ? (Iterable)CollectionsKt.emptyList() : (Iterable)iterable;
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, iterable);
        }

        @Override
        @FirSymbolProviderInternals
        public void getTopLevelPropertySymbolsTo(@NotNull List<FirPropertySymbol> destination, @NotNull FqName packageFqName, @NotNull Name name) {
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Collection collection = destination;
            Iterable<FirPropertySymbol> iterable = FirProviderImpl.this.state.getPropertyMap().get(new CallableId(packageFqName, null, name, null, 8, null));
            iterable = iterable == null ? (Iterable)CollectionsKt.emptyList() : (Iterable)iterable;
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, iterable);
        }

        @Override
        @Nullable
        public FqName getPackage(@NotNull FqName fqName2) {
            Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
            Collection collection = FirProviderImpl.this.getFirFilesByPackage(fqName2);
            boolean bl = false;
            if (!collection.isEmpty()) {
                return fqName2;
            }
            return null;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0006Jf\u0010\u0007\u001a\u00020\u0002\"\u0010\b\u0000\u0010\b\u0018\u0001*\b\u0012\u0004\u0012\u0002H\b0\t\"\u000e\b\u0001\u0010\n*\b\u0012\u0004\u0012\u0002H\b0\u000b2\u0006\u0010\f\u001a\u0002H\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u00110\u000fH\u0082\b\u00a2\u0006\u0002\u0010\u0012J$\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J$\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J$\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J$\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J$\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J$\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J$\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J$\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020*2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$FirRecorder;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "()V", "registerCallable", "D", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableMemberDeclaration;", "S", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "symbol", "data", "map", "", "Lorg/jetbrains/kotlin/fir/symbols/CallableId;", "", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lkotlin/Pair;Ljava/util/Map;)V", "visitConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "visitProperty", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "visitPropertyAccessor", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "visitRegularClass", "regularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "visitSimpleFunction", "simpleFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "resolve"})
    private static final class FirRecorder
    extends FirDefaultVisitor<Unit, Pair<? extends State, ? extends FirFile>> {
        @NotNull
        public static final FirRecorder INSTANCE = new FirRecorder();

        private FirRecorder() {
        }

        @Override
        public void visitElement(@NotNull FirElement element, @NotNull Pair<State, ? extends FirFile> data) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter(data, (String)"data");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull Pair<State, ? extends FirFile> data) {
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            ClassId classId = regularClass.getSymbol().getClassId();
            Pair<State, ? extends FirFile> pair = data;
            State state = (State)pair.component1();
            FirFile file2 = (FirFile)pair.component2();
            Object object = state.getClassifierMap();
            boolean bl = false;
            object.put((ClassId)classId, regularClass);
            object = state.getClassifierContainerFileMap();
            bl = false;
            object.put((ClassId)classId, file2);
            if (!classId.isNestedClass() && !classId.isLocal()) {
                Object object2;
                void $this$getOrPut$iv;
                object = state.getClassesInPackage();
                FqName fqName2 = classId.getPackageFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.packageFqName");
                FqName key$iv = fqName2;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                Set set = (Set)object2;
                object = classId.getShortClassName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"classId.shortClassName");
                set.add(object);
            }
            regularClass.acceptChildren(this, data);
        }

        @Override
        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, @NotNull Pair<State, ? extends FirFile> data) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            ClassId classId = typeAlias.getSymbol().getClassId();
            Pair<State, ? extends FirFile> pair = data;
            State state = (State)pair.component1();
            FirFile file2 = (FirFile)pair.component2();
            Map<ClassId, FirAnnotatedDeclaration> map = state.getClassifierMap();
            boolean bl = false;
            map.put(classId, typeAlias);
            map = state.getClassifierContainerFileMap();
            bl = false;
            map.put(classId, file2);
        }

        @Override
        public void visitPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, @NotNull Pair<State, ? extends FirFile> data) {
            Intrinsics.checkNotNullParameter((Object)propertyAccessor, (String)"propertyAccessor");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            FirPropertyAccessorSymbol symbol2 = propertyAccessor.getSymbol();
            Pair<State, ? extends FirFile> pair = data;
            State state = (State)pair.component1();
            FirFile file2 = (FirFile)pair.component2();
            Map<FirCallableSymbol<?>, FirFile> map = state.getCallableContainerMap();
            boolean bl = false;
            map.put(symbol2, file2);
        }

        private final /* synthetic */ void registerCallable(FirCallableSymbol symbol2, Pair data, Map map) {
            boolean $i$f$registerCallable = false;
            CallableId callableId = symbol2.getCallableId();
            Pair pair = data;
            State state = (State)pair.component1();
            FirFile file2 = (FirFile)pair.component2();
            map.merge(callableId, CollectionsKt.listOf((Object)symbol2), registerCallable.1.INSTANCE);
            Map<FirCallableSymbol<?>, FirFile> map2 = state.getCallableContainerMap();
            boolean bl = false;
            map2.put(symbol2, file2);
        }

        @Override
        public void visitConstructor(@NotNull FirConstructor constructor2, @NotNull Pair<State, ? extends FirFile> data) {
            Intrinsics.checkNotNullParameter((Object)constructor2, (String)"constructor");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            FirConstructorSymbol symbol2 = constructor2.getSymbol();
            FirRecorder firRecorder = this;
            Map<CallableId, List<FirConstructorSymbol>> map$iv = ((State)data.getFirst()).getConstructorMap();
            boolean $i$f$registerCallable = false;
            CallableId callableId$iv = ((FirCallableSymbol)symbol2).getCallableId();
            Pair<State, ? extends FirFile> pair = data;
            State state$iv = (State)pair.component1();
            FirFile file$iv = (FirFile)pair.component2();
            map$iv.merge(callableId$iv, CollectionsKt.listOf((Object)symbol2), registerCallable.1.INSTANCE);
            Map<FirCallableSymbol<?>, FirFile> map = state$iv.getCallableContainerMap();
            boolean bl = false;
            map.put(symbol2, file$iv);
        }

        @Override
        public void visitSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull Pair<State, ? extends FirFile> data) {
            Intrinsics.checkNotNullParameter((Object)simpleFunction, (String)"simpleFunction");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            FirNamedFunctionSymbol symbol2 = simpleFunction.getSymbol();
            FirRecorder firRecorder = this;
            Map<CallableId, List<FirNamedFunctionSymbol>> map$iv = ((State)data.getFirst()).getFunctionMap();
            boolean $i$f$registerCallable = false;
            CallableId callableId$iv = ((FirCallableSymbol)symbol2).getCallableId();
            Pair<State, ? extends FirFile> pair = data;
            State state$iv = (State)pair.component1();
            FirFile file$iv = (FirFile)pair.component2();
            map$iv.merge(callableId$iv, CollectionsKt.listOf((Object)symbol2), registerCallable.1.INSTANCE);
            Map<FirCallableSymbol<?>, FirFile> map = state$iv.getCallableContainerMap();
            boolean bl = false;
            map.put(symbol2, file$iv);
        }

        @Override
        public void visitProperty(@NotNull FirProperty property2, @NotNull Pair<State, ? extends FirFile> data) {
            Object it;
            boolean bl;
            Object object;
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            FirPropertySymbol symbol2 = property2.getSymbol();
            Object object2 = this;
            Map<CallableId, List<FirPropertySymbol>> map$iv = ((State)data.getFirst()).getPropertyMap();
            boolean $i$f$registerCallable = false;
            CallableId callableId$iv = ((FirCallableSymbol)symbol2).getCallableId();
            Pair<State, ? extends FirFile> pair = data;
            State state$iv = (State)pair.component1();
            FirFile file$iv = (FirFile)pair.component2();
            map$iv.merge(callableId$iv, CollectionsKt.listOf((Object)symbol2), registerCallable.1.INSTANCE);
            Map<FirCallableSymbol<?>, FirFile> map = state$iv.getCallableContainerMap();
            boolean bl2 = false;
            map.put(symbol2, file$iv);
            object2 = property2.getGetter();
            if (object2 != null) {
                object = object2;
                bl = false;
                boolean bl3 = false;
                it = object;
                boolean bl4 = false;
                INSTANCE.visitPropertyAccessor((FirPropertyAccessor)it, data);
            }
            object2 = property2.getSetter();
            if (object2 != null) {
                object = object2;
                bl = false;
                boolean bl5 = false;
                it = object;
                boolean bl6 = false;
                INSTANCE.visitPropertyAccessor((FirPropertyAccessor)it, data);
            }
        }

        @Override
        public void visitEnumEntry(@NotNull FirEnumEntry enumEntry, @NotNull Pair<State, ? extends FirFile> data) {
            Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            FirVariableSymbol<FirEnumEntry> symbol2 = enumEntry.getSymbol();
            Pair<State, ? extends FirFile> pair = data;
            State state = (State)pair.component1();
            FirFile file2 = (FirFile)pair.component2();
            Map<FirCallableSymbol<?>, FirFile> map = state.getCallableContainerMap();
            boolean bl = false;
            map.put(symbol2, file2);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0000R!\u0010\u0003\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR#\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR!\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\bR#\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\bR#\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00160\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\bR#\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u00160\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\bR#\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u00160\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\b\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirProviderImpl$State;", "", "()V", "callableContainerMap", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getCallableContainerMap", "()Ljava/util/Map;", "classesInPackage", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/name/Name;", "getClassesInPackage", "classifierContainerFileMap", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassifierContainerFileMap", "classifierMap", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getClassifierMap", "constructorMap", "Lorg/jetbrains/kotlin/fir/symbols/CallableId;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "getConstructorMap", "fileMap", "getFileMap", "functionMap", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getFunctionMap", "propertyMap", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "getPropertyMap", "setFrom", "", "other", "resolve"})
    private static final class State {
        @NotNull
        private final Map<FqName, List<FirFile>> fileMap;
        @NotNull
        private final Map<ClassId, FirClassLikeDeclaration<?>> classifierMap;
        @NotNull
        private final Map<ClassId, FirFile> classifierContainerFileMap;
        @NotNull
        private final Map<FqName, Set<Name>> classesInPackage;
        @NotNull
        private final Map<CallableId, List<FirNamedFunctionSymbol>> functionMap;
        @NotNull
        private final Map<CallableId, List<FirPropertySymbol>> propertyMap;
        @NotNull
        private final Map<CallableId, List<FirConstructorSymbol>> constructorMap;
        @NotNull
        private final Map<FirCallableSymbol<?>, FirFile> callableContainerMap;

        public State() {
            boolean bl = false;
            this.fileMap = new LinkedHashMap();
            bl = false;
            this.classifierMap = new LinkedHashMap();
            bl = false;
            this.classifierContainerFileMap = new LinkedHashMap();
            bl = false;
            this.classesInPackage = new LinkedHashMap();
            bl = false;
            this.functionMap = new LinkedHashMap();
            bl = false;
            this.propertyMap = new LinkedHashMap();
            bl = false;
            this.constructorMap = new LinkedHashMap();
            bl = false;
            this.callableContainerMap = new LinkedHashMap();
        }

        @NotNull
        public final Map<FqName, List<FirFile>> getFileMap() {
            return this.fileMap;
        }

        @NotNull
        public final Map<ClassId, FirClassLikeDeclaration<?>> getClassifierMap() {
            return this.classifierMap;
        }

        @NotNull
        public final Map<ClassId, FirFile> getClassifierContainerFileMap() {
            return this.classifierContainerFileMap;
        }

        @NotNull
        public final Map<FqName, Set<Name>> getClassesInPackage() {
            return this.classesInPackage;
        }

        @NotNull
        public final Map<CallableId, List<FirNamedFunctionSymbol>> getFunctionMap() {
            return this.functionMap;
        }

        @NotNull
        public final Map<CallableId, List<FirPropertySymbol>> getPropertyMap() {
            return this.propertyMap;
        }

        @NotNull
        public final Map<CallableId, List<FirConstructorSymbol>> getConstructorMap() {
            return this.constructorMap;
        }

        @NotNull
        public final Map<FirCallableSymbol<?>, FirFile> getCallableContainerMap() {
            return this.callableContainerMap;
        }

        public final void setFrom(@NotNull State other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.fileMap.clear();
            this.classifierMap.clear();
            this.classifierContainerFileMap.clear();
            this.functionMap.clear();
            this.propertyMap.clear();
            this.constructorMap.clear();
            this.callableContainerMap.clear();
            this.fileMap.putAll(other.fileMap);
            this.classifierMap.putAll(other.classifierMap);
            this.classifierContainerFileMap.putAll(other.classifierContainerFileMap);
            this.functionMap.putAll(other.functionMap);
            this.propertyMap.putAll(other.propertyMap);
            this.constructorMap.putAll(other.constructorMap);
            this.callableContainerMap.putAll(other.callableContainerMap);
            this.classesInPackage.putAll(other.classesInPackage);
        }
    }
}

