/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.PhaseUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.KotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirAbstractProviderBasedScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirObjectImportedCallableScope;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010J2\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0014\b\u0004\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00120\u0018H\u0084\b\u00f8\u0001\u0000J6\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0018\b\u0004\u0010\u0017\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b\u0012\u0004\u0012\u00020\u00120\u0018H\u0084\b\u00f8\u0001\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractImportingScope;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirAbstractProviderBasedScope;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "lookupInFir", "", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Z)V", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getStaticsScope", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "processFunctionsByNameWithImport", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "import", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedImport;", "processor", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "processPropertiesByNameWithImport", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "resolve"})
public abstract class FirAbstractImportingScope
extends FirAbstractProviderBasedScope {
    @NotNull
    private final ScopeSession scopeSession;

    public FirAbstractImportingScope(@NotNull FirSession session, @NotNull ScopeSession scopeSession, boolean lookupInFir) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        super(session, lookupInFir);
        this.scopeSession = scopeSession;
    }

    @NotNull
    protected final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    private final FirScope getStaticsScope(FirClassLikeSymbol<?> symbol2) {
        if (symbol2 instanceof FirTypeAliasSymbol) {
            ConeClassLikeLookupTag coneClassLikeLookupTag;
            FirClassLikeSymbol<?> expansionSymbol;
            ConeClassLikeType coneClassLikeType = FirDeclarationUtilKt.getExpandedConeType((FirTypeAlias)((FirTypeAliasSymbol)symbol2).getFir());
            FirClassLikeSymbol<?> firClassLikeSymbol = coneClassLikeType == null ? null : (expansionSymbol = (coneClassLikeLookupTag = coneClassLikeType.getLookupTag()) == null ? null : LookupTagUtilsKt.toSymbol(coneClassLikeLookupTag, this.getSession()));
            if (expansionSymbol != null) {
                return this.getStaticsScope(expansionSymbol);
            }
        } else {
            FirClass firClass = (FirClass)((FirClassSymbol)symbol2).getFir();
            return firClass.getClassKind() == ClassKind.OBJECT ? (FirScope)new FirObjectImportedCallableScope(symbol2.getClassId(), KotlinScopeProviderKt.unsubstitutedScope(firClass, this.getSession(), this.scopeSession, false)) : firClass.getScopeProvider().getStaticScope(firClass, this.getSession(), this.scopeSession);
        }
        return null;
    }

    @Nullable
    public final FirScope getStaticsScope(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        FirClassLikeSymbol<?> firClassLikeSymbol = this.getProvider().getClassLikeSymbolByFqName(classId);
        if (firClassLikeSymbol == null) {
            return null;
        }
        FirClassLikeSymbol<?> symbol2 = firClassLikeSymbol;
        return this.getStaticsScope(symbol2);
    }

    protected final void processFunctionsByNameWithImport(@NotNull Name name, @NotNull FirResolvedImport firResolvedImport, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor2) {
        block8: {
            FirAbstractImportingScope $this$processFunctionsByNameWithImport_u24lambda_u2d1;
            block9: {
                boolean bl;
                Unit unit;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)firResolvedImport, (String)"import");
                Intrinsics.checkNotNullParameter(processor2, (String)"processor");
                boolean $i$f$processFunctionsByNameWithImport = false;
                Object object = firResolvedImport.getResolvedClassId();
                if (object == null) {
                    unit = null;
                } else {
                    ClassId classId = object;
                    bl = false;
                    boolean bl2 = false;
                    ClassId classId2 = classId;
                    boolean bl3 = false;
                    FirScope firScope = this.getStaticsScope(classId2);
                    if (firScope == null) {
                        unit = null;
                    } else {
                        firScope.processFunctionsByName(name, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)new Function1<FirNamedFunctionSymbol, Unit>(processor2){
                            final /* synthetic */ Function1<FirNamedFunctionSymbol, Unit> $processor;
                            {
                                this.$processor = $processor;
                                super(1);
                            }

                            public final void invoke(@NotNull FirNamedFunctionSymbol it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                this.$processor.invoke((Object)it);
                            }
                        }));
                        unit = Unit.INSTANCE;
                    }
                }
                Unit unit2 = unit;
                if (unit2 != null) break block8;
                object = this;
                boolean bl4 = false;
                bl = false;
                $this$processFunctionsByNameWithImport_u24lambda_u2d1 = (FirAbstractImportingScope)object;
                boolean bl5 = false;
                if (name.isSpecial()) break block9;
                CharSequence bl3 = name.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"name.identifier");
                bl3 = bl3;
                boolean bl6 = false;
                if (!(bl3.length() > 0)) break block8;
            }
            List<FirNamedFunctionSymbol> symbols = $this$processFunctionsByNameWithImport_u24lambda_u2d1.getProvider().getTopLevelFunctionSymbols(firResolvedImport.getPackageFqName(), name);
            for (FirNamedFunctionSymbol symbol2 : symbols) {
                PhaseUtilsKt.ensureResolvedForCalls(symbol2, $this$processFunctionsByNameWithImport_u24lambda_u2d1.getSession());
                processor2.invoke((Object)symbol2);
            }
        }
    }

    protected final void processPropertiesByNameWithImport(@NotNull Name name, @NotNull FirResolvedImport firResolvedImport, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor2) {
        block8: {
            FirAbstractImportingScope $this$processPropertiesByNameWithImport_u24lambda_u2d3;
            block9: {
                boolean bl;
                Unit unit;
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)firResolvedImport, (String)"import");
                Intrinsics.checkNotNullParameter(processor2, (String)"processor");
                boolean $i$f$processPropertiesByNameWithImport = false;
                Object object = firResolvedImport.getResolvedClassId();
                if (object == null) {
                    unit = null;
                } else {
                    ClassId classId = object;
                    bl = false;
                    boolean bl2 = false;
                    ClassId classId2 = classId;
                    boolean bl3 = false;
                    FirScope firScope = this.getStaticsScope(classId2);
                    if (firScope == null) {
                        unit = null;
                    } else {
                        firScope.processPropertiesByName(name, (Function1)new Function1<FirVariableSymbol<?>, Unit>(processor2){
                            final /* synthetic */ Function1<FirVariableSymbol<?>, Unit> $processor;
                            {
                                this.$processor = $processor;
                                super(1);
                            }

                            public final void invoke(@NotNull FirVariableSymbol<?> it) {
                                Intrinsics.checkNotNullParameter(it, (String)"it");
                                this.$processor.invoke(it);
                            }
                        });
                        unit = Unit.INSTANCE;
                    }
                }
                Unit unit2 = unit;
                if (unit2 != null) break block8;
                object = this;
                boolean bl4 = false;
                bl = false;
                $this$processPropertiesByNameWithImport_u24lambda_u2d3 = (FirAbstractImportingScope)object;
                boolean bl5 = false;
                if (name.isSpecial()) break block9;
                CharSequence bl3 = name.getIdentifier();
                Intrinsics.checkNotNullExpressionValue((Object)bl3, (String)"name.identifier");
                bl3 = bl3;
                boolean bl6 = false;
                if (!(bl3.length() > 0)) break block8;
            }
            List<FirPropertySymbol> symbols = $this$processPropertiesByNameWithImport_u24lambda_u2d3.getProvider().getTopLevelPropertySymbols(firResolvedImport.getPackageFqName(), name);
            for (FirPropertySymbol symbol2 : symbols) {
                PhaseUtilsKt.ensureResolvedForCalls(symbol2, $this$processPropertiesByNameWithImport_u24lambda_u2d3.getSession());
                processor2.invoke((Object)symbol2);
            }
        }
    }
}

