/*
 * Decompiled with CFR 0.152.
 */
package training.learn.lesson.general.navigation;

import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import training.dsl.LessonContext;
import training.dsl.LessonUtil;
import training.dsl.LessonUtilKt;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.dsl.TaskTestContext;
import training.learn.LessonsBundle;
import training.learn.course.KLesson;
import training.learn.course.LessonType;
import training.learn.lesson.general.navigation.FileStructureLesson;
import training.ui.IftTestContainerFixture;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010!\u001a\u00020\"*\u00020#2\u0006\u0010$\u001a\u00020\u0004H\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR%\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0012\u0010\u0017\u001a\u00020\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006%"}, d2={"Ltraining/learn/lesson/general/navigation/FileStructureLesson;", "Ltraining/learn/course/KLesson;", "()V", "existedFile", "", "getExistedFile", "()Ljava/lang/String;", "firstWord", "helpLinks", "", "getHelpLinks", "()Ljava/util/Map;", "lessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "lessonType", "Ltraining/learn/course/LessonType;", "getLessonType", "()Ltraining/learn/course/LessonType;", "methodToFindPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "getMethodToFindPosition", "()Lcom/intellij/openapi/editor/LogicalPosition;", "searchSubstring", "secondWord", "suitableTips", "", "getSuitableTips", "()Ljava/util/List;", "checkWordInSearch", "", "Ltraining/dsl/TaskRuntimeContext;", "expected", "intellij.featuresTrainer"})
public abstract class FileStructureLesson
extends KLesson {
    private final String searchSubstring;
    private final String firstWord;
    private final String secondWord;
    @NotNull
    private final LessonType lessonType = LessonType.SINGLE_EDITOR;
    @NotNull
    private final List<String> suitableTips = CollectionsKt.listOf((Object)"FileStructurePopup");

    @Override
    @NotNull
    public abstract String getExistedFile();

    @NotNull
    public abstract LogicalPosition getMethodToFindPosition();

    @Override
    @NotNull
    public LessonType getLessonType() {
        return this.lessonType;
    }

    @Override
    @NotNull
    public Function1<LessonContext, Unit> getLessonContent() {
        return (Function1)new Function1<LessonContext, Unit>(this){
            final /* synthetic */ FileStructureLesson this$0;

            public final void invoke(@NotNull LessonContext $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                $receiver.caret(0);
                $receiver.actionTask("FileStructurePopup", (Function2<? super TaskContext, ? super String, String>)((Function2)lessonContent.1.INSTANCE));
                $receiver.task(FileStructureLesson.access$getSearchSubstring$p(this.this$0), (Function2<? super TaskContext, ? super String, Unit>)((Function2)new Function2<TaskContext, String, Unit>(this){
                    final /* synthetic */ lessonContent.1 this$0;

                    public final void invoke(@NotNull TaskContext $this$task, @NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$receiver");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("file.structure.request.prefixes", $this$task.strong(FileStructureLesson.access$getFirstWord$p(this.this$0.this$0)), $this$task.strong(FileStructureLesson.access$getSecondWord$p(this.this$0.this$0)), $this$task.code(FileStructureLesson.access$getSearchSubstring$p(this.this$0.this$0))), null, 2, null);
                        $this$task.stateCheck((Function1<? super TaskRuntimeContext, Boolean>)((Function1)new Function1<TaskRuntimeContext, Boolean>(this, it){
                            final /* synthetic */ lessonContent.2 this$0;
                            final /* synthetic */ String $it;

                            public final boolean invoke(@NotNull TaskRuntimeContext $this$stateCheck) {
                                Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$receiver");
                                return FileStructureLesson.access$checkWordInSearch(this.this$0.this$0.this$0, $this$stateCheck, this.$it);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$it = string;
                                super(1);
                            }
                        }));
                        LessonUtilKt.restoreAfterStateBecomeFalse$default($this$task, null, lessonContent.2.INSTANCE, 1, null);
                        TaskContext.test$default($this$task, false, (Function1)new Function1<TaskTestContext, Unit>(it){
                            final /* synthetic */ String $it;

                            public final void invoke(@NotNull TaskTestContext $this$test) {
                                Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$receiver");
                                $this$test.ideFrame((Function1<? super IftTestContainerFixture<IdeFrameImpl>, Unit>)((Function1)new Function1<IftTestContainerFixture<IdeFrameImpl>, Unit>($this$test){
                                    final /* synthetic */ TaskTestContext $this_test;

                                    public final void invoke(@NotNull IftTestContainerFixture<IdeFrameImpl> $this$ideFrame) {
                                        Intrinsics.checkNotNullParameter($this$ideFrame, (String)"$receiver");
                                        this.$this_test.waitComponent(DnDAwareTree.class, "FileStructurePopup");
                                    }
                                    {
                                        this.$this_test = taskTestContext;
                                        super(1);
                                    }
                                }));
                                $this$test.type(this.$it);
                            }
                            {
                                this.$it = string;
                                super(1);
                            }
                        }, 1, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                }));
                $receiver.task((Function1<? super TaskContext, Unit>)((Function1)new Function1<TaskContext, Unit>(this){
                    final /* synthetic */ lessonContent.1 this$0;

                    public final void invoke(@NotNull TaskContext $this$task) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$receiver");
                        TaskContext.text$default($this$task, LessonsBundle.INSTANCE.message("file.structure.navigate", LessonUtil.INSTANCE.rawEnter()), null, 2, null);
                        $this$task.stateCheck((Function1<? super TaskRuntimeContext, Boolean>)((Function1)new Function1<TaskRuntimeContext, Boolean>(this){
                            final /* synthetic */ lessonContent.3 this$0;

                            public final boolean invoke(@NotNull TaskRuntimeContext $this$stateCheck) {
                                Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$receiver");
                                CaretModel caretModel = $this$stateCheck.getEditor().getCaretModel();
                                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                                return Intrinsics.areEqual((Object)caretModel.getLogicalPosition(), (Object)this.this$0.this$0.this$0.getMethodToFindPosition());
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }));
                        TaskContext.restoreState$default($this$task, null, 0, null, (Function1)new Function1<TaskRuntimeContext, Boolean>(this){
                            final /* synthetic */ lessonContent.3 this$0;

                            public final boolean invoke(@NotNull TaskRuntimeContext $this$restoreState) {
                                Intrinsics.checkNotNullParameter((Object)$this$restoreState, (String)"$receiver");
                                return !FileStructureLesson.access$checkWordInSearch(this.this$0.this$0.this$0, $this$restoreState, FileStructureLesson.access$getSearchSubstring$p(this.this$0.this$0.this$0));
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        }, 7, null);
                        TaskContext.test$default($this$task, false, lessonContent.3.INSTANCE, 1, null);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
                if (ActionManager.getInstance().getAction("ActivateStructureToolWindow") != null) {
                    $receiver.task("ActivateStructureToolWindow", (Function2<? super TaskContext, ? super String, Unit>)((Function2)lessonContent.4.INSTANCE));
                }
            }
            {
                this.this$0 = fileStructureLesson;
                super(1);
            }
        };
    }

    private final boolean checkWordInSearch(TaskRuntimeContext $this$checkWordInSearch, String expected) {
        Component focusOwner = $this$checkWordInSearch.getFocusOwner();
        if (focusOwner instanceof DnDAwareTree) {
            String string = ((DnDAwareTree)focusOwner).getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"focusOwner.javaClass.name");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"FileStructurePopup", (boolean)false, (int)2, null)) {
                SpeedSearchSupply supply;
                SpeedSearchSupply speedSearchSupply = supply = SpeedSearchSupply.getSupply((JComponent)((JComponent)focusOwner));
                return Intrinsics.areEqual((Object)(speedSearchSupply != null ? speedSearchSupply.getEnteredPrefix() : null), (Object)expected);
            }
        }
        return false;
    }

    @Override
    @NotNull
    public List<String> getSuitableTips() {
        return this.suitableTips;
    }

    @Override
    @NotNull
    public Map<String, String> getHelpLinks() {
        return MapsKt.mapOf((Pair)new Pair((Object)LessonsBundle.INSTANCE.message("file.structure.help.link", new Object[0]), (Object)LessonUtil.INSTANCE.getHelpLink("viewing-structure-of-a-source-file.html")));
    }

    public FileStructureLesson() {
        super("File structure", LessonsBundle.INSTANCE.message("file.structure.lesson.name", new Object[0]));
        this.searchSubstring = "hosa";
        this.firstWord = "Homo";
        this.secondWord = "Sapiens";
    }

    public static final /* synthetic */ String access$getSearchSubstring$p(FileStructureLesson $this) {
        return $this.searchSubstring;
    }

    public static final /* synthetic */ String access$getFirstWord$p(FileStructureLesson $this) {
        return $this.firstWord;
    }

    public static final /* synthetic */ String access$getSecondWord$p(FileStructureLesson $this) {
        return $this.secondWord;
    }

    public static final /* synthetic */ boolean access$checkWordInSearch(FileStructureLesson $this, TaskRuntimeContext $this$access_u24checkWordInSearch, String expected) {
        return $this.checkWordInSearch($this$access_u24checkWordInSearch, expected);
    }
}

