/*
 * Decompiled with CFR 0.152.
 */
package training.util;

import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.MacKeymapUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Regex;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.util.UtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\b\b\u0001\u0010\f\u001a\u00020\tJ$\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\tJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u001a*\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u001bR\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u001c"}, d2={"Ltraining/util/KeymapUtil;", "", "()V", "isNumpadKey", "", "Lcom/intellij/openapi/actionSystem/KeyboardShortcut;", "(Lcom/intellij/openapi/actionSystem/KeyboardShortcut;)Z", "getGotoActionData", "Lkotlin/Pair;", "", "", "Lkotlin/ranges/IntRange;", "actionId", "getKeyStrokeData", "keyStroke", "Ljavax/swing/KeyStroke;", "getModifiersText", "modifiers", "", "getShortcutByActionId", "getStringForMacSymbol", "c", "", "specificKeyString", "code", "getModifiers", "", "(Ljava/lang/String;)[Ljava/lang/String;", "intellij.featuresTrainer"})
public final class KeymapUtil {
    @NotNull
    public static final KeymapUtil INSTANCE;

    @Nullable
    public final KeyStroke getShortcutByActionId(@Nullable String actionId) {
        if (actionId == null) {
            return null;
        }
        Function1<KeyboardShortcut, Boolean> $fun$isConflicting$1 = new Function1<KeyboardShortcut, Boolean>(actionId){
            final /* synthetic */ String $actionId;

            public final boolean invoke(@NotNull KeyboardShortcut $this$isConflicting) {
                Intrinsics.checkNotNullParameter((Object)$this$isConflicting, (String)"$this$isConflicting");
                KeymapManager keymapManager = KeymapManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)keymapManager, (String)"KeymapManager.getInstance()");
                Map map = keymapManager.getActiveKeymap().getConflicts(this.$actionId, $this$isConflicting);
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"KeymapManager.getInstanc\u2026Conflicts(actionId, this)");
                Map map2 = map;
                boolean bl = false;
                return !map2.isEmpty();
            }
            {
                this.$actionId = string;
                super(1);
            }
        };
        KeymapManager keymapManager = KeymapManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)keymapManager, (String)"KeymapManager.getInstance()");
        Shortcut[] shortcuts = keymapManager.getActiveKeymap().getShortcuts(actionId);
        KeyboardShortcut bestShortcut = null;
        for (Shortcut curShortcut : shortcuts) {
            if (!(curShortcut instanceof KeyboardShortcut)) continue;
            boolean isConflicting = $fun$isConflicting$1.invoke((KeyboardShortcut)curShortcut);
            boolean isNumpadKey = this.isNumpadKey((KeyboardShortcut)curShortcut);
            if (bestShortcut == null || !isConflicting && !isNumpadKey || !isNumpadKey && this.isNumpadKey(bestShortcut) || !isConflicting && $fun$isConflicting$1.invoke(bestShortcut) && this.isNumpadKey(bestShortcut)) {
                bestShortcut = (KeyboardShortcut)curShortcut;
            }
            if (!isConflicting && !isNumpadKey) break;
        }
        KeyboardShortcut keyboardShortcut = bestShortcut;
        return keyboardShortcut != null ? keyboardShortcut.getFirstKeyStroke() : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNumpadKey(KeyboardShortcut $this$isNumpadKey) {
        KeyStroke keyStroke = $this$isNumpadKey.getFirstKeyStroke();
        Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"firstKeyStroke");
        int n = keyStroke.getKeyCode();
        if (96 <= n) {
            if (111 >= n) return true;
        }
        KeyStroke keyStroke2 = $this$isNumpadKey.getFirstKeyStroke();
        Intrinsics.checkNotNullExpressionValue((Object)keyStroke2, (String)"firstKeyStroke");
        if (keyStroke2.getKeyCode() != 144) return false;
        return true;
    }

    private final String specificKeyString(int code) {
        String string;
        switch (code) {
            case 37: {
                string = "\u2190";
                break;
            }
            case 39: {
                string = "\u2192";
                break;
            }
            case 38: {
                string = "\u2191";
                break;
            }
            case 40: {
                string = "\u2193";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public final Pair<String, List<IntRange>> getKeyStrokeData(@Nullable KeyStroke keyStroke) {
        boolean bl;
        String key;
        if (keyStroke == null) {
            return new Pair((Object)"", (Object)CollectionsKt.emptyList());
        }
        String modifiers = this.getModifiersText(keyStroke.getModifiers());
        int keyCode = keyStroke.getKeyCode();
        String string = this.specificKeyString(keyCode);
        if (string == null) {
            string = SystemInfo.isMac ? MacKeymapUtil.getKeyText((int)keyCode) : KeyEvent.getKeyText(keyCode);
        }
        if ((key = string).length() == 1) {
            String string2 = this.getStringForMacSymbol(key.charAt(0));
            if (string2 != null) {
                String string3 = string2;
                boolean bl2 = false;
                bl = false;
                String it = string3;
                boolean bl3 = false;
                key = key + "\u00a0" + it;
            }
        }
        String separator = "\u00a0\u00a0\u00a0\u00a0";
        bl = false;
        List intervals = new ArrayList();
        StringBuilder builder = new StringBuilder();
        Function1<String, Unit> $fun$addPart$2 = new Function1<String, Unit>(builder, intervals){
            final /* synthetic */ StringBuilder $builder;
            final /* synthetic */ List $intervals;

            public final void invoke(@NotNull String part) {
                Intrinsics.checkNotNullParameter((Object)part, (String)"part");
                int start = this.$builder.length();
                this.$builder.append(part);
                this.$intervals.add(new IntRange(start, this.$builder.length() - 1));
            }
            {
                this.$builder = stringBuilder;
                this.$intervals = list2;
                super(1);
            }
        };
        for (String m : this.getModifiers(modifiers)) {
            String string4;
            if (SystemInfo.isMac) {
                String modifierName;
                String string5 = modifierName = m.length() == 1 ? this.getStringForMacSymbol(m.charAt(0)) : null;
                string4 = modifierName != null ? m + "\u00a0" + modifierName : m;
            } else {
                string4 = m;
            }
            String part = string4;
            $fun$addPart$2.invoke(part);
            builder.append(separator);
        }
        String string6 = key;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"key");
        $fun$addPart$2.invoke(string6);
        String string7 = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"builder.toString()");
        return new Pair((Object)string7, (Object)intervals);
    }

    @NotNull
    public final Pair<String, List<IntRange>> getGotoActionData(@NonNls @NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        KeyStroke keyStroke = this.getShortcutByActionId("GotoAction");
        Pair<String, List<IntRange>> gotoAction = this.getKeyStrokeData(keyStroke);
        Presentation presentation = UtilsKt.getActionById(actionId).getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getActionById(actionId).templatePresentation");
        String string = presentation.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getActionById(actionId).templatePresentation.text");
        String actionName = UtilsKt.replaceSpacesWithNonBreakSpace(string);
        ArrayList<IntRange> updated = new ArrayList<IntRange>((Collection)gotoAction.getSecond());
        int start = ((String)gotoAction.getFirst()).length() + 5;
        updated.add(new IntRange(start, start + actionName.length() - 1));
        return new Pair((Object)((String)gotoAction.getFirst() + "  \u2192  " + actionName), updated);
    }

    private final String getModifiersText(int modifiers) {
        String string = KeyEvent.getKeyModifiersText(modifiers);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"KeyEvent.getKeyModifiersText(modifiers)");
        return string;
    }

    private final String[] getModifiers(String $this$getModifiers) {
        List list2;
        CharSequence charSequence = $this$getModifiers;
        String string = "[ +]";
        int n = 0;
        string = new Regex(string);
        n = 0;
        boolean bl = false;
        List $this$dropLastWhile$iv = string.split(charSequence, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl2 = false;
                CharSequence charSequence2 = it;
                boolean bl3 = false;
                if (charSequence2.length() == 0) continue;
                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list2 = CollectionsKt.emptyList();
        }
        Collection $this$toTypedArray$iv = list2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    private final String getStringForMacSymbol(char c) {
        if (!SystemInfo.isMac) {
            return null;
        }
        switch (c) {
            case '\u238b': {
                return "Esc";
            }
            case '\u21e5': {
                return "Tab";
            }
            case '\u21ea': {
                return "Caps";
            }
            case '\u21e7': {
                return "Shift";
            }
            case '\u2303': {
                return "Ctrl";
            }
            case '\u2325': {
                return "Opt";
            }
            case '\u2318': {
                return "Cmd";
            }
            case '\u23ce': {
                return "Enter";
            }
            case '\u232b': {
                return "Backspace";
            }
            case '\u2326': {
                return "Del";
            }
            case '\u2196': {
                return "Home";
            }
            case '\u2198': {
                return "End";
            }
            case '\u21de': {
                return "PageUp";
            }
            case '\u21df': {
                return "PageDown";
            }
            case '\u21ed': {
                return "NumLock";
            }
            case '\u2328': {
                return "NumPad";
            }
        }
        return null;
    }

    private KeymapUtil() {
    }

    static {
        KeymapUtil keymapUtil;
        INSTANCE = keymapUtil = new KeymapUtil();
    }
}

