/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.classloader;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComponentRegistry {
    private static ComponentRegistry instance = null;
    private final Logger logger = LoggerFactory.getLogger((String)ComponentRegistry.class.getName());
    private final Map<String, String> componentVersions = new TreeMap<String, String>();
    private static final String version = "0.2.3";
    private final List<String> includes = new ArrayList<String>();

    ComponentRegistry() {
        this.registerComponent(this.getClass());
    }

    public static synchronized ComponentRegistry getInstance() {
        if (instance == null) {
            instance = new ComponentRegistry();
        }
        return instance;
    }

    public static String getVersion() {
        return version;
    }

    public synchronized void addPackageToIncludeList(String _str) {
        if (_str == null) {
            return;
        }
        this.includes.add(_str);
    }

    public synchronized void clearPackageIncludeList() {
        this.includes.clear();
    }

    public synchronized List<String> getComponents() {
        ArrayList<String> compos = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.componentVersions.entrySet()) {
            compos.add(entry.getKey());
        }
        return compos;
    }

    public synchronized Map<String, String> getComponentsVersions() {
        TreeMap<String, String> keys = new TreeMap<String, String>(this.componentVersions);
        return keys;
    }

    public synchronized String getVersionForComponent(Class<?> _clazz) {
        return this.componentVersions.get(_clazz.getName());
    }

    public synchronized void registerComponent(Class<?> _clazz, String _version) {
        this.componentVersions.put(_clazz.getName(), _version);
    }

    public synchronized boolean unregisterComponent(Class<?> _clazz) {
        return null != this.componentVersions.remove(_clazz.getName());
    }

    public synchronized boolean unregisterComponent(String _className) {
        return null != this.componentVersions.remove(_className);
    }

    private synchronized boolean isIncluded(String _clazzName) {
        if (this.includes.size() > 0) {
            for (String include : this.includes) {
                if (!_clazzName.startsWith(include)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void registerComponent(Class<?> _clazz) {
        String classVersion;
        if (_clazz == null) {
            return;
        }
        if ((this.isIncluded(_clazz.getName()) || _clazz.getName().equals(this.getClass().getName())) && (classVersion = this.getVersionWithReflection(_clazz)) != null) {
            this.componentVersions.put(_clazz.getName(), classVersion);
        }
    }

    public synchronized void registerComponent(String _string) {
        if (this.isIncluded(_string)) {
            try {
                Class<?> dummy = Class.forName(_string);
                String classVersion = this.getVersionWithReflection(dummy);
                if (classVersion != null) {
                    this.componentVersions.put(_string, classVersion);
                }
            }
            catch (ClassNotFoundException ex) {
                this.logger.trace("Unable to call getVersion on " + _string);
            }
        }
    }

    private String getVersionWithReflection(Class<?> dummy) {
        Method meth = null;
        try {
            Method[] declaredMethods = dummy.getDeclaredMethods();
            if (declaredMethods.length == 0) {
                return null;
            }
            for (Method method : declaredMethods) {
                if (!method.getName().equals("getVersion")) continue;
                meth = method;
                break;
            }
            if (meth != null) {
                try {
                    Object value;
                    meth.setAccessible(true);
                    if (Modifier.isStatic(meth.getModifiers()) && (value = meth.invoke(null, new Object[0])) instanceof String) {
                        return (String)value;
                    }
                    return null;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    this.logger.trace("Unable to call getVersion on " + dummy.getName());
                }
            }
        }
        catch (SecurityException _ex) {
            return null;
        }
        return null;
    }
}

