/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.services.s3.internal;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.gradle.internal.impldep.com.amazonaws.AmazonWebServiceResponse;
import org.gradle.internal.impldep.com.amazonaws.http.HttpResponse;
import org.gradle.internal.impldep.com.amazonaws.services.s3.internal.HeaderHandler;
import org.gradle.internal.impldep.com.amazonaws.services.s3.internal.S3XmlResponseHandler;
import org.gradle.internal.impldep.com.amazonaws.transform.Unmarshaller;

public class ResponseHeaderHandlerChain<T>
extends S3XmlResponseHandler<T> {
    private final List<HeaderHandler<T>> headerHandlers;

    public ResponseHeaderHandlerChain(Unmarshaller<T, InputStream> responseUnmarshaller, HeaderHandler<T> ... headerHandlers) {
        super(responseUnmarshaller);
        this.headerHandlers = Arrays.asList(headerHandlers);
    }

    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        Object awsResponse = super.handle(response);
        Object result = ((AmazonWebServiceResponse)awsResponse).getResult();
        if (result != null) {
            for (HeaderHandler handler : this.headerHandlers) {
                handler.handle(result, response);
            }
        }
        return awsResponse;
    }
}

