/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp.examples;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPrivateKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPSecretKey;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPUtil;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.JcePBESecretKeyDecryptorBuilder;

class PGPExampleUtil {
    PGPExampleUtil() {
    }

    static byte[] compressFile(String string, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PGPCompressedDataGenerator pGPCompressedDataGenerator = new PGPCompressedDataGenerator(n);
        PGPUtil.writeFileToLiteralData(pGPCompressedDataGenerator.open(byteArrayOutputStream), 'b', new File(string));
        pGPCompressedDataGenerator.close();
        return byteArrayOutputStream.toByteArray();
    }

    static PGPPrivateKey findSecretKey(PGPSecretKeyRingCollection pGPSecretKeyRingCollection, long l, char[] cArray) throws PGPException, NoSuchProviderException {
        PGPSecretKey pGPSecretKey = pGPSecretKeyRingCollection.getSecretKey(l);
        if (pGPSecretKey == null) {
            return null;
        }
        return pGPSecretKey.extractPrivateKey(new JcePBESecretKeyDecryptorBuilder().setProvider("BC").build(cArray));
    }

    static PGPPublicKey readPublicKey(String string) throws IOException, PGPException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        PGPPublicKey pGPPublicKey = PGPExampleUtil.readPublicKey(bufferedInputStream);
        ((InputStream)bufferedInputStream).close();
        return pGPPublicKey;
    }

    static PGPPublicKey readPublicKey(InputStream inputStream) throws IOException, PGPException {
        PGPPublicKeyRingCollection pGPPublicKeyRingCollection = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream(inputStream), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator<PGPPublicKeyRing> iterator = pGPPublicKeyRingCollection.getKeyRings();
        while (iterator.hasNext()) {
            PGPPublicKeyRing pGPPublicKeyRing = iterator.next();
            Iterator<PGPPublicKey> iterator2 = pGPPublicKeyRing.getPublicKeys();
            while (iterator2.hasNext()) {
                PGPPublicKey pGPPublicKey = iterator2.next();
                if (!pGPPublicKey.isEncryptionKey()) continue;
                return pGPPublicKey;
            }
        }
        throw new IllegalArgumentException("Can't find encryption key in key ring.");
    }

    static PGPSecretKey readSecretKey(String string) throws IOException, PGPException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
        PGPSecretKey pGPSecretKey = PGPExampleUtil.readSecretKey(bufferedInputStream);
        ((InputStream)bufferedInputStream).close();
        return pGPSecretKey;
    }

    static PGPSecretKey readSecretKey(InputStream inputStream) throws IOException, PGPException {
        PGPSecretKeyRingCollection pGPSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(inputStream), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
        Iterator<PGPSecretKeyRing> iterator = pGPSecretKeyRingCollection.getKeyRings();
        while (iterator.hasNext()) {
            PGPSecretKeyRing pGPSecretKeyRing = iterator.next();
            Iterator<PGPSecretKey> iterator2 = pGPSecretKeyRing.getSecretKeys();
            while (iterator2.hasNext()) {
                PGPSecretKey pGPSecretKey = iterator2.next();
                if (!pGPSecretKey.isSigningKey()) continue;
                return pGPSecretKey;
            }
        }
        throw new IllegalArgumentException("Can't find signing key in key ring.");
    }
}

