/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.attributes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.internal.impldep.org.eclipse.jgit.attributes.FilterCommand;
import org.gradle.internal.impldep.org.eclipse.jgit.attributes.FilterCommandFactory;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;

public class FilterCommandRegistry {
    private static ConcurrentHashMap<String, FilterCommandFactory> filterCommandRegistry = new ConcurrentHashMap();

    public static FilterCommandFactory register(String filterCommandName, FilterCommandFactory factory) {
        return filterCommandRegistry.put(filterCommandName, factory);
    }

    public static FilterCommandFactory unregister(String filterCommandName) {
        return filterCommandRegistry.remove(filterCommandName);
    }

    public static boolean isRegistered(String filterCommandName) {
        return filterCommandRegistry.containsKey(filterCommandName);
    }

    public static Set<String> getRegisteredFilterCommands() {
        return filterCommandRegistry.keySet();
    }

    public static FilterCommand createFilterCommand(String filterCommandName, Repository db, InputStream in, OutputStream out) throws IOException {
        FilterCommandFactory cf = filterCommandRegistry.get(filterCommandName);
        return cf == null ? null : cf.create(db, in, out);
    }
}

