/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.internal.revwalk;

import org.gradle.internal.impldep.org.eclipse.jgit.lib.BitmapIndex;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevFlag;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.filter.RevFilter;

public class AddUnseenToBitmapFilter
extends RevFilter {
    private final BitmapIndex.BitmapBuilder seen;
    private final BitmapIndex.BitmapBuilder bitmap;

    public AddUnseenToBitmapFilter(BitmapIndex.BitmapBuilder seen, BitmapIndex.BitmapBuilder bitmap) {
        this.seen = seen;
        this.bitmap = bitmap;
    }

    @Override
    public final boolean include(RevWalk walker, RevCommit cmit) {
        if (!this.seen.contains(cmit) && !this.bitmap.contains(cmit)) {
            BitmapIndex.Bitmap visitedBitmap = this.bitmap.getBitmapIndex().getBitmap(cmit);
            if (visitedBitmap != null) {
                this.bitmap.or(visitedBitmap);
            } else {
                this.bitmap.addObject(cmit, 1);
                return true;
            }
        }
        RevCommit[] revCommitArray = cmit.getParents();
        int n = revCommitArray.length;
        int n2 = 0;
        while (n2 < n) {
            RevCommit p = revCommitArray[n2];
            p.add(RevFlag.SEEN);
            ++n2;
        }
        return false;
    }

    @Override
    public final RevFilter clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean requiresCommitBody() {
        return false;
    }
}

