/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.testng.xml;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gradle.internal.impldep.org.testng.ITestObjectFactory;
import org.gradle.internal.impldep.org.testng.TestNG;
import org.gradle.internal.impldep.org.testng.collections.Lists;
import org.gradle.internal.impldep.org.testng.collections.Maps;
import org.gradle.internal.impldep.org.testng.internal.Utils;
import org.gradle.internal.impldep.org.testng.reporters.XMLStringBuffer;
import org.gradle.internal.impldep.org.testng.xml.XmlMethodSelector;
import org.gradle.internal.impldep.org.testng.xml.XmlPackage;
import org.gradle.internal.impldep.org.testng.xml.XmlTest;
import org.gradle.internal.impldep.org.testng.xml.XmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSuite
implements Serializable,
Cloneable {
    public static final String PARALLEL_TESTS = "tests";
    public static final String PARALLEL_METHODS = "methods";
    public static final String PARALLEL_CLASSES = "classes";
    public static final String PARALLEL_INSTANCES = "instances";
    public static final String PARALLEL_NONE = "none";
    public static Set<String> PARALLEL_MODES = new HashSet<String>(){
        {
            this.add(XmlSuite.PARALLEL_TESTS);
            this.add(XmlSuite.PARALLEL_METHODS);
            this.add(XmlSuite.PARALLEL_CLASSES);
            this.add(XmlSuite.PARALLEL_INSTANCES);
            this.add(XmlSuite.PARALLEL_NONE);
            this.add("true");
            this.add("false");
        }
    };
    public static final String SKIP = "skip";
    public static final String CONTINUE = "continue";
    private String m_test;
    private static final String DEFAULT_SUITE_NAME = "Default Suite";
    private String m_name = "Default Suite";
    public static Integer DEFAULT_VERBOSE = 1;
    private Integer m_verbose = null;
    public static String DEFAULT_PARALLEL = "false";
    private String m_parallel = DEFAULT_PARALLEL;
    public static String DEFAULT_CONFIG_FAILURE_POLICY = "skip";
    private String m_configFailurePolicy = DEFAULT_CONFIG_FAILURE_POLICY;
    public static Boolean DEFAULT_JUNIT = Boolean.FALSE;
    private Boolean m_isJUnit = DEFAULT_JUNIT;
    public static Boolean DEFAULT_SKIP_FAILED_INVOCATION_COUNTS = Boolean.FALSE;
    private Boolean m_skipFailedInvocationCounts = DEFAULT_SKIP_FAILED_INVOCATION_COUNTS;
    public static Integer DEFAULT_THREAD_COUNT = 5;
    private int m_threadCount = DEFAULT_THREAD_COUNT;
    public static final Integer DEFAULT_DATA_PROVIDER_THREAD_COUNT = 10;
    private int m_dataProviderThreadCount = DEFAULT_DATA_PROVIDER_THREAD_COUNT;
    public static final Boolean DEFAULT_GROUP_BY_INSTANCES = false;
    private Boolean m_groupByInstances = DEFAULT_GROUP_BY_INSTANCES;
    private List<XmlPackage> m_xmlPackages = Lists.newArrayList();
    private String m_expression = null;
    private List<XmlMethodSelector> m_methodSelectors = Lists.newArrayList();
    private List<XmlTest> m_tests = Lists.newArrayList();
    private Map<String, String> m_parameters = Maps.newHashMap();
    private String m_fileName;
    private String m_timeOut;
    private List<XmlSuite> m_childSuites = Lists.newArrayList();
    private XmlSuite m_parentSuite;
    private List<String> m_suiteFiles = Lists.newArrayList();
    private ITestObjectFactory m_objectFactory;
    private List<String> m_listeners = Lists.newArrayList();
    private static final long serialVersionUID = 4999962288272750226L;
    public static String DEFAULT_PRESERVE_ORDER = "true";
    private String m_preserveOrder = DEFAULT_PRESERVE_ORDER;
    private List<String> m_includedGroups = Lists.newArrayList();
    private List<String> m_excludedGroups = Lists.newArrayList();

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public String getParallel() {
        return this.m_parallel;
    }

    public ITestObjectFactory getObjectFactory() {
        return this.m_objectFactory;
    }

    public void setObjectFactory(ITestObjectFactory objectFactory) {
        this.m_objectFactory = objectFactory;
    }

    public void setParallel(String parallel) {
        this.m_parallel = parallel;
    }

    public void setConfigFailurePolicy(String configFailurePolicy) {
        this.m_configFailurePolicy = configFailurePolicy;
    }

    public String getConfigFailurePolicy() {
        return this.m_configFailurePolicy;
    }

    public Integer getVerbose() {
        return this.m_verbose != null ? this.m_verbose : TestNG.DEFAULT_VERBOSE;
    }

    public void setVerbose(Integer verbose) {
        this.m_verbose = verbose;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getTest() {
        return this.m_test;
    }

    public List<XmlTest> getTests() {
        return this.m_tests;
    }

    public void setTests(List<XmlTest> tests) {
        this.m_tests = tests;
    }

    public List<XmlMethodSelector> getMethodSelectors() {
        return this.m_methodSelectors;
    }

    public void setMethodSelectors(List<XmlMethodSelector> methodSelectors) {
        this.m_methodSelectors = methodSelectors;
    }

    private void updateParameters() {
        if (this.m_parentSuite != null) {
            Set<String> keySet = this.m_parentSuite.getParameters().keySet();
            for (String name : keySet) {
                if (this.m_parameters.containsKey(name)) continue;
                this.m_parameters.put(name, this.m_parentSuite.getParameter(name));
            }
        }
    }

    public void setParameters(Map<String, String> parameters) {
        this.m_parameters = parameters;
        this.updateParameters();
    }

    public Map<String, String> getParameters() {
        return this.m_parameters;
    }

    public Map<String, String> getAllParameters() {
        Map<String, String> result = Maps.newHashMap();
        for (Map.Entry<String, String> entry : this.m_parameters.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        for (XmlTest test : this.getTests()) {
            Map<String, String> tp = test.getParameters();
            for (Map.Entry<String, String> entry : tp.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    public String getParameter(String name) {
        return this.m_parameters.get(name);
    }

    public int getThreadCount() {
        return this.m_threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.m_threadCount = threadCount;
    }

    public Boolean isJUnit() {
        return this.m_isJUnit;
    }

    public void setJUnit(Boolean isJUnit) {
        this.m_isJUnit = isJUnit;
    }

    public void setJunit(Boolean j) {
        this.setJUnit(j);
    }

    public Boolean skipFailedInvocationCounts() {
        return this.m_skipFailedInvocationCounts;
    }

    public void setSkipFailedInvocationCounts(boolean skip) {
        this.m_skipFailedInvocationCounts = skip;
    }

    public void setXmlPackages(List<XmlPackage> packages) {
        this.m_xmlPackages = packages;
    }

    public List<XmlPackage> getXmlPackages() {
        return this.m_xmlPackages;
    }

    public List<XmlPackage> getPackages() {
        return this.getXmlPackages();
    }

    public void setPackages(List<XmlPackage> packages) {
        this.setXmlPackages(packages);
    }

    public String toXml() {
        List<String> suiteFiles;
        String parallel;
        XMLStringBuffer xsb = new XMLStringBuffer();
        xsb.setDocType("suite SYSTEM \"http://testng.org/testng-1.0.dtd\"");
        Properties p = new Properties();
        p.setProperty("name", this.getName());
        if (this.getVerbose() != null) {
            XmlUtils.setProperty(p, "verbose", this.getVerbose().toString(), DEFAULT_VERBOSE.toString());
        }
        if (Utils.isStringNotEmpty(parallel = this.getParallel()) && !DEFAULT_PARALLEL.equals(parallel)) {
            p.setProperty("parallel", parallel);
        }
        XmlUtils.setProperty(p, "configfailurepolicy", this.getConfigFailurePolicy(), DEFAULT_CONFIG_FAILURE_POLICY);
        XmlUtils.setProperty(p, "thread-count", String.valueOf(this.getThreadCount()), DEFAULT_THREAD_COUNT.toString());
        XmlUtils.setProperty(p, "data-provider-thread-count", String.valueOf(this.getDataProviderThreadCount()), DEFAULT_DATA_PROVIDER_THREAD_COUNT.toString());
        if (!DEFAULT_JUNIT.equals(this.m_isJUnit)) {
            p.setProperty("junit", this.m_isJUnit != null ? this.m_isJUnit.toString() : "false");
        }
        XmlUtils.setProperty(p, "skipfailedinvocationcounts", this.m_skipFailedInvocationCounts.toString(), DEFAULT_SKIP_FAILED_INVOCATION_COUNTS.toString());
        if (null != this.m_objectFactory) {
            p.setProperty("object-factory", this.m_objectFactory.getClass().getName());
        }
        xsb.push("suite", p);
        for (String paramName : this.m_parameters.keySet()) {
            Properties paramProps = new Properties();
            paramProps.setProperty("name", paramName);
            paramProps.setProperty("value", this.m_parameters.get(paramName));
            xsb.addEmptyElement("parameter", paramProps);
        }
        if (null != this.m_listeners && !this.m_listeners.isEmpty()) {
            xsb.push("listeners");
            for (String listenerName : this.m_listeners) {
                Properties listenerProps = new Properties();
                listenerProps.setProperty("class-name", listenerName);
                xsb.addEmptyElement("listener", listenerProps);
            }
            xsb.pop("listeners");
        }
        if (null != this.getXmlPackages() && !this.getXmlPackages().isEmpty()) {
            xsb.push("packages");
            for (XmlPackage pack : this.getXmlPackages()) {
                xsb.getStringBuffer().append(pack.toXml("    "));
            }
            xsb.pop("packages");
        }
        if (null != this.getMethodSelectors() && !this.getMethodSelectors().isEmpty()) {
            xsb.push("method-selectors");
            for (XmlMethodSelector selector : this.getMethodSelectors()) {
                xsb.getStringBuffer().append(selector.toXml("  "));
            }
            xsb.pop("method-selectors");
        }
        if ((suiteFiles = this.getSuiteFiles()).size() > 0) {
            xsb.push("suite-files");
            for (String sf : suiteFiles) {
                Properties prop = new Properties();
                prop.setProperty("path", sf);
                xsb.addEmptyElement("suite-file", prop);
            }
            xsb.pop("suite-files");
        }
        for (XmlTest test : this.getTests()) {
            xsb.getStringBuffer().append(test.toXml("  "));
        }
        xsb.pop("suite");
        return xsb.toXML();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[Suite: \"").append(this.m_name).append("\" ");
        for (XmlTest t : this.m_tests) {
            result.append("  ").append(t.toString()).append(' ');
        }
        result.append(']');
        return result.toString();
    }

    private static void ppp(String s) {
        System.out.println("[XmlSuite] " + s);
    }

    public Object clone() {
        XmlSuite result = new XmlSuite();
        result.setName(this.getName());
        result.setListeners(this.getListeners());
        result.setParallel(this.getParallel());
        result.setConfigFailurePolicy(this.getConfigFailurePolicy());
        result.setThreadCount(this.getThreadCount());
        result.setDataProviderThreadCount(this.getDataProviderThreadCount());
        result.setParameters(this.getAllParameters());
        result.setVerbose(this.getVerbose());
        result.setXmlPackages(this.getXmlPackages());
        result.setMethodSelectors(this.getMethodSelectors());
        result.setJUnit(this.isJUnit());
        result.setSkipFailedInvocationCounts(this.skipFailedInvocationCounts());
        result.setObjectFactory(this.getObjectFactory());
        return result;
    }

    public void setTimeOut(String timeOut) {
        this.m_timeOut = timeOut;
    }

    public String getTimeOut() {
        return this.m_timeOut;
    }

    public long getTimeOut(long def) {
        long result = def;
        if (this.m_timeOut != null) {
            result = new Long(this.m_timeOut);
        }
        return result;
    }

    public void setSuiteFiles(List<String> files) {
        this.m_suiteFiles = files;
    }

    public List<String> getSuiteFiles() {
        return this.m_suiteFiles;
    }

    public void setListeners(List<String> listeners) {
        this.m_listeners = listeners;
    }

    public List<String> getListeners() {
        if (this.m_parentSuite != null) {
            List<String> listeners = this.m_parentSuite.getListeners();
            for (String listener : listeners) {
                if (this.m_listeners.contains(listener)) continue;
                this.m_listeners.add(listener);
            }
        }
        return this.m_listeners;
    }

    public void setDataProviderThreadCount(int count) {
        this.m_dataProviderThreadCount = count;
    }

    public int getDataProviderThreadCount() {
        String s = System.getProperty("dataproviderthreadcount");
        if (s != null) {
            try {
                int nthreads = Integer.parseInt(s);
                return nthreads;
            }
            catch (NumberFormatException nfe) {
                System.err.println("Parsing System property 'dataproviderthreadcount': " + nfe);
            }
        }
        return this.m_dataProviderThreadCount;
    }

    public void setParentSuite(XmlSuite parentSuite) {
        this.m_parentSuite = parentSuite;
        this.updateParameters();
    }

    public XmlSuite getParentSuite() {
        return this.m_parentSuite;
    }

    public List<XmlSuite> getChildSuites() {
        return this.m_childSuites;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_configFailurePolicy == null ? 0 : this.m_configFailurePolicy.hashCode());
        result = 31 * result + this.m_dataProviderThreadCount;
        result = 31 * result + (this.m_expression == null ? 0 : this.m_expression.hashCode());
        result = 31 * result + (this.m_fileName == null ? 0 : this.m_fileName.hashCode());
        result = 31 * result + (this.m_isJUnit == null ? 0 : this.m_isJUnit.hashCode());
        result = 31 * result + (this.m_listeners == null ? 0 : ((Object)this.m_listeners).hashCode());
        result = 31 * result + (this.m_methodSelectors == null ? 0 : ((Object)this.m_methodSelectors).hashCode());
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        result = 31 * result + (this.m_objectFactory == null ? 0 : this.m_objectFactory.hashCode());
        result = 31 * result + (this.m_parallel == null ? 0 : this.m_parallel.hashCode());
        result = 31 * result + (this.m_skipFailedInvocationCounts == null ? 0 : this.m_skipFailedInvocationCounts.hashCode());
        result = 31 * result + (this.m_suiteFiles == null ? 0 : ((Object)this.m_suiteFiles).hashCode());
        result = 31 * result + (this.m_test == null ? 0 : this.m_test.hashCode());
        result = 31 * result + (this.m_tests == null ? 0 : ((Object)this.m_tests).hashCode());
        result = 31 * result + this.m_threadCount;
        result = 31 * result + (this.m_timeOut == null ? 0 : this.m_timeOut.hashCode());
        result = 31 * result + (this.m_verbose == null ? 0 : this.m_verbose.hashCode());
        result = 31 * result + (this.m_xmlPackages == null ? 0 : ((Object)this.m_xmlPackages).hashCode());
        return result;
    }

    static boolean f() {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return XmlSuite.f();
        }
        if (this.getClass() != obj.getClass()) {
            return XmlSuite.f();
        }
        XmlSuite other = (XmlSuite)obj;
        if (this.m_configFailurePolicy == null ? other.m_configFailurePolicy != null : !this.m_configFailurePolicy.equals(other.m_configFailurePolicy)) {
            return XmlSuite.f();
        }
        if (this.m_dataProviderThreadCount != other.m_dataProviderThreadCount) {
            return XmlSuite.f();
        }
        if (this.m_expression == null ? other.m_expression != null : !this.m_expression.equals(other.m_expression)) {
            return XmlSuite.f();
        }
        if (this.m_isJUnit == null ? other.m_isJUnit != null : !this.m_isJUnit.equals(other.m_isJUnit)) {
            return XmlSuite.f();
        }
        if (this.m_listeners == null ? other.m_listeners != null : !((Object)this.m_listeners).equals(other.m_listeners)) {
            return XmlSuite.f();
        }
        if (this.m_methodSelectors == null ? other.m_methodSelectors != null : !((Object)this.m_methodSelectors).equals(other.m_methodSelectors)) {
            return XmlSuite.f();
        }
        if (this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name)) {
            return XmlSuite.f();
        }
        if (this.m_objectFactory == null ? other.m_objectFactory != null : !this.m_objectFactory.equals(other.m_objectFactory)) {
            return XmlSuite.f();
        }
        if (this.m_parallel == null ? other.m_parallel != null : !this.m_parallel.equals(other.m_parallel)) {
            return XmlSuite.f();
        }
        if (this.m_skipFailedInvocationCounts == null ? other.m_skipFailedInvocationCounts != null : !this.m_skipFailedInvocationCounts.equals(other.m_skipFailedInvocationCounts)) {
            return XmlSuite.f();
        }
        if (this.m_suiteFiles == null ? other.m_suiteFiles != null : !((Object)this.m_suiteFiles).equals(other.m_suiteFiles)) {
            return XmlSuite.f();
        }
        if (this.m_test == null ? other.m_test != null : !this.m_test.equals(other.m_test)) {
            return XmlSuite.f();
        }
        if (this.m_tests == null ? other.m_tests != null : !((Object)this.m_tests).equals(other.m_tests)) {
            return XmlSuite.f();
        }
        if (this.m_threadCount != other.m_threadCount) {
            return XmlSuite.f();
        }
        if (this.m_timeOut == null ? other.m_timeOut != null : !this.m_timeOut.equals(other.m_timeOut)) {
            return XmlSuite.f();
        }
        if (this.m_verbose == null ? other.m_verbose != null : !this.m_verbose.equals(other.m_verbose)) {
            return XmlSuite.f();
        }
        if (this.m_xmlPackages == null ? other.m_xmlPackages != null : !((Object)this.m_xmlPackages).equals(other.m_xmlPackages)) {
            return XmlSuite.f();
        }
        return true;
    }

    private boolean eq(String o1, String o2, String def) {
        boolean result = false;
        if (o1 == null && o2 == null) {
            result = true;
        } else if (o1 != null) {
            result = o1.equals(o2) || def.equals(o1) && o2 == null;
        } else if (o2 != null) {
            result = o2.equals(o1) || def.equals(o2) && o1 == null;
        }
        return result;
    }

    public void setPreserveOrder(String f) {
        this.m_preserveOrder = f;
    }

    public String getPreserveOrder() {
        return this.m_preserveOrder;
    }

    public List<String> getIncludedGroups() {
        return this.m_includedGroups;
    }

    public void addIncludedGroup(String g) {
        this.m_includedGroups.add(g);
    }

    public void setIncludedGroups(List<String> g) {
        this.m_includedGroups = g;
    }

    public void setExcludedGroups(List<String> g) {
        this.m_excludedGroups = g;
    }

    public List<String> getExcludedGroups() {
        return this.m_excludedGroups;
    }

    public void addExcludedGroup(String g) {
        this.m_excludedGroups.add(g);
    }

    public Boolean getGroupByInstances() {
        return this.m_groupByInstances;
    }

    public void setGroupByInstances(boolean f) {
        this.m_groupByInstances = f;
    }

    public void addListener(String listener) {
        this.m_listeners.add(listener);
    }
}

