/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.PathUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.plugins.javaFX.JavaFXBundle;

public final class CreateFxmlFileAction
extends CreateFromTemplateActionBase
implements UpdateInBackground {
    private static final String INTERNAL_TEMPLATE_NAME = "FxmlFile.fxml";

    public CreateFxmlFileAction() {
        super(JavaFXBundle.message("javafx.create.new.fxml.file.title", new Object[0]), JavaFXBundle.message("javafx.create.new.fxml.file.description", new Object[0]), AllIcons.FileTypes.Xml);
    }

    protected FileTemplate getTemplate(Project project, PsiDirectory dir) {
        return FileTemplateManager.getInstance((Project)project).getInternalTemplate(INTERNAL_TEMPLATE_NAME);
    }

    protected Map<String, String> getLiveTemplateDefaults(DataContext dataContext, @NotNull PsiFile file) {
        if (file == null) {
            CreateFxmlFileAction.$$$reportNull$$$0(0);
        }
        String packageName = (String)ReadAction.compute(() -> {
            PsiDirectory psiDirectory = file.getContainingDirectory();
            if (psiDirectory != null) {
                VirtualFile vDirectory = psiDirectory.getVirtualFile();
                ProjectFileIndex index = ProjectRootManager.getInstance((Project)file.getProject()).getFileIndex();
                if (index.isInSourceContent(vDirectory)) {
                    return index.getPackageNameByDirectory(vDirectory);
                }
            }
            return null;
        });
        @NonNls String name = file.getName();
        if ("fxml".equals(PathUtil.getFileExtension((String)(name = PathUtil.getFileName((String)name))))) {
            name = name.substring(0, name.length() - "fxml".length() - 1);
        }
        name = CreateFxmlFileAction.toClassName(name);
        name = !StringUtil.isEmpty((String)packageName) ? packageName + "." + name : name;
        return Collections.singletonMap("CONTROLLER_NAME", name);
    }

    private static String toClassName(String name) {
        char c;
        for (int start = 0; !(start >= name.length() || Character.isJavaIdentifierStart(c = name.charAt(start)) && c != '_' && c != '$'); ++start) {
        }
        StringBuilder className = new StringBuilder();
        boolean skip = true;
        for (int i = start; i < name.length(); ++i) {
            char c2 = name.charAt(i);
            if (!Character.isJavaIdentifierPart(c2) || c2 == '_' || c2 == '$') {
                skip = true;
                continue;
            }
            if (skip) {
                skip = false;
                className.append(Character.toUpperCase(c2));
                continue;
            }
            className.append(c2);
        }
        return className.toString();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateFxmlFileAction.$$$reportNull$$$0(1);
        }
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(CreateFxmlFileAction.isJavaFxTemplateAvailable(dataContext, JavaModuleSourceRootTypes.PRODUCTION));
    }

    static boolean isJavaFxTemplateAvailable(DataContext dataContext, Set<? extends JpsModuleSourceRootType<?>> requiredRootTypes) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || view == null) {
            return false;
        }
        PsiDirectory[] directories = view.getDirectories();
        if (directories.length == 0) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)directories[0].getVirtualFile(), (Project)project);
        if (!CreateFxmlFileAction.hasJavaFxDependency(module)) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        return Arrays.stream(directories).map(PsiDirectory::getVirtualFile).anyMatch(virtualFile -> index.isUnderSourceRootOfType(virtualFile, requiredRootTypes));
    }

    private static boolean hasJavaFxDependency(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            boolean hasClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javafx.application.Application", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
            return CachedValueProvider.Result.create((Object)hasClass, (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/javaFX/actions/CreateFxmlFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLiveTemplateDefaults";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

