/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.kotlin.commonNative.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.kotlin.commonNative.UtilsKt;
import com.jetbrains.kotlin.commonNative.debugger.KonanEvaluator;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0003J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/kotlin/commonNative/debugger/KonanStackFrame;", "Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "frame", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "suspensionCause", "Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;", "debugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "(Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause;Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;)V", "customizePresentation", "", "component", "Lcom/intellij/ui/ColoredTextContainer;", "functionName", "", "getEvaluator", "Lcom/jetbrains/cidr/execution/debugger/CidrEvaluator;", "getSourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "Companion", "kotlin-ultimate.common-native"})
public final class KonanStackFrame
extends CidrStackFrame {
    @NotNull
    private static final Key<HashMap<String, String>> TYPES_INDEX_KEY;
    private static final String KONAN_PREFIX = "kfun:";
    @NotNull
    public static final Companion Companion;

    @Nullable
    public XSourcePosition getSourcePosition() {
        LLFrame lLFrame = this.getFrame();
        Intrinsics.checkNotNullExpressionValue((Object)lLFrame, (String)"frame");
        String string = lLFrame.getFile();
        if (string == null) {
            return super.getSourcePosition();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"frame.file ?: return super.getSourcePosition()");
        String sourceFileName = string;
        CidrDebugProcess cidrDebugProcess = this.getProcess();
        Intrinsics.checkNotNullExpressionValue((Object)cidrDebugProcess, (String)"process");
        VirtualFile virtualFile2 = UtilsKt.findKonanSource(cidrDebugProcess, sourceFileName);
        if (virtualFile2 == null) {
            return super.getSourcePosition();
        }
        VirtualFile sourceFile2 = virtualFile2;
        XDebuggerUtil xDebuggerUtil = XDebuggerUtil.getInstance();
        LLFrame lLFrame2 = this.getFrame();
        Intrinsics.checkNotNullExpressionValue((Object)lLFrame2, (String)"frame");
        return xDebuggerUtil.createPosition(sourceFile2, lLFrame2.getLine());
    }

    public void customizePresentation(@NotNull ColoredTextContainer component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        component2.setIcon(AllIcons.Debugger.Frame);
        if (this.hasSourceFile()) {
            component2.append(this.functionName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            StringBuilder stringBuilder = new StringBuilder().append(' ');
            XSourcePosition xSourcePosition = this.getSourcePosition();
            Intrinsics.checkNotNull((Object)xSourcePosition);
            VirtualFile virtualFile2 = xSourcePosition.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"sourcePosition!!.file");
            StringBuilder stringBuilder2 = stringBuilder.append(virtualFile2.getName()).append(':');
            XSourcePosition xSourcePosition2 = this.getSourcePosition();
            Intrinsics.checkNotNull((Object)xSourcePosition2);
            component2.append(stringBuilder2.append(xSourcePosition2.getLine() + 1).toString(), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        } else {
            component2.append(this.functionName(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            StringBuilder stringBuilder = new StringBuilder().append(" ");
            LLFrame lLFrame = this.getFrame();
            Intrinsics.checkNotNullExpressionValue((Object)lLFrame, (String)"frame");
            component2.append(stringBuilder.append(lLFrame.getProgramCounter()).toString(), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
    }

    @NlsSafe
    private final String functionName() {
        String fullName;
        LLFrame lLFrame = this.getFrame();
        Intrinsics.checkNotNullExpressionValue((Object)lLFrame, (String)"frame");
        String string = lLFrame.getFunction();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"frame.function");
        String unmangledName = string;
        if (!StringsKt.startsWith$default((String)unmangledName, (String)KONAN_PREFIX, (boolean)false, (int)2, null)) {
            return unmangledName;
        }
        if (!StringsKt.contains$default((CharSequence)unmangledName, (char)'(', (boolean)false, (int)2, null)) {
            return StringsKt.removePrefix((String)unmangledName, (CharSequence)KONAN_PREFIX);
        }
        String string2 = unmangledName;
        int n = KONAN_PREFIX.length();
        int n2 = StringsKt.indexOf$default((CharSequence)unmangledName, (char)'(', (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string2 = fullName = string4;
        n = StringsKt.lastIndexOf$default((CharSequence)fullName, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
        n2 = 0;
        String string5 = string2;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
        return string6;
    }

    @NotNull
    public CidrEvaluator getEvaluator() {
        return new KonanEvaluator(this);
    }

    public KonanStackFrame(@NotNull LLThread thread, @NotNull LLFrame frame, @Nullable CidrSuspensionCause suspensionCause, @NotNull CidrDebugProcess debugProcess) {
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        super(debugProcess, thread, frame, suspensionCause);
        final HashMap computedTypes = new HashMap();
        this.getProcess().postCommand(new CidrDebugProcess.VoidDebuggerCommand(){

            public final void run(@NotNull DebuggerDriver driver) {
                Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
                List list2 = driver.getVariables(this.getThreadId(), this.getFrameIndex());
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"driver.getVariables(threadId, frameIndex)");
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String info2;
                    LLValue variable2 = (LLValue)element$iv;
                    boolean bl = false;
                    long l = this.getThreadId();
                    int n = this.getFrameIndex();
                    StringBuilder stringBuilder = new StringBuilder().append("type_name ");
                    LLValue lLValue = variable2;
                    Intrinsics.checkNotNullExpressionValue((Object)lLValue, (String)"variable");
                    Intrinsics.checkNotNullExpressionValue((Object)driver.executeInterpreterCommand(l, n, stringBuilder.append(lLValue.getName()).toString()), (String)"driver.executeInterprete\u2026e_name ${variable.name}\")");
                    CharSequence charSequence = info2;
                    boolean bl2 = false;
                    if (!(charSequence.length() > 0)) continue;
                    Companion.parseTypes(computedTypes, info2, 0, "");
                }
            }
        });
        this.putUserData(TYPES_INDEX_KEY, computedTypes);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"TypesIndex");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<TypesIndex>(\"TypesIndex\")");
        TYPES_INDEX_KEY = key;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\r\u001a\u00020\u000e*\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0007j\u0002`\b2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000RF\u0010\u0005\u001a7\u0012.\u0012,\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004 \t*\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0007j\u0004\u0018\u0001`\b0\u0007j\u0002`\b0\u0006\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/kotlin/commonNative/debugger/KonanStackFrame$Companion;", "", "()V", "KONAN_PREFIX", "", "TYPES_INDEX_KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/util/HashMap;", "Lcom/jetbrains/kotlin/commonNative/debugger/TypesIndex;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getTYPES_INDEX_KEY", "()Lcom/intellij/openapi/util/Key;", "parseTypes", "", "source", "position", "currentPrefix", "kotlin-ultimate.common-native"})
    public static final class Companion {
        @NotNull
        public final Key<HashMap<String, String>> getTYPES_INDEX_KEY() {
            return TYPES_INDEX_KEY;
        }

        private final int parseTypes(HashMap<String, String> $this$parseTypes, String source, int position, String currentPrefix) {
            int space_index = StringsKt.indexOf$default((CharSequence)source, (char)' ', (int)(position + 1), (boolean)false, (int)4, null);
            int close_index = StringsKt.indexOf$default((CharSequence)source, (char)')', (int)(position + 1), (boolean)false, (int)4, null);
            int open_index = StringsKt.indexOf$default((CharSequence)source, (char)'(', (int)(position + 1), (boolean)false, (int)4, null);
            if (position + 1 >= space_index) {
                return source.length();
            }
            StringBuilder stringBuilder = new StringBuilder().append(currentPrefix);
            String string = source;
            int n = position + 1;
            int n2 = 0;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, space_index);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String varName = stringBuilder.append(string3).toString();
            if (close_index < open_index || open_index == -1) {
                string = source;
                n = space_index + 1;
                n2 = 0;
                String string4 = string;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n, close_index);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                $this$parseTypes.put(varName, string5);
                return close_index + 1;
            }
            string = source;
            n = space_index + 1;
            n2 = 0;
            String string6 = string;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n, open_index);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            $this$parseTypes.put(varName, string7);
            int scannedTo = open_index;
            while (scannedTo < source.length() && source.charAt(scannedTo) == '(') {
                scannedTo = this.parseTypes($this$parseTypes, source, scannedTo, varName + '.');
            }
            n = source.length();
            n2 = scannedTo + 1;
            boolean bl = false;
            return Math.min(n, n2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

