/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.ModuleInfoUtilsKt;
import org.jetbrains.kotlin.descriptors.ModuleCapability;
import org.jetbrains.kotlin.idea.KotlinIdeaAnalysisBundle;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleOrigin;
import org.jetbrains.kotlin.idea.caches.project.SdkScope;
import org.jetbrains.kotlin.idea.framework.KotlinSdkType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.resolve.PlatformDependentAnalyzerServices;
import org.jetbrains.kotlin.resolve.jvm.platform.JvmPlatformAnalyzerServices;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\b\u0010'\u001a\u00020(H\u0016J\u001d\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00010+H\u0016J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\u0012H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR&\u0010\u000b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/caches/project/SdkInfo;", "Lorg/jetbrains/kotlin/idea/caches/project/IdeaModuleInfo;", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;)V", "analyzerServices", "Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "getAnalyzerServices", "()Lorg/jetbrains/kotlin/resolve/PlatformDependentAnalyzerServices;", "capabilities", "", "Lorg/jetbrains/kotlin/descriptors/ModuleCapability;", "", "getCapabilities", "()Ljava/util/Map;", "displayedName", "", "getDisplayedName", "()Ljava/lang/String;", "moduleOrigin", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleOrigin;", "getModuleOrigin", "()Lorg/jetbrains/kotlin/idea/caches/project/ModuleOrigin;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSdk", "()Lcom/intellij/openapi/projectRoots/Sdk;", "component1", "component2", "contentScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "copy", "dependencies", "", "equals", "", "other", "hashCode", "", "toString", "kotlin.core"})
public final class SdkInfo
implements IdeaModuleInfo {
    @NotNull
    private final Name name;
    @NotNull
    private final Project project;
    @NotNull
    private final Sdk sdk;

    @Override
    @NotNull
    public ModuleOrigin getModuleOrigin() {
        return ModuleOrigin.LIBRARY;
    }

    @NotNull
    public Name getName() {
        return this.name;
    }

    @NotNull
    public String getDisplayedName() {
        Object[] objectArray = new Object[1];
        String string = this.sdk.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdk.name");
        objectArray[0] = string;
        return KotlinIdeaAnalysisBundle.message("sdk.0", objectArray);
    }

    @Override
    @NotNull
    public GlobalSearchScope contentScope() {
        return (GlobalSearchScope)new SdkScope(this.getProject(), this.sdk);
    }

    @Override
    @NotNull
    public List<IdeaModuleInfo> dependencies() {
        return CollectionsKt.listOf((Object)this);
    }

    @NotNull
    public TargetPlatform getPlatform() {
        return this.sdk.getSdkType() instanceof KotlinSdkType ? CommonPlatforms.INSTANCE.getDefaultCommonPlatform() : JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
    }

    @NotNull
    public PlatformDependentAnalyzerServices getAnalyzerServices() {
        return (PlatformDependentAnalyzerServices)JvmPlatformAnalyzerServices.INSTANCE;
    }

    @Override
    @NotNull
    public Map<ModuleCapability<?>, Object> getCapabilities() {
        SdkTypeId sdkTypeId = this.sdk.getSdkType();
        return sdkTypeId instanceof JavaSdk ? MapsKt.plus(IdeaModuleInfo.DefaultImpls.getCapabilities(this), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)ModuleInfoUtilsKt.getJDK_CAPABILITY(), (Object)true))) : IdeaModuleInfo.DefaultImpls.getCapabilities(this);
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final Sdk getSdk() {
        return this.sdk;
    }

    public SdkInfo(@NotNull Project project2, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        this.project = project2;
        this.sdk = sdk2;
        Name name2 = Name.special((String)("<sdk " + this.sdk.getName() + '>'));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"Name.special(\"<sdk ${sdk.name}>\")");
        this.name = name2;
    }

    @NotNull
    public List<ModuleInfo> getExpectedBy() {
        return IdeaModuleInfo.DefaultImpls.getExpectedBy(this);
    }

    @Nullable
    public Name getStableName() {
        return IdeaModuleInfo.DefaultImpls.getStableName(this);
    }

    @NotNull
    public ModuleInfo.DependencyOnBuiltIns dependencyOnBuiltIns() {
        return IdeaModuleInfo.DefaultImpls.dependencyOnBuiltIns(this);
    }

    @NotNull
    public Collection<ModuleInfo> modulesWhoseInternalsAreVisible() {
        return IdeaModuleInfo.DefaultImpls.modulesWhoseInternalsAreVisible(this);
    }

    @NotNull
    public final Project component1() {
        return this.getProject();
    }

    @NotNull
    public final Sdk component2() {
        return this.sdk;
    }

    @NotNull
    public final SdkInfo copy(@NotNull Project project2, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        return new SdkInfo(project2, sdk2);
    }

    public static /* synthetic */ SdkInfo copy$default(SdkInfo sdkInfo, Project project2, Sdk sdk2, int n, Object object) {
        if ((n & 1) != 0) {
            project2 = sdkInfo.getProject();
        }
        if ((n & 2) != 0) {
            sdk2 = sdkInfo.sdk;
        }
        return sdkInfo.copy(project2, sdk2);
    }

    @NotNull
    public String toString() {
        return "SdkInfo(project=" + this.getProject() + ", sdk=" + this.sdk + ")";
    }

    public int hashCode() {
        Project project2 = this.getProject();
        Sdk sdk2 = this.sdk;
        return (project2 != null ? project2.hashCode() : 0) * 31 + (sdk2 != null ? sdk2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SdkInfo)) break block3;
                SdkInfo sdkInfo = (SdkInfo)object;
                if (!Intrinsics.areEqual((Object)this.getProject(), (Object)sdkInfo.getProject()) || !Intrinsics.areEqual((Object)this.sdk, (Object)sdkInfo.sdk)) break block3;
            }
            return true;
        }
        return false;
    }
}

