/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.codeInsight.RestoreReferencesDialog;
import org.jetbrains.kotlin.idea.codeInsight.ReviewAddedImports;
import org.jetbrains.kotlin.idea.imports.KotlinImportOptimizer;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.resolve.ImportPath;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J,\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018J&\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001bH\u0002J\"\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\t\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/ReviewAddedImports;", "", "()V", "importsToBeDeleted", "", "", "getImportsToBeDeleted", "()Ljava/util/Collection;", "setImportsToBeDeleted", "(Ljava/util/Collection;)V", "importsToBeReviewed", "getImportsToBeReviewed", "setImportsToBeReviewed", "removeImports", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "importsToRemove", "reviewAddedImports", "editor", "Lcom/intellij/openapi/editor/Editor;", "imported", "Ljava/util/TreeSet;", "reviewImports", "importedClasses", "", "showHint", "info", "hyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "kotlin.idea"})
public final class ReviewAddedImports {
    @NotNull
    private static Collection<String> importsToBeReviewed;
    @NotNull
    private static Collection<String> importsToBeDeleted;
    @NotNull
    public static final ReviewAddedImports INSTANCE;

    @TestOnly
    @NotNull
    public final Collection<String> getImportsToBeReviewed() {
        return importsToBeReviewed;
    }

    public final void setImportsToBeReviewed(@NotNull Collection<String> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        importsToBeReviewed = collection;
    }

    @TestOnly
    @NotNull
    public final Collection<String> getImportsToBeDeleted() {
        return importsToBeDeleted;
    }

    public final void setImportsToBeDeleted(@NotNull Collection<String> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        importsToBeDeleted = collection;
    }

    public final void reviewAddedImports(@NotNull Project project2, @NotNull Editor editor2, @NotNull KtFile file2, @NotNull TreeSet<String> imported) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(imported, (String)"imported");
        if (CodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE == 1 && !imported.isEmpty()) {
            boolean $i$f$isUnitTestMode = false;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            if (application.isUnitTestMode()) {
                importsToBeReviewed = imported;
                this.removeImports(project2, file2, importsToBeDeleted);
                return;
            }
            String notificationText = KotlinBundle.htmlMessage("copy.paste.reference.notification", imported.size());
            ApplicationManager.getApplication().invokeLater(new Runnable(editor2, notificationText, project2, file2, imported){
                final /* synthetic */ Editor $editor;
                final /* synthetic */ String $notificationText;
                final /* synthetic */ Project $project;
                final /* synthetic */ KtFile $file;
                final /* synthetic */ TreeSet $imported;

                public final void run() {
                    ReviewAddedImports.access$showHint(ReviewAddedImports.INSTANCE, this.$editor, this.$notificationText, new HyperlinkListener(this){
                        final /* synthetic */ reviewAddedImports.1 this$0;

                        public final void hyperlinkUpdate(@NotNull HyperlinkEvent e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                                ReviewAddedImports.access$reviewImports(ReviewAddedImports.INSTANCE, this.this$0.$project, this.this$0.$file, this.this$0.$imported);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.$editor = editor2;
                    this.$notificationText = string;
                    this.$project = project2;
                    this.$file = ktFile;
                    this.$imported = treeSet;
                }
            }, ModalityState.NON_MODAL);
        }
    }

    private final void showHint(Editor editor2, @Nls String info2, HyperlinkListener hyperlinkListener) {
        boolean $i$f$isUnitTestMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            return;
        }
        LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel((String)info2, (HyperlinkListener)hyperlinkListener, null, null));
        int flags = 10;
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor2, (short)2, flags, 0, false);
    }

    /*
     * WARNING - void declaration
     */
    private final void reviewImports(Project project2, KtFile file2, Set<String> importedClasses) {
        RestoreReferencesDialog dialog2 = new RestoreReferencesDialog(project2, ArrayUtil.toObjectArray((Collection)importedClasses));
        dialog2.setTitle(KotlinBundle.message("dialog.import.on.paste.title3", new Object[0]));
        if (dialog2.showAndGet()) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object[] objectArray = dialog2.getSelectedElements();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"dialog.selectedElements");
            Object[] objectArray2 = objectArray;
            KtFile ktFile = file2;
            Project project3 = project2;
            ReviewAddedImports reviewAddedImports2 = this;
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var10_13 = $this$mapTo$iv$iv;
            int n = ((void)var10_13).length;
            for (int j = 0; j < n; ++j) {
                void it;
                void item$iv$iv;
                void var14_17 = item$iv$iv = var10_13[j];
                collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                if (v1 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                String string = (String)v1;
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            reviewAddedImports2.removeImports(project3, ktFile, CollectionsKt.toSortedSet((Iterable)collection));
        }
    }

    private final void removeImports(Project project2, KtFile file2, Collection<String> importsToRemove) {
        if (importsToRemove.isEmpty()) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project2, (String)KotlinBundle.message("revert.applied.imports.command", new Object[0]), null, (Runnable)new Runnable(file2, importsToRemove){
            final /* synthetic */ KtFile $file;
            final /* synthetic */ Collection $importsToRemove;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = this.$file.getImportDirectives();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ImportPath importPath2;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    KtImportDirective it = (KtImportDirective)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getImportedFqName() == null) {
                        importPath2 = null;
                    } else {
                        FqName importedFqName;
                        Intrinsics.checkNotNullExpressionValue((Object)importedFqName, (String)"it.importedFqName ?: return@mapNotNull null");
                        if (this.$importsToRemove.contains(importedFqName.asString())) {
                            importPath2 = null;
                        } else {
                            Name name2;
                            FqName fqName2 = importedFqName;
                            boolean bl3 = it.isAllUnder();
                            if (it.getAliasName() != null) {
                                void alias;
                                String string;
                                boolean bl4 = false;
                                boolean bl5 = false;
                                String string2 = string;
                                boolean bl6 = bl3;
                                FqName fqName3 = fqName2;
                                boolean bl7 = false;
                                Name name3 = Name.identifier((String)alias);
                                fqName2 = fqName3;
                                bl3 = bl6;
                                name2 = name3;
                            } else {
                                name2 = null;
                            }
                            Name name4 = name2;
                            boolean bl8 = bl3;
                            FqName fqName4 = fqName2;
                            importPath2 = new ImportPath(fqName4, bl8, name4);
                        }
                    }
                    if (importPath2 == null) continue;
                    ImportPath importPath3 = importPath2;
                    boolean bl9 = false;
                    boolean bl10 = false;
                    ImportPath it$iv$iv = importPath3;
                    boolean bl11 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List newImports = (List)destination$iv$iv;
                KotlinImportOptimizer.Companion.replaceImports(this.$file, newImports);
            }
            {
                this.$file = ktFile;
                this.$importsToRemove = collection;
            }
        }, (PsiFile[])new PsiFile[0]);
    }

    private ReviewAddedImports() {
    }

    static {
        ReviewAddedImports reviewAddedImports2;
        INSTANCE = reviewAddedImports2 = new ReviewAddedImports();
        importsToBeReviewed = CollectionsKt.emptyList();
        importsToBeDeleted = CollectionsKt.emptyList();
    }

    public static final /* synthetic */ void access$showHint(ReviewAddedImports $this, Editor editor2, String info2, HyperlinkListener hyperlinkListener) {
        $this.showHint(editor2, info2, hyperlinkListener);
    }

    public static final /* synthetic */ void access$reviewImports(ReviewAddedImports $this, Project project2, KtFile file2, Set importedClasses) {
        $this.reviewImports(project2, file2, importedClasses);
    }
}

