/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.surroundWith.expression;

import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.surroundWith.KotlinExpressionSurrounder;
import org.jetbrains.kotlin.idea.quickfix.AddWhenRemainingBranchesFix;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0017J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/surroundWith/expression/KotlinWhenSurrounder;", "Lorg/jetbrains/kotlin/idea/core/surroundWith/KotlinExpressionSurrounder;", "()V", "getTemplateDescription", "", "surroundExpression", "Lcom/intellij/openapi/util/TextRange;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "kotlin.idea"})
public final class KotlinWhenSurrounder
extends KotlinExpressionSurrounder {
    @NlsSafe
    @NotNull
    public String getTemplateDescription() {
        return "when (expr) {}";
    }

    @Override
    @NotNull
    protected TextRange surroundExpression(@NotNull Project project2, @NotNull Editor editor2, @NotNull KtExpression expression2) {
        int n;
        KtWhenExpression whenExpression2;
        boolean hasRemainingBranches;
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        String template2 = "when(a) { \nb -> {}\n else -> {}\n}";
        KtExpression ktExpression = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)expression2), (boolean)false, (int)2, null).createExpression(template2);
        if (ktExpression == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenExpression");
        }
        KtWhenExpression ktWhenExpression = (KtWhenExpression)ktExpression;
        boolean bl = false;
        boolean bl2 = false;
        KtWhenExpression it2 = ktWhenExpression;
        boolean bl3 = false;
        KtExpression ktExpression2 = it2.getSubjectExpression();
        if (ktExpression2 != null) {
            ktExpression2.replace((PsiElement)expression2);
        }
        PsiElement $this$replaced$iv = (PsiElement)expression2;
        boolean $i$f$replaced = false;
        PsiElement result$iv = $this$replaced$iv.replace((PsiElement)it2);
        PsiElement psiElement3 = result$iv;
        if (!(psiElement3 instanceof KtWhenExpression)) {
            psiElement3 = null;
        }
        if ((psiElement2 = (PsiElement)((KtWhenExpression)psiElement3)) == null) {
            PsiElement psiElement4 = result$iv;
            if (psiElement4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
            }
            KtExpression ktExpression3 = ((KtParenthesizedExpression)psiElement4).getExpression();
            if (ktExpression3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtWhenExpression");
            }
            psiElement2 = (PsiElement)((KtWhenExpression)ktExpression3);
        }
        if (hasRemainingBranches = AddWhenRemainingBranchesFix.Companion.isAvailable(whenExpression2 = (KtWhenExpression)psiElement2)) {
            AddWhenRemainingBranchesFix.Companion.addRemainingBranches$default(AddWhenRemainingBranchesFix.Companion, whenExpression2, false, 2, null);
            List list2 = whenExpression2.getEntries();
            bl2 = false;
            boolean it2 = false;
            List it3 = list2;
            boolean bl4 = false;
            List list3 = it3;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"it");
            ((KtWhenEntry)CollectionsKt.first((List)list3)).delete();
            ((KtWhenEntry)CollectionsKt.last((List)it3)).delete();
        }
        CodeInsightUtilBase.forcePsiPostprocessAndRestoreElement((PsiElement)((PsiElement)whenExpression2));
        List list4 = whenExpression2.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"whenExpression.entries");
        KtWhenEntry firstEntry2 = (KtWhenEntry)CollectionsKt.first((List)list4);
        if (hasRemainingBranches) {
            KtWhenEntry ktWhenEntry = firstEntry2;
            Intrinsics.checkNotNullExpressionValue((Object)ktWhenEntry, (String)"firstEntry");
            KtExpression ktExpression4 = ktWhenEntry.getExpression();
            n = ktExpression4 != null ? UtilsKt.getStartOffset((PsiElement)((PsiElement)ktExpression4)) : UtilsKt.getStartOffset((PsiElement)((PsiElement)firstEntry2));
        } else {
            KtWhenEntry ktWhenEntry = firstEntry2;
            Intrinsics.checkNotNullExpressionValue((Object)ktWhenEntry, (String)"firstEntry");
            Object[] objectArray = ktWhenEntry.getConditions();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"firstEntry.conditions");
            Object object = ArraysKt.first((Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"firstEntry.conditions.first()");
            TextRange conditionRange = ((KtWhenCondition)object).getTextRange();
            Document document = editor2.getDocument();
            TextRange textRange = conditionRange;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"conditionRange");
            document.deleteString(textRange.getStartOffset(), conditionRange.getEndOffset());
            n = conditionRange.getStartOffset();
        }
        int offset2 = n;
        return new TextRange(offset2, offset2);
    }
}

