/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.UntraceableException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/KotlinCompilerStartupActivity;", "Lcom/intellij/openapi/startup/StartupActivity;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "KotlinCompilerException", "kotlin.jvm"})
public final class KotlinCompilerStartupActivity
implements StartupActivity {
    private static final Logger LOG;
    private static final String PREFIX_WITH_COMPILER_NAME = "Kotlin: [Internal Error] ";
    private static final Set<String> FILE_EXTS_WHICH_NEEDS_REFRESH;
    @NotNull
    public static final Companion Companion;

    public void runActivity(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        project2.getMessageBus().connect().subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){

            public void compilationFinished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
                Intrinsics.checkNotNullParameter((Object)compileContext, (String)"compileContext");
                CompilerMessage[] compilerMessageArray = compileContext.getMessages(CompilerMessageCategory.ERROR);
                int n = compilerMessageArray.length;
                for (int j = 0; j < n; ++j) {
                    String message2;
                    CompilerMessage error2;
                    CompilerMessage compilerMessage = error2 = compilerMessageArray[j];
                    Intrinsics.checkNotNullExpressionValue((Object)compilerMessage, (String)"error");
                    String string = message2 = compilerMessage.getMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message");
                    if (!StringsKt.startsWith$default((String)string, (String)"[Internal Error] ", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)message2, (String)"Kotlin: [Internal Error] ", (boolean)false, (int)2, null)) continue;
                    KotlinCompilerStartupActivity.access$getLOG$cp().error((Throwable)((Object)new KotlinCompilerException(message2)));
                }
            }

            public void fileGenerated(@NotNull String outputRoot, @NotNull String relativePath) {
                Intrinsics.checkNotNullParameter((Object)outputRoot, (String)"outputRoot");
                Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
                boolean $i$f$isUnitTestMode = false;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    return;
                }
                String string = FileUtilRt.getExtension((String)relativePath);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtilRt.getExtension(relativePath)");
                String string2 = string;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                String ext = string4;
                if (KotlinCompilerStartupActivity.access$getFILE_EXTS_WHICH_NEEDS_REFRESH$cp().contains(ext)) {
                    String outFile = outputRoot + '/' + relativePath;
                    VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(outFile);
                    if (virtualFile2 == null) {
                        String string5 = "Virtual file not found for generated file path: " + outFile;
                        boolean bl2 = false;
                        throw (Throwable)new IllegalStateException(string5.toString());
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"LocalFileSystem.getInsta\u2026ted file path: $outFile\")");
                    VirtualFile virtualFile3 = virtualFile2;
                    virtualFile3.refresh(false, false);
                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinCompilerStartupActivity.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Kotli\u2026rtupActivity::class.java)");
        LOG = logger;
        FILE_EXTS_WHICH_NEEDS_REFRESH = SetsKt.setOf((Object[])new String[]{".js", ".map"});
    }

    public static final /* synthetic */ Set access$getFILE_EXTS_WHICH_NEEDS_REFRESH$cp() {
        return FILE_EXTS_WHICH_NEEDS_REFRESH;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/KotlinCompilerStartupActivity$KotlinCompilerException;", "Lcom/intellij/diagnostic/PluginException;", "Lcom/intellij/openapi/diagnostic/UntraceableException;", "text", "", "(Ljava/lang/String;)V", "message", "getMessage", "()Ljava/lang/String;", "fillInStackTrace", "", "getStackTrace", "", "Ljava/lang/StackTraceElement;", "()[Ljava/lang/StackTraceElement;", "printStackTrace", "", "s", "Ljava/io/PrintStream;", "Ljava/io/PrintWriter;", "kotlin.jvm"})
    private static final class KotlinCompilerException
    extends PluginException
    implements UntraceableException {
        private final String text;

        public void printStackTrace(@NotNull PrintWriter s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            s.print(this.text);
        }

        public void printStackTrace(@NotNull PrintStream s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            s.print(this.text);
        }

        @NotNull
        public synchronized Throwable fillInStackTrace() {
            return (Throwable)((Object)this);
        }

        @NotNull
        public StackTraceElement[] getStackTrace() {
            LOG.error("Somebody called getStackTrace() on KotlinCompilerException");
            StackTraceElement[] stackTraceElementArray = new UnsupportedOperationException().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"UnsupportedOperationException().stackTrace");
            return stackTraceElementArray;
        }

        @NotNull
        public String getMessage() {
            return "<Exception from standalone Kotlin compiler>";
        }

        public KotlinCompilerException(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            super("", PluginManagerCore.getPluginByClassName((String)KotlinCompilerStartupActivity.class.getName()));
            this.text = text2;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/KotlinCompilerStartupActivity$Companion;", "", "()V", "FILE_EXTS_WHICH_NEEDS_REFRESH", "", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PREFIX_WITH_COMPILER_NAME", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

