/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.loader;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ErrorHandlingKt;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.SourceCode;
import kotlin.script.experimental.dependencies.AsyncDependenciesResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.CachedConfigurationInputs;
import org.jetbrains.kotlin.idea.core.script.configuration.cache.ScriptConfigurationSnapshot;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.DefaultScriptConfigurationLoader;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.ScriptConfigurationLoader;
import org.jetbrains.kotlin.idea.core.script.configuration.loader.ScriptConfigurationLoadingContext;
import org.jetbrains.kotlin.idea.core.script.settings.KotlinScriptingSettings;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.KotlinScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;
import org.jetbrains.kotlin.scripting.resolve.LegacyResolverWrapper;
import org.jetbrains.kotlin.scripting.resolve.RefineCompilationConfigurationKt;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0014J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/DefaultScriptConfigurationLoader;", "Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptConfigurationLoader;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getConfigurationThroughScriptingApi", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/ScriptConfigurationSnapshot;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "vFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "scriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getInputsStamp", "Lorg/jetbrains/kotlin/idea/core/script/configuration/cache/CachedConfigurationInputs;", "virtualFile", "loadDependencies", "", "isFirstLoad", "ktFile", "context", "Lorg/jetbrains/kotlin/idea/core/script/configuration/loader/ScriptConfigurationLoadingContext;", "shouldRunInBackground", "kotlin.core"})
public class DefaultScriptConfigurationLoader
implements ScriptConfigurationLoader {
    @NotNull
    private final Project project;

    @Override
    public boolean shouldRunInBackground(@NotNull ScriptDefinition scriptDefinition) {
        boolean bl;
        Object object;
        KotlinScriptDefinition kotlinScriptDefinition;
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDefinition), (String)"scriptDefinition");
        ScriptDefinition this_$iv = scriptDefinition;
        boolean $i$f$asLegacyOrNull = false;
        if (this_$iv instanceof ScriptDefinition.FromLegacy) {
            kotlinScriptDefinition = this_$iv.getLegacyDefinition();
            if (!(kotlinScriptDefinition instanceof KotlinScriptDefinition)) {
                kotlinScriptDefinition = null;
            }
        } else {
            kotlinScriptDefinition = object = null;
        }
        if (kotlinScriptDefinition != null && (object = object.getDependencyResolver()) != null) {
            Object object2 = object;
            boolean bl2 = false;
            boolean bl3 = false;
            Object it = object2;
            boolean bl4 = false;
            bl = it instanceof AsyncDependenciesResolver || it instanceof LegacyResolverWrapper;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean loadDependencies(boolean isFirstLoad, @NotNull KtFile ktFile, @NotNull ScriptDefinition scriptDefinition, @NotNull ScriptConfigurationLoadingContext context2) {
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDefinition), (String)"scriptDefinition");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.project.isDisposed()) {
            return false;
        }
        PsiFile psiFile2 = ktFile.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"ktFile.originalFile");
        VirtualFile virtualFile3 = virtualFile2 = psiFile2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"virtualFile");
        ScriptConfigurationSnapshot result2 = this.getConfigurationThroughScriptingApi(ktFile, virtualFile3, scriptDefinition);
        if (KotlinScriptingSettings.Companion.getInstance(this.project).autoReloadConfigurations(scriptDefinition)) {
            context2.saveNewConfiguration(virtualFile2, result2);
        } else {
            context2.suggestNewConfiguration(virtualFile2, result2);
        }
        return true;
    }

    @NotNull
    protected final ScriptConfigurationSnapshot getConfigurationThroughScriptingApi(@NotNull KtFile file2, @NotNull VirtualFile vFile, @NotNull ScriptDefinition scriptDefinition) {
        ResultWithDiagnostics resultWithDiagnostics;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)vFile, (String)"vFile");
        Intrinsics.checkNotNullParameter((Object)((Object)scriptDefinition), (String)"scriptDefinition");
        ScriptUtilsKt.scriptingDebugLog(file2, (Function0<String>)((Function0)getConfigurationThroughScriptingApi.1.INSTANCE));
        CachedConfigurationInputs inputs = this.getInputsStamp(vFile, file2);
        try {
            SourceCode sourceCode = new KtFileScriptSource(file2, null, 2, null);
            Project project2 = file2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
            resultWithDiagnostics = RefineCompilationConfigurationKt.refineScriptCompilationConfiguration$default(sourceCode, scriptDefinition, project2, null, 8, null);
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            resultWithDiagnostics = new ResultWithDiagnostics.Failure(CollectionsKt.listOf((Object)ErrorHandlingKt.asDiagnostics$default(e, 0, null, null, null, null, 31, null)));
        }
        ResultWithDiagnostics scriptingApiResult = resultWithDiagnostics;
        ScriptConfigurationSnapshot result2 = new ScriptConfigurationSnapshot(inputs, scriptingApiResult.getReports(), (ScriptCompilationConfigurationWrapper)ErrorHandlingKt.valueOrNull(scriptingApiResult));
        ScriptUtilsKt.scriptingDebugLog(file2, (Function0<String>)((Function0)getConfigurationThroughScriptingApi.2.INSTANCE));
        return result2;
    }

    @NotNull
    protected CachedConfigurationInputs getInputsStamp(@NotNull VirtualFile virtualFile2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return CachedConfigurationInputs.PsiModificationStamp.Companion.get(this.project, virtualFile2, file2);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public DefaultScriptConfigurationLoader(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    @Override
    public boolean interceptBackgroundLoading(@NotNull VirtualFile file2, boolean isFirstLoad, @NotNull Function0<Unit> doLoad) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(doLoad, (String)"doLoad");
        return ScriptConfigurationLoader.DefaultImpls.interceptBackgroundLoading(this, file2, isFirstLoad, doLoad);
    }

    @Override
    public void hideInterceptedNotification(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ScriptConfigurationLoader.DefaultImpls.hideInterceptedNotification(this, file2);
    }
}

