/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.idea.debugger.InlineStackFrameVariableHolder;
import org.jetbrains.kotlin.idea.debugger.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.NoStrataPositionManagerHelperKt;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B%\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/InlineStackFrameVariableHolder;", "", "sortedVariables", "", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "variableFrameIds", "", "currentFrameId", "", "(Ljava/util/List;[II)V", "parentFrame", "getParentFrame", "()Lorg/jetbrains/kotlin/idea/debugger/InlineStackFrameVariableHolder;", "visibleVariables", "getVisibleVariables", "()Ljava/util/List;", "Companion", "kotlin.jvm-debugger.util"})
public final class InlineStackFrameVariableHolder {
    private final List<LocalVariableProxyImpl> sortedVariables;
    private final int[] variableFrameIds;
    private final int currentFrameId;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LocalVariableProxyImpl> getVisibleVariables() {
        void $this$mapIndexedNotNullTo$iv$iv;
        Iterable $this$mapIndexedNotNull$iv = this.sortedVariables;
        boolean $i$f$mapIndexedNotNull = false;
        Iterable iterable = $this$mapIndexedNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapIndexedNotNullTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            Object e;
            void variable2;
            void element$iv$iv;
            int n = index$iv$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl2 = false;
            LocalVariableProxyImpl localVariableProxyImpl = (LocalVariableProxyImpl)element$iv$iv;
            int index2 = index$iv$iv;
            boolean bl3 = false;
            if ((this.variableFrameIds[index2] == this.currentFrameId ? variable2 : null) == null) continue;
            e = e;
            boolean bl4 = false;
            boolean bl5 = false;
            Object it$iv$iv = e;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final InlineStackFrameVariableHolder getParentFrame() {
        int n;
        int n2;
        int[] parentVariableFrameIds;
        List<LocalVariableProxyImpl> parentSortedVariables;
        block6: {
            int scopeVariableIndex;
            block5: {
                int n3;
                List<LocalVariableProxyImpl> $this$indexOfLast$iv = this.sortedVariables;
                boolean $i$f$indexOfLast = false;
                ListIterator<LocalVariableProxyImpl> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    LocalVariableProxyImpl it = iterator$iv.previous();
                    boolean bl = false;
                    String string = it.name();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name()");
                    if (!InlineCodegenUtilsKt.isFakeLocalVariableForInline((String)string)) continue;
                    n3 = iterator$iv.nextIndex();
                    break block5;
                }
                n3 = scopeVariableIndex = -1;
            }
            if (scopeVariableIndex < 0) {
                return null;
            }
            parentSortedVariables = this.sortedVariables.subList(0, scopeVariableIndex);
            parentVariableFrameIds = ArraysKt.sliceArray((int[])this.variableFrameIds, (IntRange)RangesKt.until((int)0, (int)scopeVariableIndex));
            List<LocalVariableProxyImpl> $this$indexOfLast$iv = parentSortedVariables;
            boolean $i$f$indexOfLast = false;
            ListIterator<LocalVariableProxyImpl> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                LocalVariableProxyImpl it = iterator$iv.previous();
                boolean bl = false;
                String string = it.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name()");
                if (!InlineCodegenUtilsKt.isFakeLocalVariableForInline((String)string)) continue;
                n2 = iterator$iv.nextIndex();
                break block6;
            }
            n2 = -1;
        }
        Integer n4 = n2;
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n4).intValue();
        boolean bl3 = false;
        Integer n5 = it >= 0 ? n4 : null;
        if (n5 != null) {
            n4 = n5;
            bl = false;
            bl2 = false;
            it = ((Number)n4).intValue();
            boolean bl4 = false;
            n = this.variableFrameIds[it];
        } else {
            n = 0;
        }
        int parentFrameId = n;
        return new InlineStackFrameVariableHolder(parentSortedVariables, parentVariableFrameIds, parentFrameId);
    }

    private InlineStackFrameVariableHolder(List<? extends LocalVariableProxyImpl> sortedVariables, int[] variableFrameIds, int currentFrameId) {
        this.sortedVariables = sortedVariables;
        this.variableFrameIds = variableFrameIds;
        this.currentFrameId = currentFrameId;
    }

    public /* synthetic */ InlineStackFrameVariableHolder(List sortedVariables, int[] variableFrameIds, int currentFrameId, DefaultConstructorMarker $constructor_marker) {
        this(sortedVariables, variableFrameIds, currentFrameId);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/InlineStackFrameVariableHolder$Companion;", "", "()V", "fromSortedVisibleVariables", "Lorg/jetbrains/kotlin/idea/debugger/InlineStackFrameVariableHolder;", "sortedVariables", "", "Lcom/intellij/debugger/jdi/LocalVariableProxyImpl;", "fromStackFrame", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "getFieldValue", "Lcom/sun/jdi/LocalVariable;", "name", "", "kotlin.jvm-debugger.util"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final InlineStackFrameVariableHolder fromSortedVisibleVariables(List<? extends LocalVariableProxyImpl> sortedVariables) {
            int[] variableFrameIds = new int[sortedVariables.size()];
            List<Integer> activeFrames = CollectionsKt.mutableListOf((Object[])new Integer[]{0});
            boolean bl = false;
            List pendingVariables = new ArrayList();
            int nextFrameId = 1;
            boolean bl2 = false;
            for (LocalVariableProxyImpl variable2 : (Iterable)sortedVariables) {
                void currentIndex;
                Object object;
                String name2;
                String string = name2 = variable2.name();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                int depth2 = InlineUtilsKt.getInlineDepth(string);
                if (StringsKt.startsWith$default((String)name2, (String)"$i$f$", (boolean)false, (int)2, null)) {
                    int frameId = nextFrameId++;
                    activeFrames.add(frameId);
                    Iterator iterator = pendingVariables.iterator();
                    while (iterator.hasNext()) {
                        int pending = ((Number)iterator.next()).intValue();
                        variableFrameIds[pending] = frameId;
                    }
                    pendingVariables.clear();
                    variableFrameIds[currentIndex] = frameId;
                } else if (StringsKt.startsWith$default((String)name2, (String)"$i$a$", (boolean)false, (int)2, null)) {
                    object = pendingVariables.iterator();
                    while (object.hasNext()) {
                        int pending = ((Number)object.next()).intValue();
                        variableFrameIds[pending] = -1;
                    }
                    pendingVariables.clear();
                    if (depth2 + 1 < activeFrames.size()) {
                        activeFrames = activeFrames.subList(0, depth2 + 1);
                    }
                    variableFrameIds[currentIndex] = ((Number)CollectionsKt.last((List)activeFrames)).intValue();
                } else if (depth2 < activeFrames.size()) {
                    variableFrameIds[currentIndex] = ((Number)activeFrames.get(depth2)).intValue();
                } else if (depth2 == activeFrames.size()) {
                    Collection collection = pendingVariables;
                    object = (int)currentIndex;
                    boolean bl3 = false;
                    collection.add(object);
                } else {
                    variableFrameIds[currentIndex] = -1;
                }
                ++currentIndex;
            }
            return new InlineStackFrameVariableHolder(sortedVariables, variableFrameIds, ((Number)CollectionsKt.last((List)activeFrames)).intValue(), null);
        }

        @NotNull
        public final InlineStackFrameVariableHolder fromStackFrame(@NotNull StackFrameProxyImpl frame) {
            List<LocalVariable> allVariables;
            List<LocalVariable> list2;
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            VirtualMachineProxyImpl virtualMachineProxyImpl = frame.getVirtualMachine();
            Intrinsics.checkNotNullExpressionValue((Object)virtualMachineProxyImpl, (String)"frame.virtualMachine");
            if (NoStrataPositionManagerHelperKt.isDexDebug(virtualMachineProxyImpl.getVirtualMachine())) {
                Method method = frame.location().method();
                Intrinsics.checkNotNullExpressionValue((Object)method, (String)"frame.location().method()");
                list2 = SafeUtilKt.safeVariables(method);
            } else {
                list2 = allVariables = null;
            }
            if (allVariables == null) {
                List list3 = frame.visibleVariables();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"frame.visibleVariables()");
                Iterable $this$sortedBy$iv = list3;
                boolean $i$f$sortedBy = false;
                boolean bl = false;
                List sortedVariables = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        LocalVariableProxyImpl it = (LocalVariableProxyImpl)a;
                        boolean bl2 = false;
                        LocalVariableProxyImpl localVariableProxyImpl = it;
                        Intrinsics.checkNotNullExpressionValue((Object)localVariableProxyImpl, (String)"it");
                        it = (LocalVariableProxyImpl)b;
                        Comparable comparable = localVariableProxyImpl.getVariable();
                        bl2 = false;
                        LocalVariableProxyImpl localVariableProxyImpl2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)localVariableProxyImpl2, (String)"it");
                        LocalVariable localVariable = localVariableProxyImpl2.getVariable();
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)localVariable);
                    }
                });
                return this.fromSortedVisibleVariables(sortedVariables);
            }
            boolean $this$sortedBy$iv = false;
            Map startOffsets = new LinkedHashMap();
            boolean $i$f$sortedBy = false;
            Map replacements = new LinkedHashMap();
            for (LocalVariable variable2 : allVariables) {
                Object object = this.getFieldValue(variable2, "scopeStart");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.sun.jdi.Location");
                }
                Location startOffset = (Location)object;
                Collection collection = (List)startOffsets.computeIfAbsent(startOffset.codeIndex(), fromStackFrame.1.INSTANCE);
                boolean bl = false;
                collection.add(variable2);
            }
            for (LocalVariable variable3 : allVariables) {
                List otherVariables;
                Object object = this.getFieldValue(variable3, "scopeEnd");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.sun.jdi.Location");
                }
                Location endOffset2 = (Location)object;
                if ((List)startOffsets.get(endOffset2.codeIndex() + 1L) == null) {
                    continue;
                }
                for (LocalVariable other : otherVariables) {
                    if (!Intrinsics.areEqual((Object)variable3.name(), (Object)other.name()) || !Intrinsics.areEqual((Object)variable3.type(), (Object)other.type())) continue;
                    replacements.put(other, variable3);
                }
            }
            List list4 = frame.visibleVariables();
            Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"frame.visibleVariables()");
            Iterable $this$sortedBy$iv2 = list4;
            boolean $i$f$sortedBy2 = false;
            boolean bl = false;
            List sortedVariables = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv2, (Comparator)new Comparator<T>(replacements){
                final /* synthetic */ Map $replacements$inlined;
                {
                    this.$replacements$inlined = map2;
                }

                public final int compare(T a, T b) {
                    boolean bl = false;
                    LocalVariableProxyImpl proxy = (LocalVariableProxyImpl)a;
                    boolean bl2 = false;
                    LocalVariableProxyImpl localVariableProxyImpl = proxy;
                    Intrinsics.checkNotNullExpressionValue((Object)localVariableProxyImpl, (String)"proxy");
                    LocalVariable variable2 = localVariableProxyImpl.getVariable();
                    while (true) {
                        if ((LocalVariable)this.$replacements$inlined.get(variable2) != null) continue;
                        break;
                    }
                    proxy = (LocalVariableProxyImpl)b;
                    Comparable comparable = variable2;
                    bl2 = false;
                    LocalVariableProxyImpl localVariableProxyImpl2 = proxy;
                    Intrinsics.checkNotNullExpressionValue((Object)localVariableProxyImpl2, (String)"proxy");
                    variable2 = localVariableProxyImpl2.getVariable();
                    while (true) {
                        if ((LocalVariable)this.$replacements$inlined.get(variable2) != null) continue;
                        break;
                    }
                    LocalVariable localVariable = variable2;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)localVariable);
                }
            });
            return this.fromSortedVisibleVariables(sortedVariables);
        }

        private final Object getFieldValue(LocalVariable $this$getFieldValue, String name2) {
            Class<?> clazz = Class.forName("com.jetbrains.jdi.LocalVariableImpl");
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"Class.forName(\"com.jetbr\u2026s.jdi.LocalVariableImpl\")");
            Field[] fieldArray = clazz.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"Class.forName(\"com.jetbr\u2026          .declaredFields");
            Field[] $this$single$iv = fieldArray;
            boolean $i$f$single = false;
            Field single$iv = null;
            boolean found$iv = false;
            Field[] fieldArray2 = $this$single$iv;
            int n = fieldArray2.length;
            for (int j = 0; j < n; ++j) {
                Field element$iv;
                Field it = element$iv = fieldArray2[j];
                boolean bl = false;
                Field field = it;
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"it");
                if (!Intrinsics.areEqual((Object)field.getName(), (Object)name2)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Field field = single$iv;
            boolean bl = false;
            boolean bl2 = false;
            Field it = field;
            boolean bl3 = false;
            Field field2 = it;
            Intrinsics.checkNotNullExpressionValue(field2, (String)"it");
            field2.setAccessible(true);
            return field.get($this$getFieldValue);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

