/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointPropertiesPanel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import javax.swing.Icon;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFunctionBreakpoint;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;

public class KotlinFunctionBreakpointType
extends JavaLineBreakpointTypeBase<JavaMethodBreakpointProperties>
implements KotlinBreakpointType {
    public KotlinFunctionBreakpointType() {
        super("kotlin-function", KotlinDebuggerCoreBundle.message("function.breakpoint.tab.title", new Object[0]));
    }

    public int getPriority() {
        return 120;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon2 = AllIcons.Debugger.Db_method_breakpoint;
        if (icon2 == null) {
            KotlinFunctionBreakpointType.$$$reportNull$$$0(0);
        }
        return icon2;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon2 = AllIcons.Debugger.Db_disabled_method_breakpoint;
        if (icon2 == null) {
            KotlinFunctionBreakpointType.$$$reportNull$$$0(1);
        }
        return icon2;
    }

    @NotNull
    public Icon getSuspendNoneIcon() {
        Icon icon2 = AllIcons.Debugger.Db_no_suspend_method_breakpoint;
        if (icon2 == null) {
            KotlinFunctionBreakpointType.$$$reportNull$$$0(2);
        }
        return icon2;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon2 = AllIcons.Debugger.Db_muted_method_breakpoint;
        if (icon2 == null) {
            KotlinFunctionBreakpointType.$$$reportNull$$$0(3);
        }
        return icon2;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon2 = AllIcons.Debugger.Db_muted_disabled_method_breakpoint;
        if (icon2 == null) {
            KotlinFunctionBreakpointType.$$$reportNull$$$0(4);
        }
        return icon2;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon2 = AllIcons.Debugger.Db_dep_method_breakpoint;
        if (icon2 == null) {
            KotlinFunctionBreakpointType.$$$reportNull$$$0(5);
        }
        return icon2;
    }

    public String getShortText(XLineBreakpoint<JavaMethodBreakpointProperties> breakpoint2) {
        boolean classNameExists;
        StringBuilder buffer = new StringBuilder();
        String className2 = ((JavaMethodBreakpointProperties)breakpoint2.getProperties()).myClassPattern;
        boolean bl = classNameExists = className2 != null && className2.length() > 0;
        if (classNameExists) {
            buffer.append(className2);
        }
        if (((JavaMethodBreakpointProperties)breakpoint2.getProperties()).myMethodName != null) {
            if (classNameExists) {
                buffer.append(".");
            }
            buffer.append(((JavaMethodBreakpointProperties)breakpoint2.getProperties()).myMethodName);
        }
        String s = buffer.toString();
        return s;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel createCustomPropertiesPanel(@NotNull Project project2) {
        if (project2 == null) {
            KotlinFunctionBreakpointType.$$$reportNull$$$0(6);
        }
        return new MethodBreakpointPropertiesPanel();
    }

    @Nullable
    public JavaMethodBreakpointProperties createProperties() {
        return new JavaMethodBreakpointProperties();
    }

    @Nullable
    public JavaMethodBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file2, int line) {
        if (file2 == null) {
            KotlinFunctionBreakpointType.$$$reportNull$$$0(7);
        }
        JavaMethodBreakpointProperties properties2 = new JavaMethodBreakpointProperties();
        if (Registry.is((String)"debugger.emulate.method.breakpoints")) {
            properties2.EMULATED = true;
        }
        if (Registry.is((String)"debugger.method.breakpoints.entry.default")) {
            properties2.WATCH_EXIT = false;
        }
        return properties2;
    }

    @NotNull
    public Breakpoint<JavaMethodBreakpointProperties> createJavaBreakpoint(Project project2, XBreakpoint breakpoint2) {
        return new KotlinFunctionBreakpoint(project2, breakpoint2);
    }

    public boolean canBeHitInOtherPlaces() {
        return true;
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project2) {
        if (file2 == null) {
            KotlinFunctionBreakpointType.$$$reportNull$$$0(8);
        }
        if (project2 == null) {
            KotlinFunctionBreakpointType.$$$reportNull$$$0(9);
        }
        return BreakpointTypeUtilsKt.isBreakpointApplicable(file2, line, project2, (Function1<? super PsiElement, ApplicabilityResult>)((Function1)element3 -> {
            if (element3 instanceof KtConstructor) {
                return ApplicabilityResult.DEFINITELY_YES;
            }
            if (element3 instanceof KtClass) {
                KtClass clazz = (KtClass)element3;
                return ApplicabilityResult.maybe(!(clazz instanceof KtEnumEntry) && !clazz.isAnnotation() && !clazz.isInterface() && clazz.hasPrimaryConstructor());
            }
            if (element3 instanceof KtFunction) {
                KtFunction function2 = (KtFunction)element3;
                return ApplicabilityResult.maybe(function2.hasBody() && !KtPsiUtil.isLocal((KtDeclaration)function2) && !BreakpointTypeUtilsKt.isInlineOnly((KtCallableDeclaration)function2));
            }
            if (element3 instanceof KtPropertyAccessor) {
                KtPropertyAccessor accessor = (KtPropertyAccessor)element3;
                KtProperty property2 = accessor.getProperty();
                return ApplicabilityResult.maybe(accessor.hasBody() && !KtPsiUtil.isLocal((KtDeclaration)property2));
            }
            return ApplicabilityResult.UNKNOWN;
        }));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFunctionBreakpointType";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuspendNoneIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedEnabledIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMutedDisabledIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveDependentIcon";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinFunctionBreakpointType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCustomPropertiesPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createBreakpointProperties";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

