/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.execution.JavaTestConfigurationWithDiscoverySupport;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PathsList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutineAgentConnector;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutineDebuggerMode;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0002J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J(\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c*\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u0004*\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector;", "", "()V", "jarSeparator", "", "kotlinStdlibName", "kotlinxCoroutinesCoreJarRegex", "Lkotlin/text/Regex;", "kotlinxCoroutinesCoreName", "kotlinxCoroutinesPackageName", "versionToCompareTo", "Lorg/apache/maven/artifact/versioning/DefaultArtifactVersion;", "attachCoroutineAgent", "", "project", "Lcom/intellij/openapi/project/Project;", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "determineCoreVersionMode", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;", "version", "findKotlinxCoroutinesCoreJar", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector$KotlinxCoroutinesSearchResult;", "initializeCoroutineAgent", "jarPath", "getJarVirtualFiles", "", "packageName", "getParentJarPath", "KotlinxCoroutinesSearchResult", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineAgentConnector {
    private static final String kotlinxCoroutinesCoreName = "kotlinx-coroutines-core";
    private static final String kotlinStdlibName = "kotlin-stdlib";
    private static final String kotlinxCoroutinesPackageName = "kotlinx.coroutines";
    private static final String jarSeparator = "!/";
    private static final DefaultArtifactVersion versionToCompareTo;
    private static final Regex kotlinxCoroutinesCoreJarRegex;
    @NotNull
    public static final CoroutineAgentConnector INSTANCE;

    public final boolean attachCoroutineAgent(@NotNull Project project2, @NotNull JavaParameters params2, @Nullable RunConfigurationBase<?> configuration2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)params2, (String)"params");
        KotlinxCoroutinesSearchResult searchResult = this.findKotlinxCoroutinesCoreJar(project2, configuration2);
        if (searchResult.getDebuggerMode() == CoroutineDebuggerMode.VERSION_1_3_8_AND_UP && searchResult.getJarPath() != null) {
            return this.initializeCoroutineAgent(params2, searchResult.getJarPath());
        }
        return false;
    }

    private final KotlinxCoroutinesSearchResult findKotlinxCoroutinesCoreJar(Project project2, RunConfigurationBase<?> configuration2) {
        MatchResult matchResult2 = (MatchResult)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.getJarVirtualFiles(project2, configuration2, kotlinxCoroutinesPackageName)), (Function1)findKotlinxCoroutinesCoreJar.matchResult.1.INSTANCE));
        if (matchResult2 == null || matchResult2.getGroupValues().size() < 3) {
            return new KotlinxCoroutinesSearchResult(null, CoroutineDebuggerMode.DISABLED);
        }
        return new KotlinxCoroutinesSearchResult(matchResult2.getValue(), this.determineCoreVersionMode((String)matchResult2.getGroupValues().get(2)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getJarVirtualFiles(Project $this$getJarVirtualFiles, RunConfigurationBase<?> configuration2, String packageName) {
        void $this$mapNotNullTo$iv$iv;
        if (!(configuration2 instanceof ModuleBasedConfiguration)) {
            return CollectionsKt.emptyList();
        }
        RunConfigurationModule runConfigurationModule = ((ModuleBasedConfiguration)configuration2).getConfigurationModule();
        Intrinsics.checkNotNullExpressionValue((Object)runConfigurationModule, (String)"configuration.configurationModule");
        Module module2 = runConfigurationModule.getModule();
        if (module2 == null || (module2 = module2.getModuleRuntimeScope(configuration2 instanceof JavaTestConfigurationWithDiscoverySupport)) == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"configuration.configurat\u2026  ) ?: return emptyList()");
        Module scope2 = module2;
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)$this$getJarVirtualFiles).findPackage(packageName);
        if (psiPackage == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiPackage, (String)"JavaPsiFacade.getInstanc\u2026    ?: return emptyList()");
        PsiPackage kotlinxCoroutinesPackage = psiPackage;
        PsiDirectory[] psiDirectoryArray = kotlinxCoroutinesPackage.getDirectories((GlobalSearchScope)scope2);
        Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"kotlinxCoroutinesPackage.getDirectories(scope)");
        PsiDirectory[] $this$mapNotNull$iv = psiDirectoryArray;
        boolean $i$f$mapNotNull = false;
        PsiDirectory[] psiDirectoryArray2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var13_13 = $this$forEach$iv$iv$iv;
        int n = ((void)var13_13).length;
        for (int j = 0; j < n; ++j) {
            String string;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var13_13[j];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            void v4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
            VirtualFile virtualFile2 = v4.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"it.virtualFile");
            String string2 = virtualFile2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.virtualFile.path");
            if (INSTANCE.getParentJarPath(string2) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            String it$iv$iv = string;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String getParentJarPath(String $this$getParentJarPath) {
        int i2 = StringsKt.indexOf$default((CharSequence)$this$getParentJarPath, (String)jarSeparator, (int)0, (boolean)false, (int)6, null);
        if (i2 != -1) {
            String string = $this$getParentJarPath;
            int n = 0;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, i2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return string3;
        }
        return null;
    }

    private final CoroutineDebuggerMode determineCoreVersionMode(String version2) {
        return new DefaultArtifactVersion(version2).compareTo((ArtifactVersion)versionToCompareTo) > 0 ? CoroutineDebuggerMode.VERSION_1_3_8_AND_UP : CoroutineDebuggerMode.DISABLED;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean initializeCoroutineAgent(JavaParameters params2, String jarPath) {
        ParametersList parametersList = params2.getVMParametersList();
        if (parametersList == null) {
            return false;
        }
        ParametersList vmParametersList = parametersList;
        vmParametersList.add("-javaagent:" + jarPath);
        if (params2.isClasspathFile()) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            PathsList pathsList = params2.getClassPath();
            Intrinsics.checkNotNullExpressionValue((Object)pathsList, (String)"params.classPath");
            List list2 = pathsList.getRootDirs();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"params.classPath.rootDirs");
            Iterable $this$filter$iv = list2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"it");
                String string = virtualFile2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)kotlinStdlibName, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                VirtualFileSystem fs;
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                VirtualFile virtualFile3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"it");
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3.getFileSystem(), (String)"it.fileSystem");
                if (fs instanceof ArchiveFileSystem) {
                    VirtualFile virtualFile4 = ((ArchiveFileSystem)fs).getLocalByEntry(it);
                    string = virtualFile4 != null ? virtualFile4.getPath() : null;
                } else {
                    string = it.getPath();
                }
                String path2 = string;
                it.putUserData(JdkUtil.AGENT_RUNTIME_CLASSPATH, (Object)path2);
            }
        }
        return true;
    }

    private CoroutineAgentConnector() {
    }

    static {
        CoroutineAgentConnector coroutineAgentConnector;
        INSTANCE = coroutineAgentConnector = new CoroutineAgentConnector();
        versionToCompareTo = new DefaultArtifactVersion("1.3.7-255");
        kotlinxCoroutinesCoreJarRegex = new Regex(".+\\Wkotlinx-coroutines-core(-jvm)?-(\\d[\\w.\\-]+)?\\.jar");
    }

    public static final /* synthetic */ Regex access$getKotlinxCoroutinesCoreJarRegex$p(CoroutineAgentConnector $this) {
        CoroutineAgentConnector coroutineAgentConnector = $this;
        return kotlinxCoroutinesCoreJarRegex;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAgentConnector$KotlinxCoroutinesSearchResult;", "", "jarPath", "", "debuggerMode", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;)V", "getDebuggerMode", "()Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineDebuggerMode;", "getJarPath", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin.jvm-debugger.coroutines"})
    private static final class KotlinxCoroutinesSearchResult {
        @Nullable
        private final String jarPath;
        @NotNull
        private final CoroutineDebuggerMode debuggerMode;

        @Nullable
        public final String getJarPath() {
            return this.jarPath;
        }

        @NotNull
        public final CoroutineDebuggerMode getDebuggerMode() {
            return this.debuggerMode;
        }

        public KotlinxCoroutinesSearchResult(@Nullable String jarPath, @NotNull CoroutineDebuggerMode debuggerMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)debuggerMode), (String)"debuggerMode");
            this.jarPath = jarPath;
            this.debuggerMode = debuggerMode;
        }

        @Nullable
        public final String component1() {
            return this.jarPath;
        }

        @NotNull
        public final CoroutineDebuggerMode component2() {
            return this.debuggerMode;
        }

        @NotNull
        public final KotlinxCoroutinesSearchResult copy(@Nullable String jarPath, @NotNull CoroutineDebuggerMode debuggerMode) {
            Intrinsics.checkNotNullParameter((Object)((Object)debuggerMode), (String)"debuggerMode");
            return new KotlinxCoroutinesSearchResult(jarPath, debuggerMode);
        }

        public static /* synthetic */ KotlinxCoroutinesSearchResult copy$default(KotlinxCoroutinesSearchResult kotlinxCoroutinesSearchResult, String string, CoroutineDebuggerMode coroutineDebuggerMode, int n, Object object) {
            if ((n & 1) != 0) {
                string = kotlinxCoroutinesSearchResult.jarPath;
            }
            if ((n & 2) != 0) {
                coroutineDebuggerMode = kotlinxCoroutinesSearchResult.debuggerMode;
            }
            return kotlinxCoroutinesSearchResult.copy(string, coroutineDebuggerMode);
        }

        @NotNull
        public String toString() {
            return "KotlinxCoroutinesSearchResult(jarPath=" + this.jarPath + ", debuggerMode=" + (Object)((Object)this.debuggerMode) + ")";
        }

        public int hashCode() {
            String string = this.jarPath;
            CoroutineDebuggerMode coroutineDebuggerMode = this.debuggerMode;
            return (string != null ? string.hashCode() : 0) * 31 + (coroutineDebuggerMode != null ? ((Object)((Object)coroutineDebuggerMode)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof KotlinxCoroutinesSearchResult)) break block3;
                    KotlinxCoroutinesSearchResult kotlinxCoroutinesSearchResult = (KotlinxCoroutinesSearchResult)object;
                    if (!Intrinsics.areEqual((Object)this.jarPath, (Object)kotlinxCoroutinesSearchResult.jarPath) || !Intrinsics.areEqual((Object)((Object)this.debuggerMode), (Object)((Object)kotlinxCoroutinesSearchResult.debuggerMode))) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

