/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.extensions.gradle;

import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.extensions.gradle.BuildScriptUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a+\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\t\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\n\u001a'\u0010\u000b\u001a\u0004\u0018\u00010\u0006*\u00020\f2\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\t\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\r\u001a\u0011\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0010*\u00020\f\u001a'\u0010\u0011\u001a\u0004\u0018\u00010\u0006*\u00020\f2\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\t\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\r\u001a\u0011\u0010\u0012\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0010*\u00020\f\u001a\u001b\u0010\u0013\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0010*\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0011\u0010\u0016\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0010*\u00020\u0015\u001a\u0011\u0010\u0017\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u0010*\u00020\f\"\u0010\u0010\u0000\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0003\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0004\u001a\u00020\u00018\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"DEFAULT_SCRIPT_NAME", "", "KOTLIN_BUILD_SCRIPT_NAME", "KOTLIN_SETTINGS_SCRIPT_NAME", "SETTINGS_FILE_NAME", "findBuildGradleFile", "Ljava/nio/file/Path;", "path", "fileNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/nio/file/Path;", "getBuildScriptFile", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;[Ljava/lang/String;)Ljava/nio/file/Path;", "getBuildScriptPsiFile", "Lcom/intellij/psi/PsiFile;", "Lorg/jetbrains/annotations/Nullable;", "getBuildScriptSettingsFile", "getBuildScriptSettingsPsiFile", "getPsiFile", "project", "Lcom/intellij/openapi/project/Project;", "getTopLevelBuildScriptPsiFile", "getTopLevelBuildScriptSettingsPsiFile", "kotlin.idea"})
public final class BuildScriptUtilsKt {
    @NonNls
    private static final String DEFAULT_SCRIPT_NAME = "build.gradle";
    @NonNls
    private static final String SETTINGS_FILE_NAME = "settings.gradle";
    @NonNls
    private static final String KOTLIN_BUILD_SCRIPT_NAME = "build.gradle.kts";
    @NonNls
    private static final String KOTLIN_SETTINGS_SCRIPT_NAME = "settings.gradle.kts";

    @Nullable
    public static final PsiFile getBuildScriptPsiFile(@NotNull Module $this$getBuildScriptPsiFile) {
        PsiFile psiFile2;
        Intrinsics.checkNotNullParameter((Object)$this$getBuildScriptPsiFile, (String)"$this$getBuildScriptPsiFile");
        Path path2 = BuildScriptUtilsKt.getBuildScriptFile($this$getBuildScriptPsiFile, DEFAULT_SCRIPT_NAME, KOTLIN_BUILD_SCRIPT_NAME);
        if (path2 != null) {
            Project project2 = $this$getBuildScriptPsiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            psiFile2 = BuildScriptUtilsKt.getPsiFile(path2, project2);
        } else {
            psiFile2 = null;
        }
        return psiFile2;
    }

    @Nullable
    public static final PsiFile getBuildScriptSettingsPsiFile(@NotNull Module $this$getBuildScriptSettingsPsiFile) {
        PsiFile psiFile2;
        Intrinsics.checkNotNullParameter((Object)$this$getBuildScriptSettingsPsiFile, (String)"$this$getBuildScriptSettingsPsiFile");
        Path path2 = BuildScriptUtilsKt.getBuildScriptSettingsFile($this$getBuildScriptSettingsPsiFile, SETTINGS_FILE_NAME, KOTLIN_SETTINGS_SCRIPT_NAME);
        if (path2 != null) {
            Project project2 = $this$getBuildScriptSettingsPsiFile.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
            psiFile2 = BuildScriptUtilsKt.getPsiFile(path2, project2);
        } else {
            psiFile2 = null;
        }
        return psiFile2;
    }

    @Nullable
    public static final PsiFile getTopLevelBuildScriptPsiFile(@NotNull Project $this$getTopLevelBuildScriptPsiFile) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getTopLevelBuildScriptPsiFile, (String)"$this$getTopLevelBuildScriptPsiFile");
        String string = $this$getTopLevelBuildScriptPsiFile.getBasePath();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            String string3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
            Path path2 = BuildScriptUtilsKt.findBuildGradleFile(string3, DEFAULT_SCRIPT_NAME, KOTLIN_BUILD_SCRIPT_NAME);
            object = path2 != null ? BuildScriptUtilsKt.getPsiFile(path2, $this$getTopLevelBuildScriptPsiFile) : null;
        } else {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final PsiFile getTopLevelBuildScriptSettingsPsiFile(@NotNull Module $this$getTopLevelBuildScriptSettingsPsiFile) {
        PsiFile psiFile2;
        Intrinsics.checkNotNullParameter((Object)$this$getTopLevelBuildScriptSettingsPsiFile, (String)"$this$getTopLevelBuildScriptSettingsPsiFile");
        String string = ExternalSystemApiUtil.getExternalRootProjectPath((Module)$this$getTopLevelBuildScriptSettingsPsiFile);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String externalProjectPath = string2;
            boolean bl3 = false;
            String string3 = externalProjectPath;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"externalProjectPath");
            Path path2 = BuildScriptUtilsKt.findBuildGradleFile(string3, SETTINGS_FILE_NAME, KOTLIN_SETTINGS_SCRIPT_NAME);
            if (path2 != null) {
                Project project2 = $this$getTopLevelBuildScriptSettingsPsiFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                psiFile2 = BuildScriptUtilsKt.getPsiFile(path2, project2);
            } else {
                psiFile2 = null;
            }
        } else {
            psiFile2 = null;
        }
        return psiFile2;
    }

    private static final Path getBuildScriptFile(Module $this$getBuildScriptFile, String ... fileNames) {
        block3: {
            String string = $this$getBuildScriptFile.getModuleFilePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moduleFilePath");
            Object object = string;
            boolean bl = false;
            Path path2 = Paths.get((String)object, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(path)");
            Path path3 = path2.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"Path(moduleFilePath).parent");
            object = path3;
            bl = false;
            String moduleDir = object.toString();
            Path path4 = BuildScriptUtilsKt.findBuildGradleFile(moduleDir, Arrays.copyOf(fileNames, fileNames.length));
            if (path4 != null) {
                object = path4;
                bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                return it;
            }
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)$this$getBuildScriptFile);
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(this)");
            VirtualFile[] virtualFileArray = moduleRootManager.getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"ModuleRootManager.getInstance(this).contentRoots");
            VirtualFile[] $this$forEach$iv = virtualFileArray;
            boolean $i$f$forEach = false;
            VirtualFile[] virtualFileArray2 = $this$forEach$iv;
            int it = virtualFileArray2.length;
            for (int bl3 = 0; bl3 < it; ++bl3) {
                VirtualFile element$iv;
                VirtualFile root = element$iv = virtualFileArray2[bl3];
                boolean bl4 = false;
                VirtualFile virtualFile2 = root;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"root");
                String string2 = virtualFile2.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"root.path");
                Path path5 = BuildScriptUtilsKt.findBuildGradleFile(string2, Arrays.copyOf(fileNames, fileNames.length));
                if (path5 == null) continue;
                Path path6 = path5;
                boolean bl5 = false;
                boolean bl6 = false;
                Path it2 = path6;
                boolean bl7 = false;
                return it2;
            }
            String string3 = ExternalSystemApiUtil.getExternalProjectPath((Module)$this$getBuildScriptFile);
            if (string3 == null) break block3;
            object = string3;
            bl = false;
            boolean bl8 = false;
            Object externalProjectPath = object;
            boolean bl9 = false;
            Object object2 = externalProjectPath;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"externalProjectPath");
            Path path7 = BuildScriptUtilsKt.findBuildGradleFile((String)object2, Arrays.copyOf(fileNames, fileNames.length));
            if (path7 != null) {
                Path path8 = path7;
                boolean bl10 = false;
                boolean bl11 = false;
                Path it3 = path8;
                boolean bl12 = false;
                return it3;
            }
        }
        return null;
    }

    private static final Path getBuildScriptSettingsFile(Module $this$getBuildScriptSettingsFile, String ... fileNames) {
        String string = ExternalSystemApiUtil.getExternalProjectPath((Module)$this$getBuildScriptSettingsFile);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String externalProjectPath = string2;
            boolean bl3 = false;
            return (Path)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.generateSequence((Object)externalProjectPath, (Function1)getBuildScriptSettingsFile.1.1.INSTANCE), (Function1)((Function1)new Function1<String, Path>(fileNames){
                final /* synthetic */ String[] $fileNames$inlined;
                {
                    this.$fileNames$inlined = stringArray;
                    super(1);
                }

                @Nullable
                public final Path invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return BuildScriptUtilsKt.access$findBuildGradleFile(it, Arrays.copyOf(this.$fileNames$inlined, this.$fileNames$inlined.length));
                }
            })));
        }
        return null;
    }

    private static final Path findBuildGradleFile(String path2, String ... fileNames) {
        Object v0;
        block1: {
            Sequence $this$firstOrNull$iv = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])fileNames), (Function1)((Function1)new Function1<String, Path>(path2){
                final /* synthetic */ String $path;

                @NotNull
                public final Path invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string = this.$path + '/' + it;
                    boolean bl = false;
                    Path path2 = Paths.get(string, new String[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(path)");
                    return path2;
                }
                {
                    this.$path = string;
                    super(1);
                }
            }));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path p1 = (Path)element$iv;
                boolean bl = false;
                if (!PathKt.exists((Path)p1)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final PsiFile getPsiFile(Path $this$getPsiFile, Project project2) {
        PsiFile psiFile2;
        VirtualFile virtualFile2 = VfsUtil.findFile((Path)$this$getPsiFile, (boolean)true);
        if (virtualFile2 != null) {
            VirtualFile virtualFile3 = virtualFile2;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile3;
            boolean bl3 = false;
            psiFile2 = PsiManager.getInstance((Project)project2).findFile(it);
        } else {
            psiFile2 = null;
        }
        return psiFile2;
    }

    public static final /* synthetic */ Path access$findBuildGradleFile(String path2, String ... fileNames) {
        return BuildScriptUtilsKt.findBuildGradleFile(path2, fileNames);
    }
}

