/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.elements.KtLightFieldForSourceDeclarationSupport;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.FakeJvmFieldConstantInspection;
import org.jetbrains.kotlin.idea.inspections.MayBeConstantInspection;
import org.jetbrains.kotlin.idea.quickfix.AddConstModifierFix;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J.\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\b0\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/FakeJvmFieldConstantInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkAssignmentChildren", "", "right", "Lcom/intellij/psi/PsiExpression;", "leftType", "Lcom/intellij/psi/PsiPrimitiveType;", "checkExpression", "valueExpression", "additionalTypeCheck", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiType;", "kotlin.idea"})
public final class FakeJvmFieldConstantInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new JavaElementVisitor(this, holder){
            final /* synthetic */ FakeJvmFieldConstantInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitAnnotationParameterList(@NotNull PsiAnnotationParameterList list2) {
                Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
                super.visitAnnotationParameterList(list2);
                PsiNameValuePair[] psiNameValuePairArray = list2.getAttributes();
                int n = psiNameValuePairArray.length;
                for (int j = 0; j < n; ++j) {
                    PsiExpression valueExpression;
                    PsiNameValuePair attribute;
                    PsiNameValuePair psiNameValuePair = attribute = psiNameValuePairArray[j];
                    Intrinsics.checkNotNullExpressionValue((Object)psiNameValuePair, (String)"attribute");
                    PsiAnnotationMemberValue psiAnnotationMemberValue = psiNameValuePair.getValue();
                    if (!(psiAnnotationMemberValue instanceof PsiExpression)) {
                        psiAnnotationMemberValue = null;
                    }
                    if ((PsiExpression)psiAnnotationMemberValue == null) {
                        continue;
                    }
                    FakeJvmFieldConstantInspection.checkExpression$default(this.this$0, valueExpression, this.$holder, null, 4, null);
                }
            }

            public void visitSwitchLabelStatement(@NotNull PsiSwitchLabelStatement statement) {
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                super.visitSwitchLabelStatement(statement);
                PsiCaseLabelElement[] psiCaseLabelElementArray = statement.getCaseLabelElementList();
                if (psiCaseLabelElementArray != null && (psiCaseLabelElementArray = psiCaseLabelElementArray.getElements()) != null) {
                    PsiCaseLabelElement[] $this$forEach$iv = psiCaseLabelElementArray;
                    boolean $i$f$forEach = false;
                    PsiCaseLabelElement[] psiCaseLabelElementArray2 = $this$forEach$iv;
                    int n = psiCaseLabelElementArray2.length;
                    for (int j = 0; j < n; ++j) {
                        PsiCaseLabelElement element$iv;
                        PsiCaseLabelElement labelElement = element$iv = psiCaseLabelElementArray2[j];
                        boolean bl = false;
                        PsiCaseLabelElement psiCaseLabelElement = labelElement;
                        if (!(psiCaseLabelElement instanceof PsiExpression)) {
                            psiCaseLabelElement = null;
                        }
                        if ((PsiExpression)psiCaseLabelElement != null) {
                            PsiExpression psiExpression;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            PsiExpression it = psiExpression;
                            boolean bl4 = false;
                            FakeJvmFieldConstantInspection.checkExpression$default(this.this$0, it, this.$holder, null, 4, null);
                        }
                    }
                }
            }

            public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                super.visitAssignmentExpression(expression2);
                if (Intrinsics.areEqual((Object)expression2.getOperationTokenType(), (Object)JavaTokenType.EQ) ^ true) {
                    return;
                }
                PsiExpression psiExpression = expression2.getLExpression();
                Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"expression.lExpression");
                PsiType psiType = psiExpression.getType();
                if (!(psiType instanceof PsiPrimitiveType)) {
                    psiType = null;
                }
                PsiPrimitiveType psiPrimitiveType = (PsiPrimitiveType)psiType;
                if (psiPrimitiveType == null) {
                    return;
                }
                PsiPrimitiveType leftType = psiPrimitiveType;
                PsiExpression psiExpression2 = expression2.getRExpression();
                if (psiExpression2 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiExpression2, (String)"expression.rExpression ?: return");
                FakeJvmFieldConstantInspection.access$checkAssignmentChildren(this.this$0, psiExpression2, leftType, this.$holder);
            }

            public void visitVariable(@NotNull PsiVariable variable2) {
                Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
                super.visitVariable(variable2);
                PsiType psiType = variable2.getType();
                if (!(psiType instanceof PsiPrimitiveType)) {
                    psiType = null;
                }
                PsiPrimitiveType psiPrimitiveType = (PsiPrimitiveType)psiType;
                if (psiPrimitiveType == null) {
                    return;
                }
                PsiPrimitiveType leftType = psiPrimitiveType;
                PsiExpression psiExpression = variable2.getInitializer();
                if (psiExpression == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"variable.initializer ?: return");
                PsiExpression initializer2 = psiExpression;
                FakeJvmFieldConstantInspection.access$checkAssignmentChildren(this.this$0, initializer2, leftType, this.$holder);
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void checkAssignmentChildren(PsiExpression right2, PsiPrimitiveType leftType, ProblemsHolder holder) {
        void action$iv;
        void $this$forEachDescendantOfType$iv;
        if (Intrinsics.areEqual((Object)leftType, (Object)PsiType.BOOLEAN) || Intrinsics.areEqual((Object)leftType, (Object)PsiType.CHAR) || Intrinsics.areEqual((Object)leftType, (Object)PsiType.VOID)) {
            return;
        }
        PsiElement psiElement2 = (PsiElement)right2;
        Function1 function1 = (Function1)new Function1<PsiExpression, Unit>(this, holder, leftType){
            final /* synthetic */ FakeJvmFieldConstantInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ PsiPrimitiveType $leftType;

            public final void invoke(@NotNull PsiExpression rightPart) {
                Intrinsics.checkNotNullParameter((Object)rightPart, (String)"rightPart");
                FakeJvmFieldConstantInspection.access$checkExpression(this.this$0, rightPart, this.$holder, (Function1)new Function1<PsiType, Boolean>(this){
                    final /* synthetic */ checkAssignmentChildren.2 this$0;

                    public final boolean invoke(@NotNull PsiType resolvedPropertyType) {
                        Intrinsics.checkNotNullParameter((Object)resolvedPropertyType, (String)"resolvedPropertyType");
                        return Intrinsics.areEqual((Object)this.this$0.$leftType, (Object)resolvedPropertyType) ^ true && !this.this$0.$leftType.isAssignableFrom(resolvedPropertyType);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = fakeJvmFieldConstantInspection;
                this.$holder = problemsHolder;
                this.$leftType = psiPrimitiveType;
                super(1);
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        $this$forEachDescendantOfType$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor((Function1)action$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element3) {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                PsiElement parentElement = element3;
                boolean bl = false;
                if (!(parentElement instanceof PsiCallExpression) && !(parentElement instanceof PsiTypeCastExpression)) {
                    super.visitElement(element3);
                }
                if (element3 instanceof PsiExpression) {
                    this.$action.invoke((Object)element3);
                }
            }
        });
    }

    private final void checkExpression(PsiExpression valueExpression, ProblemsHolder holder, Function1<? super PsiType, Boolean> additionalTypeCheck) {
        PsiExpression psiExpression = valueExpression;
        if (!(psiExpression instanceof PsiReference)) {
            psiExpression = null;
        }
        PsiReference psiReference = (PsiReference)psiExpression;
        Object object = psiReference != null ? psiReference.resolve() : null;
        if (!(object instanceof KtLightFieldForSourceDeclarationSupport)) {
            object = null;
        }
        KtLightFieldForSourceDeclarationSupport ktLightFieldForSourceDeclarationSupport = (KtLightFieldForSourceDeclarationSupport)object;
        if (ktLightFieldForSourceDeclarationSupport == null) {
            return;
        }
        KtLightFieldForSourceDeclarationSupport resolvedLightField = ktLightFieldForSourceDeclarationSupport;
        KtDeclaration ktDeclaration = resolvedLightField.getKotlinOrigin();
        if (!(ktDeclaration instanceof KtProperty)) {
            ktDeclaration = null;
        }
        KtProperty ktProperty = (KtProperty)ktDeclaration;
        if (ktProperty == null) {
            return;
        }
        KtProperty resolvedProperty = ktProperty;
        MayBeConstantInspection.Companion companion = MayBeConstantInspection.Companion;
        boolean bl = false;
        boolean bl2 = false;
        MayBeConstantInspection.Companion $this$with = companion;
        boolean bl3 = false;
        if (resolvedProperty.getAnnotationEntries().isEmpty()) {
            return;
        }
        MayBeConstantInspection.Status resolvedPropertyStatus = $this$with.getStatus(resolvedProperty);
        if (resolvedPropertyStatus == MayBeConstantInspection.Status.JVM_FIELD_MIGHT_BE_CONST || resolvedPropertyStatus == MayBeConstantInspection.Status.JVM_FIELD_MIGHT_BE_CONST_NO_INITIALIZER || resolvedPropertyStatus == MayBeConstantInspection.Status.JVM_FIELD_MIGHT_BE_CONST_ERRONEOUS) {
            PsiType psiType = resolvedLightField.getType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"resolvedLightField.type");
            PsiType resolvedPropertyType = psiType;
            if (!((Boolean)additionalTypeCheck.invoke((Object)resolvedPropertyType)).booleanValue()) {
                return;
            }
            boolean bl4 = false;
            List fixes2 = new ArrayList();
            if (resolvedPropertyStatus == MayBeConstantInspection.Status.JVM_FIELD_MIGHT_BE_CONST) {
                Collection collection = fixes2;
                IntentionWrapper intentionWrapper = new IntentionWrapper((IntentionAction)new AddConstModifierFix(resolvedProperty));
                boolean bl5 = false;
                collection.add(intentionWrapper);
            }
            Collection $this$toTypedArray$iv = fixes2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
            if (localQuickFixArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            holder.registerProblem((PsiElement)valueExpression, KotlinBundle.message("use.of.non.const.kotlin.property.as.java.constant.is.incorrect.will.be.forbidden.in.1.4", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        }
    }

    static /* synthetic */ void checkExpression$default(FakeJvmFieldConstantInspection fakeJvmFieldConstantInspection, PsiExpression psiExpression, ProblemsHolder problemsHolder, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = checkExpression.1.INSTANCE;
        }
        fakeJvmFieldConstantInspection.checkExpression(psiExpression, problemsHolder, (Function1<? super PsiType, Boolean>)function1);
    }

    public static final /* synthetic */ void access$checkAssignmentChildren(FakeJvmFieldConstantInspection $this, PsiExpression right2, PsiPrimitiveType leftType, ProblemsHolder holder) {
        $this.checkAssignmentChildren(right2, leftType, holder);
    }

    public static final /* synthetic */ void access$checkExpression(FakeJvmFieldConstantInspection $this, PsiExpression valueExpression, ProblemsHolder holder, Function1 additionalTypeCheck) {
        $this.checkExpression(valueExpression, holder, (Function1<? super PsiType, Boolean>)additionalTypeCheck);
    }
}

