/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.deprecation.Deprecation;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/OverridingDeprecatedMemberInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "kotlin.idea"})
public final class OverridingDeprecatedMemberInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new KtVisitorVoid(holder, isOnTheFly){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;

            public void visitNamedDeclaration(@NotNull KtNamedDeclaration declaration2) {
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                if (!declaration2.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                    return;
                }
                KtDeclaration ktDeclaration = (KtDeclaration)declaration2;
                PsiElement psiElement2 = declaration2.getNameIdentifier();
                if (psiElement2 == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"declaration.nameIdentifier ?: return");
                this.registerProblemIfNeeded(ktDeclaration, psiElement2);
            }

            public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
                Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
                if (!accessor.getProperty().hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                    return;
                }
                KtDeclaration ktDeclaration = (KtDeclaration)accessor;
                PsiElement psiElement2 = accessor.getNamePlaceholder();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"accessor.namePlaceholder");
                this.registerProblemIfNeeded(ktDeclaration, psiElement2);
            }

            private final void registerProblemIfNeeded(KtDeclaration declaration2, PsiElement targetForProblem) {
                ResolutionFacade resolutionFacade2 = ResolutionUtils.getResolutionFacade((KtElement)((KtElement)declaration2));
                DeclarationDescriptor declarationDescriptor = ExtendedResolutionApiKt.resolveToDescriptorIfAny$default((KtDeclaration)declaration2, (ResolutionFacade)resolutionFacade2, null, (int)2, null);
                if (!(declarationDescriptor instanceof CallableMemberDescriptor)) {
                    declarationDescriptor = null;
                }
                CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)declarationDescriptor;
                if (callableMemberDescriptor == null) {
                    return;
                }
                CallableMemberDescriptor accessorDescriptor = callableMemberDescriptor;
                ResolutionFacade $this$frontendService$iv = resolutionFacade2;
                boolean $i$f$frontendService = false;
                DeprecationResolver deprecationProvider = (DeprecationResolver)$this$frontendService$iv.getFrontendService(DeprecationResolver.class);
                Object object = (Deprecation)CollectionsKt.firstOrNull((List)deprecationProvider.getDeprecations((DeclarationDescriptor)accessorDescriptor));
                if (object == null || (object = DeprecationUtilKt.deprecatedByOverriddenMessage((Deprecation)object)) == null) {
                    return;
                }
                Object message2 = object;
                ProblemDescriptor problemDescriptor = this.$holder.getManager().createProblemDescriptor(targetForProblem, (String)message2, true, ProblemHighlightType.LIKE_DEPRECATED, this.$isOnTheFly, new LocalQuickFix[0]);
                Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"holder.manager.createPro\u2026nTheFly\n                )");
                ProblemDescriptor problem = problemDescriptor;
                this.$holder.registerProblem(problem);
            }
            {
                this.$holder = $captured_local_variable$0;
                this.$isOnTheFly = $captured_local_variable$1;
            }
        };
    }
}

