/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.IfThenUtilsKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertNullablePropertyToLateinitIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "kotlin.idea"})
public final class ConvertNullablePropertyToLateinitIntention
extends SelfTargetingIntention<KtProperty> {
    @Override
    public boolean isApplicableTo(@NotNull KtProperty element3, int caretOffset) {
        KtTypeReference typeReference2;
        block15: {
            block14: {
                Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
                if (element3.hasModifier(KtTokens.LATEINIT_KEYWORD) || element3.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                    return false;
                }
                if (!element3.isVar()) {
                    return false;
                }
                LanguageVersionSettings languageVersionSettings = PlatformKt.getLanguageVersionSettings((PsiElement)element3);
                if (!languageVersionSettings.supportsFeature(LanguageFeature.LateinitLocalVariables) && element3.isLocal()) {
                    return false;
                }
                if (!languageVersionSettings.supportsFeature(LanguageFeature.LateinitTopLevelProperties) && element3.isTopLevel()) {
                    return false;
                }
                KtPropertyAccessor ktPropertyAccessor = element3.getGetter();
                if ((ktPropertyAccessor != null ? Boolean.valueOf(ktPropertyAccessor.hasBody()) : null) != null) break block14;
                KtPropertyAccessor ktPropertyAccessor2 = element3.getSetter();
                if ((ktPropertyAccessor2 != null ? Boolean.valueOf(ktPropertyAccessor2.hasBody()) : null) == null) break block15;
            }
            return false;
        }
        if (!IfThenUtilsKt.isNullExpression(element3.getInitializer())) {
            return false;
        }
        KtTypeReference ktTypeReference = typeReference2 = element3.getTypeReference();
        if (!((ktTypeReference != null ? ktTypeReference.getTypeElement() : null) instanceof KtNullableType)) {
            return false;
        }
        BindingContext context2 = ResolutionUtils.analyze((KtElement)((KtElement)element3), (BodyResolveMode)BodyResolveMode.PARTIAL);
        KotlinType kotlinType = (KotlinType)context2.get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference2);
        if (kotlinType == null || (kotlinType = TypeUtilsKt.makeNotNullable((KotlinType)kotlinType)) == null) {
            return false;
        }
        KotlinType type2 = kotlinType;
        if (KotlinBuiltIns.isPrimitiveType((KotlinType)type2) || InlineClassesUtilsKt.isInlineClassType((KotlinType)type2) || TypeUtils.isNullableType((KotlinType)type2)) {
            return false;
        }
        Object object = context2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)element3);
        if (!(object instanceof VariableDescriptor)) {
            object = null;
        }
        VariableDescriptor variableDescriptor = (VariableDescriptor)object;
        if (variableDescriptor == null) {
            return false;
        }
        VariableDescriptor descriptor2 = variableDescriptor;
        if (descriptor2 instanceof PropertyDescriptor && Intrinsics.areEqual((Object)((Boolean)context2.get((ReadOnlySlice)BindingContext.BACKING_FIELD_REQUIRED, (Object)descriptor2)), (Object)false)) {
            return false;
        }
        return descriptor2.getExtensionReceiverParameter() == null;
    }

    @Override
    public void applyTo(@NotNull KtProperty element3, @Nullable Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtTypeReference ktTypeReference = element3.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference2 = ktTypeReference;
        KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze((KtElement)((KtElement)element3), (BodyResolveMode)BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference2);
        if (kotlinType == null || (kotlinType = TypeUtilsKt.makeNotNullable((KotlinType)kotlinType)) == null) {
            return;
        }
        KotlinType notNullableType = kotlinType;
        element3.addModifier(KtTokens.LATEINIT_KEYWORD);
        PsiModificationUtilsKt.setType$default((KtCallableDeclaration)element3, notNullableType, false, 2, null);
        element3.setInitializer((KtExpression)null);
    }

    public ConvertNullablePropertyToLateinitIntention() {
        super(KtProperty.class, KotlinBundle.lazyMessage("convert.to.lateinit.var", new Object[0]), null, 4, null);
    }
}

