/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingOffsetIndependentIntention;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\f\u0010\u0013\u001a\u00020\u000b*\u00020\u0011H\u0002J\u0014\u0010\u0014\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J$\u0010\u0015\u001a\u00020\u000e*\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertToConcatenatedStringIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingOffsetIndependentIntention;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "isTripleQuoted", "str", "", "needsParenthesis", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isFinalEntry", "isStringExpression", "quote", "toSeparateString", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "convertExplicitly", "kotlin.idea"})
public final class ConvertToConcatenatedStringIntention
extends SelfTargetingOffsetIndependentIntention<KtStringTemplateExpression>
implements LowPriorityAction {
    @Override
    public boolean isApplicableTo(@NotNull KtStringTemplateExpression element3) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            PsiElement psiElement2 = element3.getLastChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.lastChild");
            ASTNode aSTNode = psiElement2.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.lastChild.node");
            if (Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtTokens.CLOSING_QUOTE) ^ true) {
                return false;
            }
            KtStringTemplateEntry[] ktStringTemplateEntryArray = element3.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"element.entries");
            KtStringTemplateEntry[] $this$any$iv = ktStringTemplateEntryArray;
            boolean $i$f$any = false;
            KtStringTemplateEntry[] ktStringTemplateEntryArray2 = $this$any$iv;
            int n = ktStringTemplateEntryArray2.length;
            for (int j = 0; j < n; ++j) {
                KtStringTemplateEntry element$iv;
                KtStringTemplateEntry it = element$iv = ktStringTemplateEntryArray2[j];
                boolean bl2 = false;
                if (!(it instanceof KtStringTemplateEntryWithExpression)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtStringTemplateExpression element3, @Nullable Editor editor2) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        void $this$filterNotTo$iv$iv;
        Object[] entries;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        String string = element3.getText();
        Intrinsics.checkNotNull((Object)string);
        boolean tripleQuoted = this.isTripleQuoted(string);
        String quote = tripleQuoted ? "\"\"\"" : "\"";
        Object[] objectArray = element3.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"element.entries");
        Object $this$filterNot$iv = entries = objectArray;
        boolean $i$f$filterNot = false;
        Object[] objectArray2 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        void var12_11 = $this$filterNotTo$iv$iv;
        int n = ((void)var12_11).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var12_11[j];
            boolean bl2 = false;
            if (it instanceof KtStringTemplateEntryWithExpression && ((KtStringTemplateEntryWithExpression)it).getExpression() == null) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$mapIndexed = false;
        $this$filterNotTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index2;
            void entry;
            int n2 = index$iv$iv++;
            boolean bl = false;
            if (n2 < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            KtStringTemplateEntry bl2 = (KtStringTemplateEntry)item$iv$iv;
            int n3 = n2;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            void v2 = entry;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"entry");
            String string2 = this.toSeparateString((KtStringTemplateEntry)v2, quote, index2 == false, index2 == ArraysKt.getLastIndex((Object[])entries));
            collection.add(string2);
        }
        String text2 = StringsKt.replace$default((String)CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"+", null, null, (int)0, null, null, (int)62, null), (String)(quote + '+' + quote), (String)"", (boolean)false, (int)4, null);
        KtExpression replacement2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null).createExpression(text2);
        element3.replace((PsiElement)replacement2);
    }

    private final boolean isTripleQuoted(String str) {
        return StringsKt.startsWith$default((String)str, (String)"\"\"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)str, (String)"\"\"\"", (boolean)false, (int)2, null);
    }

    private final String toSeparateString(KtStringTemplateEntry $this$toSeparateString, String quote, boolean convertExplicitly, boolean isFinalEntry) {
        String string;
        String text2;
        if (!($this$toSeparateString instanceof KtStringTemplateEntryWithExpression)) {
            String string2 = $this$toSeparateString.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text");
            return this.quote(string2, quote);
        }
        KtExpression ktExpression = ((KtStringTemplateEntryWithExpression)$this$toSeparateString).getExpression();
        Intrinsics.checkNotNull((Object)ktExpression);
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"expression!!");
        KtExpression expression2 = ktExpression;
        String string3 = text2 = this.needsParenthesis(expression2, isFinalEntry) ? "(" + expression2.getText() + ")" : expression2.getText();
        if (convertExplicitly && !this.isStringExpression(expression2)) {
            string = text2 + ".toString()";
        } else {
            String string4 = text2;
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"text");
        }
        return string;
    }

    private final boolean needsParenthesis(KtExpression expression2, boolean isFinalEntry) {
        KtExpression ktExpression = expression2;
        return ktExpression instanceof KtBinaryExpression ? true : (ktExpression instanceof KtIfExpression ? !(((KtIfExpression)expression2).getElse() instanceof KtBlockExpression) && !isFinalEntry : false);
    }

    private final String quote(String $this$quote, String quote) {
        return quote + $this$quote + quote;
    }

    private final boolean isStringExpression(KtExpression $this$isStringExpression) {
        return KotlinBuiltIns.isString((KotlinType)ResolutionUtils.analyze$default((KtElement)((KtElement)$this$isStringExpression), null, (int)1, null).getType($this$isStringExpression));
    }

    public ConvertToConcatenatedStringIntention() {
        super(KtStringTemplateExpression.class, KotlinBundle.lazyMessage("convert.template.to.concatenated.string", new Object[0]), null, 4, null);
    }
}

