/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiElement;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Scanner;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.core.KotlinCompilerIde;
import org.jetbrains.kotlin.idea.internal.BytecodeGenerationResult;
import org.jetbrains.kotlin.idea.internal.DecompileFailedException;
import org.jetbrains.kotlin.idea.internal.KotlinJvmDecompilerFacade;
import org.jetbrains.kotlin.idea.internal.Location;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.InfinitePeriodicalTask;
import org.jetbrains.kotlin.idea.util.LongRunningReadTask;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0002\u001a\u001bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0011H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "myProject", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/wm/ToolWindow;)V", "decompile", "Ljavax/swing/JButton;", "enableAssertions", "Ljavax/swing/JCheckBox;", "enableInline", "enableOptimization", "ir", "jvmTargets", "Ljavax/swing/JComboBox;", "", "myEditor", "Lcom/intellij/openapi/editor/Editor;", "getMyEditor$annotations", "()V", "dispose", "", "setText", "resultText", "Companion", "UpdateBytecodeToolWindowTask", "kotlin.jvm"})
public final class KotlinBytecodeToolWindow
extends JPanel
implements Disposable {
    private final Editor myEditor;
    private final JCheckBox enableInline;
    private final JCheckBox enableOptimization;
    private final JCheckBox enableAssertions;
    private final JButton decompile;
    private final JComboBox<String> jvmTargets;
    private final JCheckBox ir;
    private final Project myProject;
    private final ToolWindow toolWindow;
    private static final Logger LOG;
    private static final int UPDATE_DELAY = 1000;
    private static final String DEFAULT_TEXT = "/*\nGenerated bytecode for Kotlin source file.\nNo Kotlin source file is opened.\n*/";
    @NotNull
    public static final Companion Companion;

    private static /* synthetic */ void getMyEditor$annotations() {
    }

    private final void setText(String resultText) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(this, resultText){
            final /* synthetic */ KotlinBytecodeToolWindow this$0;
            final /* synthetic */ String $resultText;

            public final void run() {
                KotlinBytecodeToolWindow.access$getMyEditor$p(this.this$0).getDocument().setText((CharSequence)StringUtil.convertLineSeparators((String)this.$resultText));
            }
            {
                this.this$0 = kotlinBytecodeToolWindow;
                this.$resultText = string;
            }
        });
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    /*
     * WARNING - void declaration
     */
    public KotlinBytecodeToolWindow(@NotNull Project myProject, @NotNull ToolWindow toolWindow) {
        void $this$toTypedArray$iv;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        super(new BorderLayout());
        this.myProject = myProject;
        this.toolWindow = toolWindow;
        Editor editor2 = EditorFactory.getInstance().createEditor(EditorFactory.getInstance().createDocument((CharSequence)""), this.myProject, (FileType)JavaFileType.INSTANCE, true);
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"EditorFactory.getInstanc\u2026.INSTANCE, true\n        )");
        this.myEditor = editor2;
        this.add(this.myEditor.getComponent());
        JPanel optionPanel = new JPanel(new FlowLayout());
        this.add((Component)optionPanel, "North");
        final KotlinJvmDecompilerFacade decompilerFacade = KotlinJvmDecompilerFacade.Companion.getInstance();
        this.decompile = new JButton(KotlinJvmBundle.message("button.text.decompile", new Object[0]));
        if (decompilerFacade != null) {
            optionPanel.add(this.decompile);
            this.decompile.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent it) {
                    Location location2;
                    FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)myProject);
                    Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(myProject)");
                    Location location3 = location2 = Location.fromEditor(fileEditorManager.getSelectedTextEditor(), myProject);
                    Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"location");
                    KtFile file2 = location3.getKFile();
                    if (file2 != null) {
                        try {
                            decompilerFacade.showDecompiledCode(file2);
                        }
                        catch (DecompileFailedException ex) {
                            LOG.info((Throwable)ex);
                            Project project2 = myProject;
                            Object[] objectArray = new Object[2];
                            String string = file2.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                            objectArray[0] = string;
                            objectArray[1] = ex;
                            Messages.showErrorDialog((Project)project2, (String)KotlinJvmBundle.message("failed.to.decompile.0.1", objectArray), (String)KotlinJvmBundle.message("kotlin.bytecode.decompiler", new Object[0]));
                        }
                    }
                }
            });
        }
        this.enableInline = new JCheckBox(KotlinJvmBundle.message("checkbox.text.inline", new Object[0]), true);
        this.enableOptimization = new JCheckBox(KotlinJvmBundle.message("checkbox.text.optimization", new Object[0]), true);
        this.enableAssertions = new JCheckBox(KotlinJvmBundle.message("checkbox.text.assertions", new Object[0]), true);
        JvmTarget[] jvmTargetArray = JvmTarget.values();
        KotlinBytecodeToolWindow kotlinBytecodeToolWindow = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var10_11 = $this$mapTo$iv$iv;
        int n = ((void)var10_11).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var14_15 = item$iv$iv = var10_11[j];
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getDescription();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray2 = objectArray;
        kotlinBytecodeToolWindow.jvmTargets = (JComboBox)new ComboBox(objectArray2);
        String description2 = JvmTarget.DEFAULT.getDescription();
        ((ComboBox)this.jvmTargets).setSelectedItem((Object)description2);
        this.ir = new JCheckBox(KotlinJvmBundle.message("checkbox.text.ir", new Object[0]), false);
        optionPanel.add(this.enableInline);
        optionPanel.add(this.enableOptimization);
        optionPanel.add(this.enableAssertions);
        optionPanel.add(this.ir);
        optionPanel.add(new JLabel(KotlinJvmBundle.message("bytecode.toolwindow.label.target", new Object[0])));
        optionPanel.add(this.jvmTargets);
        new InfinitePeriodicalTask(1000, Alarm.ThreadToUse.SWING_THREAD, this, (Computable<? extends LongRunningReadTask>)new Computable(){

            public final LongRunningReadTask<?, ?> compute() {
                return new UpdateBytecodeToolWindowTask();
            }
        }).start();
        this.setText(DEFAULT_TEXT);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(KotlinBytecodeToolWindow.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Kotli\u2026deToolWindow::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0014J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001a\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0014J\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0002H\u0014\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow$UpdateBytecodeToolWindowTask;", "Lorg/jetbrains/kotlin/idea/util/LongRunningReadTask;", "Lorg/jetbrains/kotlin/idea/internal/Location;", "Lorg/jetbrains/kotlin/idea/internal/BytecodeGenerationResult;", "(Lorg/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow;)V", "cloneRequestInfo", "location", "hideResultOnInvalidLocation", "", "onResultReady", "requestInfo", "result", "prepareRequestInfo", "processRequest", "kotlin.jvm"})
    private final class UpdateBytecodeToolWindowTask
    extends LongRunningReadTask<Location, BytecodeGenerationResult> {
        @Override
        @Nullable
        protected Location prepareRequestInfo() {
            if (!KotlinBytecodeToolWindow.this.toolWindow.isVisible()) {
                return null;
            }
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)KotlinBytecodeToolWindow.this.myProject);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(myProject)");
            Location location2 = Location.fromEditor(fileEditorManager.getSelectedTextEditor(), KotlinBytecodeToolWindow.this.myProject);
            if (location2.getEditor() == null) {
                return null;
            }
            Location location3 = location2;
            Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"location");
            KtFile file2 = location3.getKFile();
            return file2 == null || !ProjectRootsUtil.isInProjectSource$default((PsiElement)file2, false, 2, null) ? null : location2;
        }

        @Override
        @NotNull
        protected Location cloneRequestInfo(@NotNull Location location2) {
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            Location location3 = super.cloneRequestInfo(location2);
            Intrinsics.checkNotNullExpressionValue((Object)location3, (String)"super.cloneRequestInfo(location)");
            Location newLocation = location3;
            boolean bl = Intrinsics.areEqual((Object)location2, (Object)newLocation);
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "cloneRequestInfo should generate same location object";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            return newLocation;
        }

        @Override
        protected void hideResultOnInvalidLocation() {
            KotlinBytecodeToolWindow.this.setText(KotlinBytecodeToolWindow.DEFAULT_TEXT);
        }

        @Override
        @NotNull
        protected BytecodeGenerationResult processRequest(@NotNull Location location2) {
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            KtFile ktFile = location2.getKFile();
            Intrinsics.checkNotNull((Object)ktFile);
            Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"location.kFile!!");
            KtFile ktFile2 = ktFile;
            CompilerConfiguration configuration2 = new CompilerConfiguration();
            if (!KotlinBytecodeToolWindow.this.enableInline.isSelected()) {
                configuration2.put(CommonConfigurationKeys.DISABLE_INLINE, (Object)true);
            }
            if (!KotlinBytecodeToolWindow.this.enableAssertions.isSelected()) {
                configuration2.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, (Object)true);
                configuration2.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, (Object)true);
            }
            if (!KotlinBytecodeToolWindow.this.enableOptimization.isSelected()) {
                configuration2.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, (Object)true);
            }
            Object object = KotlinBytecodeToolWindow.this.jvmTargets.getSelectedItem();
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            JvmTarget jvmTarget2 = JvmTarget.Companion.fromString((String)object);
            Intrinsics.checkNotNull((Object)jvmTarget2);
            configuration2.put(JVMConfigurationKeys.JVM_TARGET, (Object)jvmTarget2);
            if (KotlinBytecodeToolWindow.this.ir.isSelected()) {
                configuration2.put(JVMConfigurationKeys.IR, (Object)true);
            }
            CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)configuration2, (LanguageVersionSettings)PlatformKt.getLanguageVersionSettings((PsiElement)ktFile2));
            return Companion.getBytecodeForFile(ktFile2, configuration2);
        }

        @Override
        protected void onResultReady(@NotNull Location requestInfo, @Nullable BytecodeGenerationResult result2) {
            block3: {
                BytecodeGenerationResult bytecodeGenerationResult;
                Editor editor2;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)requestInfo, (String)"requestInfo");
                    Editor editor3 = requestInfo.getEditor();
                    Intrinsics.checkNotNull((Object)editor3);
                    Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"requestInfo.getEditor()!!");
                    editor2 = editor3;
                    if (result2 == null) {
                        return;
                    }
                    bytecodeGenerationResult = result2;
                    if (!(bytecodeGenerationResult instanceof BytecodeGenerationResult.Error)) break block2;
                    KotlinBytecodeToolWindow.this.decompile.setEnabled(false);
                    KotlinBytecodeToolWindow.this.setText(((BytecodeGenerationResult.Error)result2).getText());
                    break block3;
                }
                if (!(bytecodeGenerationResult instanceof BytecodeGenerationResult.Bytecode)) break block3;
                KotlinBytecodeToolWindow.this.decompile.setEnabled(true);
                KotlinBytecodeToolWindow.this.setText(((BytecodeGenerationResult.Bytecode)result2).getText());
                int fileStartOffset = requestInfo.getStartOffset();
                int fileEndOffset = requestInfo.getEndOffset();
                Document document = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
                Document document2 = document;
                int startLine = document2.getLineNumber(fileStartOffset);
                int endLine = document2.getLineNumber(fileEndOffset);
                if (endLine > startLine && fileEndOffset > 0 && document2.getCharsSequence().charAt(fileEndOffset - 1) == '\n') {
                    --endLine;
                }
                Document document3 = KotlinBytecodeToolWindow.this.myEditor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"myEditor.document");
                Document byteCodeDocument = document3;
                String string = byteCodeDocument.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"byteCodeDocument.text");
                Pair linesRange = Companion.mapLines(string, startLine, endLine);
                int n = ((Number)linesRange.second).intValue() + 1;
                int n2 = byteCodeDocument.getLineCount();
                int n3 = 0;
                int endSelectionLineIndex = Math.min(n, n2);
                Object object = linesRange.first;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"linesRange.first");
                int startOffset = byteCodeDocument.getLineStartOffset(((Number)object).intValue());
                n3 = byteCodeDocument.getLineStartOffset(endSelectionLineIndex);
                int n4 = byteCodeDocument.getTextLength();
                boolean bl = false;
                int endOffset2 = Math.min(n3, n4);
                KotlinBytecodeToolWindow.this.myEditor.getCaretModel().moveToOffset(endOffset2);
                KotlinBytecodeToolWindow.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                KotlinBytecodeToolWindow.this.myEditor.getCaretModel().moveToOffset(startOffset);
                KotlinBytecodeToolWindow.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                KotlinBytecodeToolWindow.this.myEditor.getSelectionModel().setSelection(startOffset, endOffset2);
            }
        }

        public UpdateBytecodeToolWindowTask() {
            super(KotlinBytecodeToolWindow.this);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u000fJ,\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/internal/KotlinBytecodeToolWindow$Companion;", "", "()V", "DEFAULT_TEXT", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "UPDATE_DELAY", "", "compileSingleFile", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "initialConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "getBytecodeForFile", "Lorg/jetbrains/kotlin/idea/internal/BytecodeGenerationResult;", "configuration", "mapLines", "Lcom/intellij/openapi/util/Pair;", "text", "startLine", "endLine", "printStackTraceToString", "e", "", "kotlin.jvm"})
    public static final class Companion {
        @NotNull
        public final BytecodeGenerationResult getBytecodeForFile(@NotNull KtFile ktFile, @NotNull CompilerConfiguration configuration2) {
            Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
            Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
            GenerationState state2 = null;
            try {
                GenerationState generationState = this.compileSingleFile(ktFile, configuration2);
                if (generationState == null) {
                    Object[] objectArray = new Object[1];
                    String string = ktFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ktFile.name");
                    objectArray[0] = string;
                    return new BytecodeGenerationResult.Error(KotlinJvmBundle.message("cannot.compile.0.to.bytecode", objectArray));
                }
                state2 = generationState;
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Exception e) {
                return new BytecodeGenerationResult.Error(this.printStackTraceToString(e));
            }
            StringBuilder answer = new StringBuilder();
            Collection diagnostics2 = state2.getCollectedExtraJvmDiagnostics().all();
            if (!diagnostics2.isEmpty()) {
                answer.append("// Backend Errors: \n");
                answer.append("// ================\n");
                for (Diagnostic diagnostic : diagnostics2) {
                    answer.append("// Error at ").append(diagnostic.getPsiFile().getName()).append(org.jetbrains.kotlin.utils.StringsKt.join((Iterable)diagnostic.getTextRanges(), (String)",")).append(": ").append(DefaultErrorMessages.render((UnboundDiagnostic)((UnboundDiagnostic)diagnostic))).append("\n");
                }
                answer.append("// ================\n\n");
            }
            ClassFileFactory outputFiles = state2.getFactory();
            for (OutputFile outputFile : outputFiles.asList()) {
                answer.append("// ================");
                answer.append(outputFile.getRelativePath());
                answer.append(" =================\n");
                answer.append(outputFile.asText()).append("\n\n");
            }
            String string = answer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"answer.toString()");
            return new BytecodeGenerationResult.Bytecode(string);
        }

        @Nullable
        public final GenerationState compileSingleFile(@NotNull KtFile ktFile, @NotNull CompilerConfiguration initialConfiguration) {
            Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
            Intrinsics.checkNotNullParameter((Object)initialConfiguration, (String)"initialConfiguration");
            ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.TEST;
            Intrinsics.checkNotNullExpressionValue((Object)classBuilderFactory, (String)"ClassBuilderFactories.TEST");
            return new KotlinCompilerIde(ktFile, initialConfiguration, classBuilderFactory, null, false, 24, null).compile();
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Integer, Integer> mapLines(String text2, int startLine, int endLine) {
            void $this$mapTo$iv$iv;
            List list2;
            String string;
            boolean match$iv$iv;
            char it;
            int index$iv$iv;
            boolean startFound$iv$iv;
            int endIndex$iv$iv;
            int startIndex$iv$iv;
            boolean $i$f$trim;
            CharSequence $this$trim$iv$iv;
            String $this$trim$iv;
            String line;
            boolean bl;
            Collection collection;
            void $this$mapTo$iv$iv22;
            void $this$map$iv;
            List list3;
            Iterator iterator;
            boolean bl2;
            ListIterator iterator$iv;
            int startLine2 = startLine;
            int byteCodeLine = 0;
            int byteCodeStartLine = -1;
            int byteCodeEndLine = -1;
            ArrayList<Integer> lines = new ArrayList<Integer>();
            Iterable $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)text2, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it2 = (String)iterator$iv.previous();
                    bl2 = false;
                    iterator = it2;
                    boolean bl22 = false;
                    if (iterator.length() == 0) continue;
                    list3 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list3 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list3;
            boolean $i$f$map22 = false;
            iterator$iv = $this$map$iv;
            Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv22) {
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv22;
                bl = false;
                $this$trim$iv = line;
                boolean $i$f$trim2 = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl3 = false;
                    boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                collection.add(string);
            }
            for (String string2 : (List)destination$iv$iv22) {
                if (!StringsKt.startsWith$default((String)string2, (String)"LINENUMBER", (boolean)false, (int)2, null)) continue;
                String $i$f$map22 = string2;
                int $this$mapTo$iv$iv22 = "LINENUMBER".length();
                boolean destination$iv$iv22 = false;
                String string3 = $i$f$map22;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring($this$mapTo$iv$iv22);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                int ktLineNum = new Scanner(string4).nextInt() - 1;
                lines.add(ktLineNum);
            }
            CollectionsKt.sort((List)lines);
            for (Integer n : lines) {
                if (Intrinsics.compare((int)n, (int)startLine2) < 0) continue;
                Integer n2 = n;
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"line");
                startLine2 = n2;
                break;
            }
            $this$dropLastWhile$iv = StringsKt.split$default((CharSequence)text2, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it2 = (String)iterator$iv.previous();
                    bl2 = false;
                    iterator = it2;
                    boolean item$iv$iv = false;
                    if (iterator.length() == 0) continue;
                    list2 = CollectionsKt.take($this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list2;
            boolean $i$f$map = false;
            iterator$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                line = (String)item$iv$iv;
                collection = destination$iv$iv;
                bl = false;
                $this$trim$iv = line;
                boolean $i$f$trim2 = false;
                $this$trim$iv$iv = $this$trim$iv;
                $i$f$trim = false;
                startIndex$iv$iv = 0;
                endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl5 = false;
                    boolean bl6 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                collection.add(string);
            }
            for (String string5 : (List)destination$iv$iv) {
                block25: {
                    block26: {
                        if (StringsKt.startsWith$default((String)string5, (String)"LINENUMBER", (boolean)false, (int)2, null)) {
                            String object = string5;
                            int n = "LINENUMBER".length();
                            boolean bl7 = false;
                            String string6 = object;
                            if (string6 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string7 = string6.substring(n);
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                            int ktLineNum = new Scanner(string7).nextInt() - 1;
                            if (byteCodeStartLine < 0 && ktLineNum == startLine2) {
                                byteCodeStartLine = byteCodeLine;
                            }
                            if (byteCodeStartLine > 0 && ktLineNum > endLine) {
                                byteCodeEndLine = byteCodeLine - 1;
                                break;
                            }
                        }
                        if (byteCodeStartLine < 0) break block25;
                        if (StringsKt.startsWith$default((String)string5, (String)"MAXSTACK", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)string5, (String)"LOCALVARIABLE", (boolean)false, (int)2, null)) break block26;
                        CharSequence charSequence = string5;
                        boolean bl8 = false;
                        if (!(charSequence.length() == 0)) break block25;
                    }
                    byteCodeEndLine = byteCodeLine - 1;
                    break;
                }
                ++byteCodeLine;
            }
            return byteCodeStartLine == -1 || byteCodeEndLine == -1 ? new Pair((Object)0, (Object)0) : new Pair((Object)byteCodeStartLine, (Object)byteCodeEndLine);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String printStackTraceToString(Throwable e) {
            StringWriter out = new StringWriter(1024);
            Closeable closeable = new PrintWriter(out);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                PrintWriter printWriter = (PrintWriter)closeable;
                boolean bl3 = false;
                e.printStackTrace(printWriter);
                String string = out.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"out.toString()");
                String string2 = StringsKt.replace$default((String)string, (String)"\r", (String)"", (boolean)false, (int)4, null);
                return string2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

