/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.quickfix.MoveKotlinDeclarationsHandlerTestActions;
import org.jetbrains.kotlin.idea.refactoring.move.moveDeclarations.MoveKotlinDeclarationsHandler;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.jvm.KotlinJavaPsiFacade;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J#\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0094\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0002H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MoveToSealedMatchingPackageFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "element", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;)V", "moveHandler", "Lorg/jetbrains/kotlin/idea/refactoring/move/moveDeclarations/MoveKotlinDeclarationsHandler;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "", "resolveToDir", "Lcom/intellij/psi/PsiDirectory;", "Companion", "kotlin.idea"})
public final class MoveToSealedMatchingPackageFix
extends KotlinQuickFixAction<KtTypeReference> {
    private final MoveKotlinDeclarationsHandler moveHandler;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtTypeReference ktTypeReference = (KtTypeReference)this.getElement();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference2 = ktTypeReference;
        PsiElement $this$parentOfType$iv = (PsiElement)typeReference2;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtClass.class, (boolean)true);
        if (ktClass2 == null) {
            return;
        }
        KtClass classToMove = ktClass2;
        PsiDirectory psiDirectory = this.resolveToDir(typeReference2);
        if (psiDirectory == null) {
            return;
        }
        PsiDirectory defaultTargetDir = psiDirectory;
        DataContext dataContext = SimpleDataContext.getProjectContext((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"SimpleDataContext.getProjectContext(project)");
        DataContext parentContext = dataContext;
        DataKey dataKey = LangDataKeys.TARGET_PSI_ELEMENT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"LangDataKeys.TARGET_PSI_ELEMENT");
        DataContext dataContext2 = SimpleDataContext.getSimpleContext((String)dataKey.getName(), (Object)defaultTargetDir, (DataContext)parentContext);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"SimpleDataContext.getSim\u2026TargetDir, parentContext)");
        DataContext context2 = dataContext2;
        this.moveHandler.tryToMove((PsiElement)classToMove, project2, context2, null, editor2);
    }

    private final PsiDirectory resolveToDir(KtTypeReference $this$resolveToDir) {
        PsiDirectory psiDirectory;
        block11: {
            KtTypeElement ktTypeElement = $this$resolveToDir.getTypeElement();
            if (!(ktTypeElement instanceof KtUserType)) {
                ktTypeElement = null;
            }
            KtUserType ktUserType2 = (KtUserType)ktTypeElement;
            if (ktUserType2 == null) {
                return null;
            }
            KtUserType ktUserType3 = ktUserType2;
            KtSimpleNameExpression ktSimpleNameExpression = ktUserType3.getReferenceExpression();
            if (!(ktSimpleNameExpression instanceof KtNameReferenceExpression)) {
                ktSimpleNameExpression = null;
            }
            KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktSimpleNameExpression;
            if (ktNameReferenceExpression == null) {
                return null;
            }
            KtNameReferenceExpression ktNameReferenceExpression2 = ktNameReferenceExpression;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.singleOrNull((Iterable)ReferenceUtilKt.resolveMainReferenceToDescriptors((KtElement)ktNameReferenceExpression2));
            if (declarationDescriptor == null) {
                return null;
            }
            DeclarationDescriptor declDescriptor = declarationDescriptor;
            Object object = DescriptorUtilKt.containingPackage((DeclarationDescriptor)declDescriptor);
            if (object == null || (object = object.asString()) == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"declDescriptor.containin\u2026asString() ?: return null");
            Object packageName = object;
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)$this$resolveToDir.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
            ProjectFileIndex projectFileIndex2 = projectFileIndex;
            PsiElement psiElement2 = DescriptorToSourceUtils.getSourceFromDescriptor((DeclarationDescriptor)declDescriptor);
            if (!(psiElement2 instanceof KtClass)) {
                psiElement2 = null;
            }
            KtClass ktClass2 = (KtClass)psiElement2;
            if (ktClass2 == null) {
                return null;
            }
            KtClass ktClassInQuestion = ktClass2;
            PsiFile psiFile2 = ktClassInQuestion.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"ktClassInQuestion.containingFile");
            Module module2 = projectFileIndex2.getModuleForFile(psiFile2.getVirtualFile());
            if (module2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"projectFileIndex.getModu\u2026rtualFile) ?: return null");
            Module module3 = module2;
            PsiPackage psiPackage = KotlinJavaPsiFacade.getInstance((Project)$this$resolveToDir.getProject()).findPackage((String)packageName, GlobalSearchScope.moduleScope((Module)module3));
            if (psiPackage == null) {
                return null;
            }
            PsiPackage psiPackage2 = psiPackage;
            PsiDirectory[] psiDirectoryArray = psiPackage2.getDirectories();
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectoryArray, (String)"psiPackage.directories");
            PsiDirectory[] psiDirectoryArray2 = psiDirectoryArray;
            boolean bl = false;
            PsiDirectory[] psiDirectoryArray3 = psiDirectoryArray2;
            boolean bl2 = false;
            PsiDirectory[] psiDirectoryArray4 = psiDirectoryArray3;
            int n = psiDirectoryArray4.length;
            for (int j = 0; j < n; ++j) {
                PsiDirectory psiDirectory2;
                PsiDirectory it = psiDirectory2 = psiDirectoryArray4[j];
                boolean bl3 = false;
                PsiDirectory psiDirectory3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiDirectory3, (String)"it");
                if (!Intrinsics.areEqual((Object)ProjectStructureUtilKt.getModule((PsiElement)psiDirectory3), (Object)module3)) continue;
                psiDirectory = psiDirectory2;
                break block11;
            }
            psiDirectory = null;
        }
        return psiDirectory;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        Object object;
        KtTypeReference ktTypeReference = (KtTypeReference)this.getElement();
        if (ktTypeReference == null) {
            return "";
        }
        KtTypeReference typeReference2 = ktTypeReference;
        KtTypeElement ktTypeElement = typeReference2.getTypeElement();
        if (!(ktTypeElement instanceof KtUserType)) {
            ktTypeElement = null;
        }
        if ((object = (KtUserType)ktTypeElement) == null || (object = object.getReferenceExpression()) == null || (object = object.getReferencedName()) == null) {
            return "";
        }
        Object referencedName = object;
        PsiElement $this$parentOfType$iv = (PsiElement)typeReference2;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        KtClass ktClass2 = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, KtClass.class, (boolean)true);
        if (ktClass2 == null) {
            return "";
        }
        KtClass classToMove = ktClass2;
        Object[] objectArray = new Object[2];
        String string = classToMove.getNameAsSafeName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classToMove.nameAsSafeName.asString()");
        objectArray[0] = string;
        objectArray[1] = referencedName;
        return KotlinBundle.message("fix.move.to.sealed.text", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.move.to.sealed.family", new Object[0]);
    }

    public MoveToSealedMatchingPackageFix(@NotNull KtTypeReference element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        super((PsiElement)element3);
        boolean $i$f$isUnitTestMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        this.moveHandler = application.isUnitTestMode() ? new MoveKotlinDeclarationsHandler(new MoveKotlinDeclarationsHandlerTestActions()) : new MoveKotlinDeclarationsHandler(false);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/MoveToSealedMatchingPackageFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lorg/jetbrains/kotlin/idea/quickfix/MoveToSealedMatchingPackageFix;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
    public static final class Companion
    extends KotlinSingleIntentionActionFactory {
        @Override
        @Nullable
        protected MoveToSealedMatchingPackageFix createAction(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            PsiElement psiElement2 = diagnostic.getPsiElement();
            if (!(psiElement2 instanceof KtTypeReference)) {
                psiElement2 = null;
            }
            KtTypeReference ktTypeReference = (KtTypeReference)psiElement2;
            if (ktTypeReference == null) {
                return null;
            }
            KtTypeReference annotationEntry2 = ktTypeReference;
            return new MoveToSealedMatchingPackageFix(annotationEntry2);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

