/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.WrongPrimitiveLiteralFixKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u000fH\u0016J#\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0094\u0002J\"\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/WrongPrimitiveLiteralFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "(Lorg/jetbrains/kotlin/psi/KtConstantExpression;Lorg/jetbrains/kotlin/types/KotlinType;)V", "constValue", "", "expectedTypeIsDouble", "", "expectedTypeIsFloat", "expectedTypeIsUnsigned", "fixedExpression", "", "typeName", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "isAvailable", "kotlin.idea"})
public final class WrongPrimitiveLiteralFix
extends KotlinQuickFixAction<KtExpression> {
    private final FqNameUnsafe typeName;
    private final boolean expectedTypeIsFloat;
    private final boolean expectedTypeIsDouble;
    private final boolean expectedTypeIsUnsigned;
    private final Number constValue;
    private final String fixedExpression;

    @Override
    protected boolean isAvailable(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (this.constValue == null) {
            return false;
        }
        if (this.expectedTypeIsFloat || this.expectedTypeIsDouble || this.expectedTypeIsUnsigned) {
            return true;
        }
        if (this.constValue instanceof Float || this.constValue instanceof Double) {
            double value2 = this.constValue.doubleValue();
            boolean bl = false;
            if (value2 != Math.floor(value2)) {
                return false;
            }
            double d = Long.MIN_VALUE;
            double d2 = Long.MAX_VALUE;
            double d3 = value2;
            if (!(d3 >= d) || !(d3 <= d2)) {
                return false;
            }
        }
        LongRange longRange = (LongRange)WrongPrimitiveLiteralFixKt.access$getValueRanges$p().get(this.typeName);
        if (longRange == null) {
            return false;
        }
        return longRange.contains(this.constValue.longValue());
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("change.to.correct.primitive.type", new Object[0]);
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message("change.to.0", this.fixedExpression);
    }

    @Override
    protected void invoke(@NotNull Project project2, @Nullable Editor editor2, @NotNull KtFile file2) {
        block5: {
            PsiElement psiElement2;
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KtExpression ktExpression = (KtExpression)this.getElement();
            if (ktExpression == null) {
                return;
            }
            KtExpression element3 = ktExpression;
            KtExpression expressionToInsert = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)file2), (boolean)false, (int)2, null).createExpression(this.fixedExpression);
            PsiElement $this$replaced$iv = (PsiElement)element3;
            boolean $i$f$replaced = false;
            PsiElement result$iv = $this$replaced$iv.replace((PsiElement)expressionToInsert);
            PsiElement psiElement3 = result$iv;
            if (!(psiElement3 instanceof KtExpression)) {
                psiElement3 = null;
            }
            if ((psiElement2 = (PsiElement)((KtExpression)psiElement3)) == null) {
                PsiElement psiElement4 = result$iv;
                if (psiElement4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                KtExpression ktExpression2 = ((KtParenthesizedExpression)psiElement4).getExpression();
                if (ktExpression2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
                psiElement2 = (PsiElement)ktExpression2;
            }
            KtExpression newExpression2 = (KtExpression)psiElement2;
            Editor editor3 = editor2;
            if (editor3 == null || (editor3 = editor3.getCaretModel()) == null) break block5;
            editor3.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)newExpression2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public WrongPrimitiveLiteralFix(@NotNull KtConstantExpression element3, @NotNull KotlinType type2) {
        void $this$buildString;
        Number number;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        super((PsiElement)element3);
        ClassifierDescriptor classifierDescriptor = type2.getConstructor().getDeclarationDescriptor();
        Intrinsics.checkNotNull((Object)classifierDescriptor);
        FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor));
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"DescriptorUtils.getFqNam\u2026.declarationDescriptor!!)");
        this.typeName = fqNameUnsafe;
        this.expectedTypeIsFloat = KotlinBuiltIns.isFloat((KotlinType)type2);
        this.expectedTypeIsDouble = KotlinBuiltIns.isDouble((KotlinType)type2);
        this.expectedTypeIsUnsigned = TypeUtilsKt.isUnsignedNumberType((KotlinType)type2);
        WrongPrimitiveLiteralFix wrongPrimitiveLiteralFix = this;
        boolean bl = false;
        boolean bl2 = false;
        WrongPrimitiveLiteralFix wrongPrimitiveLiteralFix2 = wrongPrimitiveLiteralFix;
        WrongPrimitiveLiteralFix wrongPrimitiveLiteralFix3 = this;
        boolean $i$a$-run-WrongPrimitiveLiteralFix$constValue$22 = false;
        boolean shouldInlineConstVals = PlatformKt.getLanguageVersionSettings((PsiElement)element3).supportsFeature(LanguageFeature.InlineConstVals);
        ConstantValue constantValue = ExpressionCodegen.getPrimitiveOrStringCompileTimeConstant((KtExpression)((KtExpression)element3), (BindingContext)ResolutionUtils.analyze((KtElement)((KtElement)element3), (BodyResolveMode)BodyResolveMode.PARTIAL), (boolean)shouldInlineConstVals);
        Object object = constantValue != null ? constantValue.getValue() : null;
        if (!(object instanceof Number)) {
            object = null;
        }
        wrongPrimitiveLiteralFix3.constValue = number = (Number)object;
        boolean bl3 = false;
        bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        bl2 = false;
        boolean bl4 = false;
        StringBuilder $i$a$-run-WrongPrimitiveLiteralFix$constValue$22 = stringBuilder;
        wrongPrimitiveLiteralFix3 = this;
        boolean bl5 = false;
        if (this.expectedTypeIsFloat || this.expectedTypeIsDouble) {
            $this$buildString.append(this.constValue);
            if (this.expectedTypeIsFloat) {
                $this$buildString.append('F');
            } else if (!StringsKt.contains$default((CharSequence)((CharSequence)$this$buildString), (char)'.', (boolean)false, (int)2, null)) {
                $this$buildString.append(".0");
            }
        } else if (this.expectedTypeIsUnsigned) {
            $this$buildString.append(this.constValue);
            $this$buildString.append('u');
        } else {
            if (this.constValue instanceof Float || this.constValue instanceof Double) {
                $this$buildString.append(this.constValue.longValue());
            } else {
                String string = element3.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
                $this$buildString.append(StringsKt.trimEnd((String)string, (char[])new char[]{'l', 'L', 'u'}));
            }
            if (KotlinBuiltIns.isLong((KotlinType)type2)) {
                $this$buildString.append('L');
            }
        }
        number = Unit.INSTANCE;
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        wrongPrimitiveLiteralFix3.fixedExpression = string;
    }
}

