/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.changeSignature.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeSignatureDialogBase;
import com.intellij.refactoring.changeSignature.MethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterTableModelBase;
import com.intellij.refactoring.changeSignature.ParameterTableModelItemBase;
import com.intellij.refactoring.ui.ComboBoxVisibilityPanel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Consumer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.table.EditorTextFieldJBTableRowRenderer;
import com.intellij.util.ui.table.JBTableRow;
import com.intellij.util.ui.table.JBTableRowEditor;
import com.intellij.util.ui.table.JBTableRowRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.caches.resolve.CodeFragmentAnalyzer;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.intentions.AddFullQualifierIntention;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureProcessor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptorKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinTypeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinTypeInfoKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinValVar;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinCallableParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinCallerChooser;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinChangeSignatureDialog;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinChangeSignatureDialog$Companion$WhenMappings;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinChangeSignatureDialog$WhenMappings;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinFunctionParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinPrimaryConstructorParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinSecondaryConstructorParameterTableModel;
import org.jetbrains.kotlin.idea.refactoring.introduce.ui.KotlinSignatureComponent;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 A2,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0001:\u0001AB3\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0016\u001a\u00020\u000fH\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0014J.\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030 0\u001fH\u0014J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0005H\u0014J6\u0010#\u001a00$R,\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0001H\u0014J\b\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020(H\u0014J\b\u0010)\u001a\u00020*H\u0014J\u0016\u0010+\u001a\u0010\u0012\f\u0012\n -*\u0004\u0018\u00010\u00040\u00040,H\u0014J$\u0010.\u001a\u00020/2\u001a\u00100\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u000f01H\u0002J\b\u00102\u001a\u00020/H\u0002J\b\u00103\u001a\u000204H\u0014J\b\u00105\u001a\u00020\u0005H\u0002J\b\u00106\u001a\u00020\u000fH\u0014J\b\u00107\u001a\u00020/H\u0002J\u0016\u00108\u001a\u00020\u000f2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0002J\b\u0010:\u001a\u00020/H\u0014J\b\u0010;\u001a\u00020/H\u0002J\b\u0010<\u001a\u00020=H\u0014J\b\u0010>\u001a\u00020=H\u0014J\b\u0010?\u001a\u00020\u0018H\u0014J\n\u0010@\u001a\u0004\u0018\u00010\u000fH\u0014R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006B"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinChangeSignatureDialog;", "Lcom/intellij/refactoring/changeSignature/ChangeSignatureDialogBase;", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinParameterInfo;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinMethodDescriptor;", "Lcom/intellij/refactoring/changeSignature/ParameterTableModelItemBase;", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinCallableParameterTableModel;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "methodDescriptor", "context", "commandName", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinMethodDescriptor;Lcom/intellij/psi/PsiElement;Ljava/lang/String;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "parametersTableModel", "getParametersTableModel", "()Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinCallableParameterTableModel;", "calculateSignature", "canRun", "", "createCallerChooser", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinCallerChooser;", "title", "treeToReuse", "Lcom/intellij/ui/treeStructure/Tree;", "callback", "Lcom/intellij/util/Consumer;", "", "createParametersInfoModel", "descriptor", "createParametersListTable", "Lcom/intellij/refactoring/changeSignature/ChangeSignatureDialogBase$ParametersListTable;", "createRefactoringProcessor", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "createReturnTypeCodeFragment", "Lorg/jetbrains/kotlin/psi/KtTypeCodeFragment;", "createSignaturePreviewComponent", "Lorg/jetbrains/kotlin/idea/refactoring/introduce/ui/KotlinSignatureComponent;", "createVisibilityControl", "Lcom/intellij/refactoring/ui/ComboBoxVisibilityPanel;", "kotlin.jvm.PlatformType", "getColumnTextMaxLength", "", "nameFunction", "Lkotlin/Function1;", "getDefaultValuesMaxLength", "getFileType", "Lorg/jetbrains/kotlin/idea/KotlinFileType;", "getMethodDescriptor", "getMethodName", "getParamNamesMaxLength", "getPresentationName", "item", "getSelectedIdx", "getTypesMaxLength", "isListTableViewSupported", "", "mayPropagateParameters", "updateSignatureAlarmFired", "validateAndCommitData", "Companion", "kotlin.idea"})
public final class KotlinChangeSignatureDialog
extends ChangeSignatureDialogBase<KotlinParameterInfo, PsiElement, DescriptorVisibility, KotlinMethodDescriptor, ParameterTableModelItemBase<KotlinParameterInfo>, KotlinCallableParameterTableModel> {
    @Nullable
    private final Editor editor;
    private final String commandName;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected KotlinFileType getFileType() {
        KotlinFileType kotlinFileType = KotlinFileType.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinFileType, (String)"KotlinFileType.INSTANCE");
        return kotlinFileType;
    }

    @NotNull
    protected KotlinCallableParameterTableModel createParametersInfoModel(@NotNull KotlinMethodDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        PsiElement psiElement2 = this.myDefaultValueContext;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"myDefaultValueContext");
        return KotlinChangeSignatureDialog.Companion.createParametersInfoModel(descriptor2, psiElement2);
    }

    @NotNull
    protected KtTypeCodeFragment createReturnTypeCodeFragment() {
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        MethodDescriptor methodDescriptor = this.myMethod;
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"myMethod");
        return KotlinChangeSignatureDialog.Companion.createReturnTypeCodeFragment(project2, (KotlinMethodDescriptor)methodDescriptor);
    }

    private final KotlinCallableParameterTableModel getParametersTableModel() {
        ParameterTableModelBase parameterTableModelBase = this.myParametersTableModel;
        Intrinsics.checkNotNullExpressionValue((Object)parameterTableModelBase, (String)"super.myParametersTableModel");
        return (KotlinCallableParameterTableModel)parameterTableModelBase;
    }

    @NotNull
    protected ChangeSignatureDialogBase.ParametersListTable createParametersListTable() {
        return new ChangeSignatureDialogBase.ParametersListTable(this){
            private final createParametersListTable.rowRenderer.1 rowRenderer;
            final /* synthetic */ KotlinChangeSignatureDialog this$0;

            @NotNull
            protected JBTableRowRenderer getRowRenderer(int row) {
                return (JBTableRowRenderer)this.rowRenderer;
            }

            @NotNull
            protected JBTableRowEditor getRowEditor(@NotNull ParameterTableModelItemBase<KotlinParameterInfo> item) {
                Intrinsics.checkNotNullParameter(item, (String)"item");
                return new JBTableRowEditor(this, item){
                    private final ArrayList<JComponent> components;
                    private final EditorTextField nameEditor;
                    private final JCheckBox defaultParameterCheckbox;
                    final /* synthetic */ createParametersListTable.1 this$0;
                    final /* synthetic */ ParameterTableModelItemBase $item;

                    private final void notifyReceiverListeners() {
                        boolean isNotReceiver = !org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinChangeSignatureDialog$Companion.access$isReceiverIn(KotlinChangeSignatureDialog.Companion, this.$item, KotlinChangeSignatureDialog.access$getParametersTableModel$p(this.this$0.this$0));
                        this.nameEditor.setEnabled(isNotReceiver);
                        this.defaultParameterCheckbox.setEnabled(isNotReceiver);
                    }

                    private final boolean isDefaultColumnEnabled() {
                        return ((KotlinParameterInfo)this.$item.parameter).isNewParameter() && Intrinsics.areEqual((Object)((KotlinParameterInfo)this.$item.parameter), (Object)KotlinChangeSignatureDialog.access$getMyMethod$p(this.this$0.this$0).getReceiver()) ^ true;
                    }

                    public void prepareEditor(@NotNull JTable table, int row) {
                        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                        this.setLayout(new BoxLayout((Container)((Object)this), 0));
                        int column = 0;
                        for (ColumnInfo columnInfo : KotlinChangeSignatureDialog.access$getParametersTableModel$p(this.this$0.this$0).getColumnInfos()) {
                            Document document;
                            JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 4, 2, true, false));
                            EditorTextField editor2 = null;
                            JComponent component2 = null;
                            int columnFinal = column;
                            if (KotlinCallableParameterTableModel.Companion.isTypeColumn(columnInfo)) {
                                document = PsiDocumentManager.getInstance((Project)KotlinChangeSignatureDialog.access$getProject(this.this$0.this$0)).getDocument((PsiFile)this.$item.typeCodeFragment);
                                editor2 = new EditorTextField(document, KotlinChangeSignatureDialog.access$getProject(this.this$0.this$0), (FileType)this.this$0.this$0.getFileType());
                                component2 = (JComponent)editor2;
                            } else if (KotlinCallableParameterTableModel.Companion.isNameColumn(columnInfo)) {
                                editor2 = this.nameEditor;
                                component2 = (JComponent)editor2;
                                this.notifyReceiverListeners();
                            } else if (KotlinCallableParameterTableModel.Companion.isDefaultValueColumn(columnInfo) && this.isDefaultColumnEnabled()) {
                                document = PsiDocumentManager.getInstance((Project)KotlinChangeSignatureDialog.access$getProject(this.this$0.this$0)).getDocument((PsiFile)this.$item.defaultValueCodeFragment);
                                editor2 = new EditorTextField(document, KotlinChangeSignatureDialog.access$getProject(this.this$0.this$0), (FileType)this.this$0.this$0.getFileType());
                                component2 = (JComponent)editor2;
                            } else if (KotlinCallableParameterTableModel.Companion.isDefaultParameterColumn(columnInfo) && this.isDefaultColumnEnabled()) {
                                this.defaultParameterCheckbox.setSelected(((KotlinParameterInfo)this.$item.parameter).getDefaultValue() != null);
                                this.defaultParameterCheckbox.addItemListener(new ItemListener(this, row, columnFinal){
                                    final /* synthetic */ createParametersListTable.getRowEditor.1 this$0;
                                    final /* synthetic */ int $row;
                                    final /* synthetic */ int $columnFinal;

                                    public final void itemStateChanged(ItemEvent it) {
                                        KotlinCallableParameterTableModel kotlinCallableParameterTableModel = KotlinChangeSignatureDialog.access$getParametersTableModel$p(this.this$0.this$0.this$0);
                                        ItemEvent itemEvent = it;
                                        Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"it");
                                        kotlinCallableParameterTableModel.setValueAtWithoutUpdate(itemEvent.getStateChange() == 1, this.$row, this.$columnFinal);
                                        KotlinChangeSignatureDialog.access$updateSignature(this.this$0.this$0.this$0);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$row = n;
                                        this.$columnFinal = n2;
                                    }
                                });
                                component2 = this.defaultParameterCheckbox;
                                editor2 = null;
                                this.notifyReceiverListeners();
                            } else if (KotlinPrimaryConstructorParameterTableModel.Companion.isValVarColumn(columnInfo)) {
                                ComboBox comboBox = new ComboBox((Object[])KotlinValVar.values());
                                comboBox.setSelectedItem((Object)((Object)((KotlinParameterInfo)this.$item.parameter).getValOrVar()));
                                comboBox.addItemListener(new ItemListener(this, row, columnFinal){
                                    final /* synthetic */ createParametersListTable.getRowEditor.1 this$0;
                                    final /* synthetic */ int $row;
                                    final /* synthetic */ int $columnFinal;

                                    public final void itemStateChanged(ItemEvent it) {
                                        KotlinCallableParameterTableModel kotlinCallableParameterTableModel = KotlinChangeSignatureDialog.access$getParametersTableModel$p(this.this$0.this$0.this$0);
                                        ItemEvent itemEvent = it;
                                        Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"it");
                                        kotlinCallableParameterTableModel.setValueAtWithoutUpdate(itemEvent.getItem(), this.$row, this.$columnFinal);
                                        KotlinChangeSignatureDialog.access$updateSignature(this.this$0.this$0.this$0);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$row = n;
                                        this.$columnFinal = n2;
                                    }
                                });
                                component2 = (JComponent)comboBox;
                                editor2 = null;
                            } else {
                                if (!KotlinFunctionParameterTableModel.Companion.isReceiverColumn(columnInfo)) continue;
                                JCheckBox checkBox2 = new JCheckBox();
                                checkBox2.setSelected(Intrinsics.areEqual((Object)KotlinChangeSignatureDialog.access$getParametersTableModel$p(this.this$0.this$0).getReceiver(), (Object)((KotlinParameterInfo)this.$item.parameter)));
                                checkBox2.addItemListener(new ItemListener(this){
                                    final /* synthetic */ createParametersListTable.getRowEditor.1 this$0;

                                    public final void itemStateChanged(ItemEvent it) {
                                        ItemEvent itemEvent = it;
                                        Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"it");
                                        KotlinParameterInfo newReceiver = itemEvent.getStateChange() == 1 ? (KotlinParameterInfo)this.this$0.$item.parameter : null;
                                        KotlinCallableParameterTableModel kotlinCallableParameterTableModel = KotlinChangeSignatureDialog.access$getParametersTableModel$p(this.this$0.this$0.this$0);
                                        if (kotlinCallableParameterTableModel == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinFunctionParameterTableModel");
                                        }
                                        ((KotlinFunctionParameterTableModel)kotlinCallableParameterTableModel).setReceiver(newReceiver);
                                        KotlinChangeSignatureDialog.access$updateSignature(this.this$0.this$0.this$0);
                                        createParametersListTable.getRowEditor.1.access$notifyReceiverListeners(this.this$0);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                });
                                component2 = checkBox2;
                                editor2 = null;
                            }
                            ColumnInfo columnInfo2 = columnInfo;
                            Intrinsics.checkNotNullExpressionValue((Object)columnInfo2, (String)"columnInfo");
                            JBLabel label2 = new JBLabel(columnInfo2.getName(), UIUtil.ComponentStyle.SMALL);
                            panel2.add((Component)label2);
                            if (editor2 != null) {
                                editor2.addDocumentListener(new DocumentListener(this, columnFinal){
                                    final /* synthetic */ createParametersListTable.getRowEditor.1 this$0;
                                    final /* synthetic */ int $columnFinal;

                                    public void documentChanged(@NotNull DocumentEvent e) {
                                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                        this.this$0.fireDocumentChanged(e, this.$columnFinal);
                                    }
                                    {
                                        this.this$0 = this$0;
                                        this.$columnFinal = $captured_local_variable$1;
                                    }
                                });
                                editor2.setPreferredWidth(table.getWidth() / KotlinChangeSignatureDialog.access$getParametersTableModel$p(this.this$0.this$0).getColumnCount());
                            }
                            this.components.add(component2);
                            panel2.add(component2);
                            this.add(panel2);
                            ++column;
                        }
                    }

                    @NotNull
                    public JBTableRow getValue() {
                        return new JBTableRow(this){
                            final /* synthetic */ createParametersListTable.getRowEditor.1 this$0;

                            public final Object getValueAt(int column) {
                                Object object;
                                ColumnInfo columnInfo = KotlinChangeSignatureDialog.access$getParametersTableModel$p(this.this$0.this$0.this$0).getColumnInfos()[column];
                                if (KotlinPrimaryConstructorParameterTableModel.Companion.isValVarColumn(columnInfo)) {
                                    E e = createParametersListTable.getRowEditor.1.access$getComponents$p(this.this$0).get(column);
                                    if (e == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComboBox<*>");
                                    }
                                    object = ((JComboBox)e).getSelectedItem();
                                } else if (KotlinCallableParameterTableModel.Companion.isTypeColumn(columnInfo)) {
                                    object = this.this$0.$item.typeCodeFragment;
                                } else if (KotlinCallableParameterTableModel.Companion.isNameColumn(columnInfo)) {
                                    E e = createParametersListTable.getRowEditor.1.access$getComponents$p(this.this$0).get(column);
                                    if (e == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.EditorTextField");
                                    }
                                    object = ((EditorTextField)e).getText();
                                } else {
                                    object = KotlinCallableParameterTableModel.Companion.isDefaultValueColumn(columnInfo) ? this.this$0.$item.defaultValueCodeFragment : (KotlinCallableParameterTableModel.Companion.isDefaultParameterColumn(columnInfo) ? Boolean.valueOf(((KotlinParameterInfo)this.this$0.$item.parameter).getDefaultValue() != null) : null);
                                }
                                return object;
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        };
                    }

                    private final int getColumnWidth(int letters) {
                        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
                        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
                        Font font = editorColorsManager.getGlobalScheme().getFont(EditorFontType.PLAIN);
                        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"EditorColorsManager.getI\u2026ont(EditorFontType.PLAIN)");
                        Font font2 = font;
                        font2 = new Font(font2.getFontName(), font2.getStyle(), 12);
                        return letters * Toolkit.getDefaultToolkit().getFontMetrics(font2).stringWidth("W");
                    }

                    /*
                     * WARNING - void declaration
                     */
                    private final int getEditorIndex(int x) {
                        int[] nArray;
                        int x2 = x;
                        if (this.isDefaultColumnEnabled()) {
                            int[] nArray2 = new int[4];
                            nArray2[0] = 4;
                            nArray2[1] = KotlinChangeSignatureDialog.access$getParamNamesMaxLength(this.this$0.this$0);
                            nArray2[2] = KotlinChangeSignatureDialog.access$getTypesMaxLength(this.this$0.this$0);
                            nArray = nArray2;
                            nArray2[3] = KotlinChangeSignatureDialog.access$getDefaultValuesMaxLength(this.this$0.this$0);
                        } else {
                            int[] nArray3 = new int[3];
                            nArray3[0] = 4;
                            nArray3[1] = KotlinChangeSignatureDialog.access$getParamNamesMaxLength(this.this$0.this$0);
                            nArray = nArray3;
                            nArray3[2] = KotlinChangeSignatureDialog.access$getTypesMaxLength(this.this$0.this$0);
                        }
                        int[] columnLetters = nArray;
                        int columnIndex = 0;
                        int n = KotlinChangeSignatureDialog.access$getMyMethod$p(this.this$0.this$0).getKind() == KotlinMethodDescriptor.Kind.PRIMARY_CONSTRUCTOR ? 0 : 1;
                        int n2 = columnLetters.length;
                        while (n < n2) {
                            void i2;
                            int width = this.getColumnWidth(columnLetters[i2]);
                            if (x2 <= width) {
                                return columnIndex;
                            }
                            ++columnIndex;
                            x2 -= width;
                            ++i2;
                        }
                        return columnIndex - 1;
                    }

                    @NotNull
                    public JComponent getPreferredFocusedComponent() {
                        JComponent jComponent;
                        MouseEvent me = this.getMouseEvent();
                        int index2 = me != null ? this.getEditorIndex((int)me.getPoint().getX()) : (KotlinChangeSignatureDialog.access$getMyMethod$p(this.this$0.this$0).getKind() == KotlinMethodDescriptor.Kind.PRIMARY_CONSTRUCTOR ? 1 : 0);
                        JComponent jComponent2 = this.components.get(index2);
                        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"components[index]");
                        JComponent component2 = jComponent2;
                        if (component2 instanceof EditorTextField) {
                            JComponent jComponent3 = ((EditorTextField)component2).getFocusTarget();
                            jComponent = jComponent3;
                            Intrinsics.checkNotNullExpressionValue((Object)jComponent3, (String)"component.focusTarget");
                        } else {
                            jComponent = component2;
                        }
                        return jComponent;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public JComponent[] getFocusableComponents() {
                        int n = this.components.size();
                        JComponent[] jComponentArray = new JComponent[n];
                        for (int j = 0; j < n; ++j) {
                            Object object;
                            JComponent component2;
                            void it;
                            int n2 = j;
                            int n3 = j;
                            JComponent[] jComponentArray2 = jComponentArray;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)this.components.get((int)it), (String)"components[it]");
                            JComponent jComponent = component2;
                            if (!(jComponent instanceof EditorTextField)) {
                                jComponent = null;
                            }
                            if ((object = (EditorTextField)jComponent) == null || (object = object.getFocusTarget()) == null) {
                                object = component2;
                            }
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"(component as? EditorTex\u2026.focusTarget ?: component");
                            Object object2 = object;
                            jComponentArray2[n3] = object2;
                        }
                        return jComponentArray;
                    }
                    {
                        this.this$0 = this$0;
                        this.$item = $captured_local_variable$1;
                        this.components = new ArrayList<E>();
                        Object object = $captured_local_variable$1.parameter;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"item.parameter");
                        this.nameEditor = new EditorTextField(((KotlinParameterInfo)object).getName(), KotlinChangeSignatureDialog.access$getProject(this$0.this$0), (FileType)this$0.this$0.getFileType());
                        this.defaultParameterCheckbox = new JCheckBox();
                    }

                    public static final /* synthetic */ void access$notifyReceiverListeners(createParametersListTable.getRowEditor.1 $this) {
                        $this.notifyReceiverListeners();
                    }

                    public static final /* synthetic */ ArrayList access$getComponents$p(createParametersListTable.getRowEditor.1 $this) {
                        return $this.components;
                    }
                };
            }

            protected boolean isRowEmpty(int row) {
                ParameterTableModelItemBase rowItem = this.getRowItem(row);
                Object object = rowItem.parameter;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rowItem.parameter");
                CharSequence charSequence = ((KotlinParameterInfo)object).getName();
                boolean bl = false;
                if (charSequence.length() > 0) {
                    return false;
                }
                Object object2 = rowItem.parameter;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"rowItem.parameter");
                charSequence = ((KotlinParameterInfo)object2).getTypeText();
                bl = false;
                return !(charSequence.length() > 0);
            }
            {
                this.this$0 = this$0;
                super((ChangeSignatureDialogBase)this$0);
                this.rowRenderer = new EditorTextFieldJBTableRowRenderer(this, KotlinChangeSignatureDialog.access$getProject(this$0), (Language)KotlinLanguage.INSTANCE, this$0.getDisposable()){
                    final /* synthetic */ createParametersListTable.1 this$0;

                    @NotNull
                    protected String getText(@Nullable JTable table, int row) {
                        String string;
                        String string2;
                        String string3;
                        ParameterTableModelItemBase item;
                        block10: {
                            block9: {
                                item = createParametersListTable.1.access$getRowItem(this.this$0, row);
                                if (KotlinChangeSignatureDialog.access$getMyMethod$p(this.this$0.this$0).getKind() != KotlinMethodDescriptor.Kind.PRIMARY_CONSTRUCTOR) break block9;
                                switch (KotlinChangeSignatureDialog$WhenMappings.$EnumSwitchMapping$0[((KotlinParameterInfo)item.parameter).getValOrVar().ordinal()]) {
                                    case 1: {
                                        string3 = "    ";
                                        break block10;
                                    }
                                    case 2: {
                                        string3 = "val ";
                                        break block10;
                                    }
                                    case 3: {
                                        string3 = "var ";
                                        break block10;
                                    }
                                    default: {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                            }
                            string3 = "";
                        }
                        String valOrVar = string3;
                        KotlinChangeSignatureDialog kotlinChangeSignatureDialog = this.this$0.this$0;
                        ParameterTableModelItemBase parameterTableModelItemBase = item;
                        Intrinsics.checkNotNullExpressionValue((Object)parameterTableModelItemBase, (String)"item");
                        String parameterName2 = KotlinChangeSignatureDialog.access$getPresentationName(kotlinChangeSignatureDialog, parameterTableModelItemBase);
                        PsiCodeFragment psiCodeFragment = item.typeCodeFragment;
                        Intrinsics.checkNotNullExpressionValue((Object)psiCodeFragment, (String)"item.typeCodeFragment");
                        String typeText = psiCodeFragment.getText();
                        if (org.jetbrains.kotlin.idea.refactoring.changeSignature.ui.KotlinChangeSignatureDialog$Companion.access$isReceiverIn(KotlinChangeSignatureDialog.Companion, item, KotlinChangeSignatureDialog.access$getParametersTableModel$p(this.this$0.this$0)) || !((KotlinParameterInfo)item.parameter).getDefaultValueAsDefaultParameter()) {
                            PsiCodeFragment psiCodeFragment2 = item.defaultValueCodeFragment;
                            Intrinsics.checkNotNullExpressionValue((Object)psiCodeFragment2, (String)"item.defaultValueCodeFragment");
                            string2 = psiCodeFragment2.getText();
                        } else {
                            string2 = "";
                        }
                        String defaultValue = string2;
                        String string4 = StringUtil.repeatSymbol((char)' ', (int)(KotlinChangeSignatureDialog.access$getParamNamesMaxLength(this.this$0.this$0) - parameterName2.length() + 1));
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringUtil.repeatSymbol(\u2026parameterName.length + 1)");
                        String separator = string4;
                        StringBuilder stringBuilder = new StringBuilder().append(valOrVar).append(parameterName2).append(':').append(separator).append(typeText);
                        if (StringUtil.isNotEmpty((String)defaultValue)) {
                            Object[] objectArray = new Object[1];
                            String string5 = defaultValue;
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"defaultValue");
                            objectArray[0] = string5;
                            string = KotlinBundle.message("text.default.value", objectArray);
                        } else {
                            string = "";
                        }
                        String text2 = stringBuilder.append(string).toString();
                        return ' ' + text2;
                    }
                    {
                        this.this$0 = this$0;
                        super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                    }
                };
            }

            public static final /* synthetic */ ParameterTableModelItemBase access$getRowItem(createParametersListTable.1 $this, int p0) {
                return $this.getRowItem(p0);
            }
        };
    }

    private final String getPresentationName(ParameterTableModelItemBase<KotlinParameterInfo> item) {
        String string;
        KotlinParameterInfo parameter = (KotlinParameterInfo)item.parameter;
        if (Intrinsics.areEqual((Object)parameter, (Object)this.getParametersTableModel().getReceiver())) {
            string = "<receiver>";
        } else {
            KotlinParameterInfo kotlinParameterInfo = parameter;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinParameterInfo, (String)"parameter");
            string = kotlinParameterInfo.getName();
        }
        return string;
    }

    private final int getColumnTextMaxLength(Function1<? super ParameterTableModelItemBase<KotlinParameterInfo>, String> nameFunction) {
        Comparable comparable;
        List list2 = this.getParametersTableModel().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"parametersTableModel.items");
        Iterable iterable = list2;
        boolean bl = false;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            ParameterTableModelItemBase it = (ParameterTableModelItemBase)iterator.next();
            boolean bl2 = false;
            ParameterTableModelItemBase parameterTableModelItemBase = it;
            Intrinsics.checkNotNullExpressionValue((Object)parameterTableModelItemBase, (String)"it");
            String string = (String)nameFunction.invoke((Object)parameterTableModelItemBase);
            Comparable comparable2 = Integer.valueOf(string != null ? string.length() : 0);
            while (iterator.hasNext()) {
                ParameterTableModelItemBase it2 = (ParameterTableModelItemBase)iterator.next();
                $i$a$-maxOfOrNull-KotlinChangeSignatureDialog$getColumnTextMaxLength$1 = false;
                ParameterTableModelItemBase parameterTableModelItemBase2 = it2;
                Intrinsics.checkNotNullExpressionValue((Object)parameterTableModelItemBase2, (String)"it");
                String string2 = (String)nameFunction.invoke((Object)parameterTableModelItemBase2);
                Comparable comparable3 = Integer.valueOf(string2 != null ? string2.length() : 0);
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        return n != null ? n : 0;
    }

    private final int getParamNamesMaxLength() {
        return this.getColumnTextMaxLength((Function1<? super ParameterTableModelItemBase<KotlinParameterInfo>, String>)((Function1)new Function1<ParameterTableModelItemBase<KotlinParameterInfo>, String>(this){
            final /* synthetic */ KotlinChangeSignatureDialog this$0;

            @Nullable
            public final String invoke(@NotNull ParameterTableModelItemBase<KotlinParameterInfo> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return KotlinChangeSignatureDialog.access$getPresentationName(this.this$0, it);
            }
            {
                this.this$0 = kotlinChangeSignatureDialog;
                super(1);
            }
        }));
    }

    private final int getTypesMaxLength() {
        return this.getColumnTextMaxLength((Function1<? super ParameterTableModelItemBase<KotlinParameterInfo>, String>)((Function1)getTypesMaxLength.1.INSTANCE));
    }

    private final int getDefaultValuesMaxLength() {
        return this.getColumnTextMaxLength((Function1<? super ParameterTableModelItemBase<KotlinParameterInfo>, String>)((Function1)getDefaultValuesMaxLength.1.INSTANCE));
    }

    protected boolean isListTableViewSupported() {
        return true;
    }

    @NotNull
    protected KotlinCallerChooser createCallerChooser(@NotNull String title, @Nullable Tree treeToReuse, @NotNull Consumer<Set<PsiElement>> callback2) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        MethodDescriptor methodDescriptor = this.myMethod;
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"myMethod");
        PsiElement psiElement2 = ((KotlinMethodDescriptor)methodDescriptor).getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"myMethod.method");
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        return new KotlinCallerChooser(psiElement2, project2, title, treeToReuse, callback2);
    }

    protected boolean mayPropagateParameters() {
        boolean bl;
        block3: {
            List list2 = this.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"parameters");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinParameterInfo it = (KotlinParameterInfo)element$iv;
                    boolean bl2 = false;
                    if (!(it.isNewParameter() && Intrinsics.areEqual((Object)it, (Object)this.getParametersTableModel().getReceiver()) ^ true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    protected String calculateSignature() {
        KotlinCallableParameterTableModel kotlinCallableParameterTableModel = this.getParametersTableModel();
        KotlinMethodDescriptor kotlinMethodDescriptor = this.getMethodDescriptor();
        DescriptorVisibility descriptorVisibility = (DescriptorVisibility)this.getVisibility();
        String string = this.getMethodName();
        PsiElement psiElement2 = this.myDefaultValueContext;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"myDefaultValueContext");
        return KotlinChangeSignatureDialog.Companion.evaluateChangeInfo(kotlinCallableParameterTableModel, this.myReturnTypeCodeFragment, kotlinMethodDescriptor, descriptorVisibility, string, psiElement2, true).getNewSignature(this.getMethodDescriptor().getOriginalPrimaryCallable());
    }

    @NotNull
    protected ComboBoxVisibilityPanel<DescriptorVisibility> createVisibilityControl() {
        return new ComboBoxVisibilityPanel((Object[])new DescriptorVisibility[]{DescriptorVisibilities.INTERNAL, DescriptorVisibilities.PRIVATE, DescriptorVisibilities.PROTECTED, DescriptorVisibilities.PUBLIC});
    }

    protected void updateSignatureAlarmFired() {
        super.updateSignatureAlarmFired();
        this.validateButtons();
    }

    @NotNull
    protected KotlinSignatureComponent createSignaturePreviewComponent() {
        String string = this.calculateSignature();
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        return new KotlinSignatureComponent(string, project2);
    }

    @Nullable
    protected String validateAndCommitData() {
        if (((KotlinMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite && Companion.getTypeInfo(this.myReturnTypeCodeFragment, true, false).getType() == null) {
            Project project2 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
            Object[] objectArray = new Object[1];
            PsiCodeFragment psiCodeFragment = this.myReturnTypeCodeFragment;
            objectArray[0] = String.valueOf(psiCodeFragment != null ? psiCodeFragment.getText() : null);
            if (!Companion.showWarningMessage(project2, KotlinBundle.message("message.text.return.type.cannot.be.resolved", objectArray))) {
                return "";
            }
        }
        for (ParameterTableModelItemBase item : this.getParametersTableModel().getItems()) {
            Object object;
            if (Companion.getTypeInfo(item.typeCodeFragment, true, false).getType() != null) continue;
            Project project3 = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"myProject");
            Object[] objectArray = new Object[2];
            PsiCodeFragment psiCodeFragment = item.typeCodeFragment;
            Intrinsics.checkNotNullExpressionValue((Object)psiCodeFragment, (String)"item.typeCodeFragment");
            String string = psiCodeFragment.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.typeCodeFragment.text");
            objectArray[0] = string;
            if (Intrinsics.areEqual((Object)((KotlinParameterInfo)item.parameter), (Object)this.getParametersTableModel().getReceiver()) ^ true) {
                Object[] objectArray2 = new Object[1];
                Object object2 = item.parameter;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"item.parameter");
                objectArray2[0] = ((KotlinParameterInfo)object2).getName();
                object = KotlinBundle.message("text.parameter.0", objectArray2);
            } else {
                object = objectArray[1] = KotlinBundle.message("text.receiver", new Object[0]);
            }
            if (Companion.showWarningMessage(project3, KotlinBundle.message("message.type.for.cannot.be.resolved", objectArray))) continue;
            return "";
        }
        return null;
    }

    @NotNull
    protected String getMethodName() {
        String string = super.getMethodName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"super.getMethodName()");
        return KtPsiUtilKt.quoteIfNeeded((String)string);
    }

    protected void canRun() {
        JPanel jPanel2 = this.myNamePanel;
        Intrinsics.checkNotNullExpressionValue((Object)jPanel2, (String)"myNamePanel");
        if (jPanel2.isVisible() && ((KotlinMethodDescriptor)this.myMethod).canChangeName() && !KtPsiUtilKt.isIdentifier((String)this.getMethodName())) {
            throw (Throwable)new ConfigurationException(KotlinBundle.message("function.name.is.invalid", new Object[0]));
        }
        if (((KotlinMethodDescriptor)this.myMethod).canChangeReturnType() == MethodDescriptor.ReadWriteOption.ReadWrite) {
            PsiCodeFragment psiCodeFragment = this.myReturnTypeCodeFragment;
            if (!(psiCodeFragment instanceof KtTypeCodeFragment)) {
                psiCodeFragment = null;
            }
            KtTypeCodeFragment ktTypeCodeFragment = (KtTypeCodeFragment)psiCodeFragment;
            if (ktTypeCodeFragment != null) {
                KotlinRefactoringUtilKt.validateElement((KtElement)ktTypeCodeFragment, KotlinBundle.message("return.type.is.invalid", new Object[0]));
            }
        }
        for (ParameterTableModelItemBase item : this.getParametersTableModel().getItems()) {
            Object object = item.parameter;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"item.parameter");
            String parameterName2 = KtPsiUtilKt.quoteIfNeeded((String)((KotlinParameterInfo)object).getName());
            if (Intrinsics.areEqual((Object)((KotlinParameterInfo)item.parameter), (Object)this.getParametersTableModel().getReceiver()) ^ true && !KtPsiUtilKt.isIdentifier((String)parameterName2)) {
                throw (Throwable)new ConfigurationException(KotlinBundle.message("parameter.name.is.invalid", parameterName2));
            }
            PsiCodeFragment psiCodeFragment = item.typeCodeFragment;
            if (!(psiCodeFragment instanceof KtTypeCodeFragment)) {
                psiCodeFragment = null;
            }
            KtTypeCodeFragment ktTypeCodeFragment = (KtTypeCodeFragment)psiCodeFragment;
            if (ktTypeCodeFragment == null) continue;
            KtElement ktElement = (KtElement)ktTypeCodeFragment;
            Object[] objectArray = new Object[1];
            PsiCodeFragment psiCodeFragment2 = item.typeCodeFragment;
            Intrinsics.checkNotNullExpressionValue((Object)psiCodeFragment2, (String)"item.typeCodeFragment");
            String string = psiCodeFragment2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"item.typeCodeFragment.text");
            objectArray[0] = string;
            KotlinRefactoringUtilKt.validateElement(ktElement, KotlinBundle.message("parameter.type.is.invalid", objectArray));
        }
    }

    @NotNull
    protected BaseRefactoringProcessor createRefactoringProcessor() {
        KotlinCallableParameterTableModel kotlinCallableParameterTableModel = this.getParametersTableModel();
        KotlinMethodDescriptor kotlinMethodDescriptor = this.getMethodDescriptor();
        DescriptorVisibility descriptorVisibility = (DescriptorVisibility)this.getVisibility();
        String string = this.getMethodName();
        PsiElement psiElement2 = this.myDefaultValueContext;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"myDefaultValueContext");
        KotlinChangeInfo changeInfo = KotlinChangeSignatureDialog.Companion.evaluateChangeInfo(kotlinCallableParameterTableModel, this.myReturnTypeCodeFragment, kotlinMethodDescriptor, descriptorVisibility, string, psiElement2, false);
        Set set2 = this.myMethodsToPropagateParameters;
        changeInfo.setPrimaryPropagationTargets(set2 != null ? (Collection)set2 : (Collection)CollectionsKt.emptyList());
        changeInfo.setCheckUsedParameters(true);
        Project project2 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"myProject");
        String string2 = this.commandName;
        if (string2 == null) {
            string2 = this.getTitle();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"commandName ?: title");
        return (BaseRefactoringProcessor)new KotlinChangeSignatureProcessor(project2, changeInfo, string2);
    }

    private final KotlinMethodDescriptor getMethodDescriptor() {
        MethodDescriptor methodDescriptor = this.myMethod;
        Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"myMethod");
        return (KotlinMethodDescriptor)methodDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    protected int getSelectedIdx() {
        Integer n;
        Object v2;
        block8: {
            MethodDescriptor methodDescriptor = this.myMethod;
            Intrinsics.checkNotNullExpressionValue((Object)methodDescriptor, (String)"myMethod");
            List list2 = ((KotlinMethodDescriptor)methodDescriptor).getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"myMethod.parameters");
            Iterable $this$firstOrNull$iv = CollectionsKt.withIndex((Iterable)list2);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IndexedValue it = (IndexedValue)element$iv;
                boolean bl4 = false;
                if (!((KotlinParameterInfo)it.getValue()).isNewParameter()) continue;
                v2 = element$iv;
                break block8;
            }
            v2 = null;
        }
        IndexedValue indexedValue = v2;
        if (indexedValue != null) {
            n = indexedValue.getIndex();
        } else {
            Editor editor2 = this.editor;
            if (editor2 != null) {
                void $this$findElementForRename$iv;
                Editor editor3 = editor2;
                boolean bl = false;
                boolean bl2 = false;
                Editor editor4 = editor3;
                boolean bl3 = false;
                PsiElement psiElement2 = this.myDefaultValueContext;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"myDefaultValueContext");
                PsiFile psiFile2 = psiElement2.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"myDefaultValueContext.containingFile");
                PsiFile bl4 = psiFile2;
                CaretModel caretModel = editor4.getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
                int offset$iv = caretModel.getOffset();
                boolean $i$f$findElementForRename = false;
                PsiElement psiElement3 = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)$this$findElementForRename$iv, (int)offset$iv, KtParameter.class, (boolean)false);
                if (psiElement3 == null) {
                    psiElement3 = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)$this$findElementForRename$iv, (int)RangesKt.coerceAtLeast((int)(offset$iv - 1), (int)0), KtParameter.class, (boolean)false);
                }
                KtParameter ktParameter = (KtParameter)psiElement3;
                if (ktParameter != null) {
                    Integer n2 = KtPsiUtilKt.parameterIndex((PsiElement)((PsiElement)ktParameter));
                    boolean bl5 = false;
                    boolean bl6 = false;
                    int offset2 = ((Number)n2).intValue();
                    boolean bl7 = false;
                    n = !(offset2 == -1) ? n2 : null;
                } else {
                    n = null;
                }
            } else {
                n = null;
            }
        }
        return n != null ? n.intValue() : super.getSelectedIdx();
    }

    @Nullable
    public final Editor getEditor() {
        return this.editor;
    }

    public KotlinChangeSignatureDialog(@NotNull Project project2, @Nullable Editor editor2, @NotNull KotlinMethodDescriptor methodDescriptor, @NotNull PsiElement context2, @NlsContexts.Command @Nullable String commandName) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)methodDescriptor, (String)"methodDescriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(project2, (MethodDescriptor)methodDescriptor, false, context2);
        this.editor = editor2;
        this.commandName = commandName;
    }

    public static final /* synthetic */ KotlinCallableParameterTableModel access$getParametersTableModel$p(KotlinChangeSignatureDialog $this) {
        return $this.getParametersTableModel();
    }

    public static final /* synthetic */ KotlinMethodDescriptor access$getMyMethod$p(KotlinChangeSignatureDialog $this) {
        return (KotlinMethodDescriptor)$this.myMethod;
    }

    public static final /* synthetic */ Project access$getProject(KotlinChangeSignatureDialog $this) {
        return $this.getProject();
    }

    public static final /* synthetic */ void access$updateSignature(KotlinChangeSignatureDialog $this) {
        $this.updateSignature();
    }

    public static final /* synthetic */ int access$getParamNamesMaxLength(KotlinChangeSignatureDialog $this) {
        return $this.getParamNamesMaxLength();
    }

    public static final /* synthetic */ int access$getTypesMaxLength(KotlinChangeSignatureDialog $this) {
        return $this.getTypesMaxLength();
    }

    public static final /* synthetic */ int access$getDefaultValuesMaxLength(KotlinChangeSignatureDialog $this) {
        return $this.getDefaultValuesMaxLength();
    }

    public static final /* synthetic */ String access$getPresentationName(KotlinChangeSignatureDialog $this, ParameterTableModelItemBase item) {
        return $this.getPresentationName((ParameterTableModelItemBase<KotlinParameterInfo>)item);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002JD\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001b\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\f2\u000b\u0010\u001e\u001a\u00070\u000e\u00a2\u0006\u0002\b\u001fJ\u001c\u0010 \u001a\u00020!*\u0004\u0018\u00010\u00162\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010#\u001a\u00020\u001c*\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010&\u001a\u00020\u0004H\u0002\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinChangeSignatureDialog$Companion;", "", "()V", "createParametersInfoModel", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/ui/KotlinCallableParameterTableModel;", "descriptor", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinMethodDescriptor;", "defaultValueContext", "Lcom/intellij/psi/PsiElement;", "createRefactoringProcessorForSilentChangeSignature", "Lcom/intellij/refactoring/BaseRefactoringProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "commandName", "", "method", "createReturnTypeCodeFragment", "Lorg/jetbrains/kotlin/psi/KtTypeCodeFragment;", "evaluateChangeInfo", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeInfo;", "parametersModel", "returnTypeCodeFragment", "Lcom/intellij/psi/PsiCodeFragment;", "methodDescriptor", "visibility", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "methodName", "forPreview", "", "showWarningMessage", "message", "Lcom/intellij/openapi/util/NlsContexts$DialogMessage;", "getTypeInfo", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinTypeInfo;", "isCovariant", "isReceiverIn", "Lcom/intellij/refactoring/changeSignature/ParameterTableModelItemBase;", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinParameterInfo;", "model", "kotlin.idea"})
    public static final class Companion {
        private final boolean isReceiverIn(ParameterTableModelItemBase<KotlinParameterInfo> $this$isReceiverIn, KotlinCallableParameterTableModel model2) {
            return Intrinsics.areEqual((Object)((KotlinParameterInfo)$this$isReceiverIn.parameter), (Object)model2.getReceiver());
        }

        public final boolean showWarningMessage(@NotNull Project project2, @NotNull String message2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
            String string = RefactoringBundle.message((String)"changeSignature.refactoring.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"RefactoringBundle.messag\u2026nature.refactoring.name\")");
            return ((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(string, message2).asWarning()).ask(project2);
        }

        private final KotlinCallableParameterTableModel createParametersInfoModel(KotlinMethodDescriptor descriptor2, PsiElement defaultValueContext) {
            KotlinCallableParameterTableModel kotlinCallableParameterTableModel;
            switch (KotlinChangeSignatureDialog$Companion$WhenMappings.$EnumSwitchMapping$0[descriptor2.getKind().ordinal()]) {
                case 1: {
                    kotlinCallableParameterTableModel = new KotlinFunctionParameterTableModel(descriptor2, defaultValueContext);
                    break;
                }
                case 2: {
                    kotlinCallableParameterTableModel = new KotlinPrimaryConstructorParameterTableModel(descriptor2, defaultValueContext);
                    break;
                }
                case 3: {
                    kotlinCallableParameterTableModel = new KotlinSecondaryConstructorParameterTableModel(descriptor2, defaultValueContext);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return kotlinCallableParameterTableModel;
        }

        private final KtTypeCodeFragment createReturnTypeCodeFragment(Project project2, KotlinMethodDescriptor method) {
            return new KtPsiFactory(project2, false, 2, null).createTypeCodeFragment(KotlinTypeInfoKt.render(KotlinMethodDescriptorKt.getReturnTypeInfo(method)), (PsiElement)KotlinCallableParameterTableModel.Companion.getTypeCodeFragmentContext(method.getBaseDeclaration()));
        }

        @NotNull
        public final BaseRefactoringProcessor createRefactoringProcessorForSilentChangeSignature(@NotNull Project project2, @NlsContexts.Command @NotNull String commandName, @NotNull KotlinMethodDescriptor method, @NotNull PsiElement defaultValueContext) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)commandName, (String)"commandName");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)defaultValueContext, (String)"defaultValueContext");
            KotlinCallableParameterTableModel parameterTableModel = this.createParametersInfoModel(method, defaultValueContext);
            parameterTableModel.setParameterInfos(method.getParameters());
            PsiCodeFragment psiCodeFragment = (PsiCodeFragment)this.createReturnTypeCodeFragment(project2, method);
            DescriptorVisibility descriptorVisibility = (DescriptorVisibility)method.getVisibility();
            String string = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
            KotlinChangeInfo changeInfo = this.evaluateChangeInfo(parameterTableModel, psiCodeFragment, method, descriptorVisibility, string, defaultValueContext, false);
            return (BaseRefactoringProcessor)new KotlinChangeSignatureProcessor(project2, changeInfo, commandName);
        }

        @NotNull
        public final KotlinTypeInfo getTypeInfo(@Nullable PsiCodeFragment $this$getTypeInfo, boolean isCovariant, boolean forPreview) {
            Object object;
            KotlinType it;
            boolean bl;
            boolean bl2;
            KotlinType kotlinType;
            if (!($this$getTypeInfo instanceof KtTypeCodeFragment)) {
                return new KotlinTypeInfo(isCovariant, null, null, 6, null);
            }
            KtTypeReference typeRef = ((KtTypeCodeFragment)$this$getTypeInfo).getContentElement();
            Object object2 = typeRef;
            if (object2 == null || (object2 = object2.getText()) == null) {
                return new KotlinTypeInfo(isCovariant, null, null, 6, null);
            }
            Object typeRefText = object2;
            KotlinType kotlinType2 = (KotlinType)ResolutionUtils.analyze((KtElement)((KtElement)typeRef), (BodyResolveMode)BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.TYPE, (Object)typeRef);
            if (kotlinType2 != null) {
                kotlinType = kotlinType2;
                bl2 = false;
                bl = false;
                it = kotlinType;
                boolean bl3 = false;
                KotlinType kotlinType3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"it");
                object = !KotlinTypeKt.isError((KotlinType)kotlinType3) ? kotlinType : null;
            } else {
                object = null;
            }
            KotlinType type2 = object;
            kotlinType = typeRefText;
            bl2 = false;
            bl = false;
            it = kotlinType;
            KotlinType kotlinType4 = type2;
            boolean bl4 = isCovariant;
            boolean bl5 = false;
            boolean bl6 = forPreview || type2 == null;
            KotlinType kotlinType5 = bl6 ? kotlinType : null;
            KotlinType kotlinType6 = kotlinType4;
            boolean bl7 = bl4;
            return new KotlinTypeInfo(bl7, kotlinType6, (String)kotlinType5);
        }

        /*
         * WARNING - void declaration
         */
        private final KotlinChangeInfo evaluateChangeInfo(KotlinCallableParameterTableModel parametersModel, PsiCodeFragment returnTypeCodeFragment, KotlinMethodDescriptor methodDescriptor, DescriptorVisibility visibility2, String methodName2, PsiElement defaultValueContext, boolean forPreview) {
            List list2;
            void $this$mapTo$iv$iv;
            List list3 = parametersModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"parametersModel.items");
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void parameter;
                ParameterTableModelItemBase parameterTableModelItemBase = (ParameterTableModelItemBase)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                KotlinParameterInfo parameterInfo = (KotlinParameterInfo)parameter.parameter;
                if (!forPreview) {
                    void v1 = parameter;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"parameter");
                    if (Companion.isReceiverIn((ParameterTableModelItemBase<KotlinParameterInfo>)v1, parametersModel)) {
                        parameterInfo.setDefaultValueAsDefaultParameter(false);
                    }
                }
                KotlinTypeInfo kotlinTypeInfo = Companion.getTypeInfo(parameter.typeCodeFragment, false, forPreview);
                KotlinType newKotlinType = kotlinTypeInfo.getType();
                KotlinType oldKotlinType = parameterInfo.getCurrentTypeInfo().getType();
                parameterInfo.setCurrentTypeInfo(kotlinTypeInfo);
                PsiCodeFragment psiCodeFragment = parameter.defaultValueCodeFragment;
                if (psiCodeFragment == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpressionCodeFragment");
                }
                KtExpressionCodeFragment codeFragment = (KtExpressionCodeFragment)psiCodeFragment;
                if (Intrinsics.areEqual((Object)newKotlinType, (Object)oldKotlinType) ^ true && codeFragment.getContentElement() != null) {
                    codeFragment.putUserData(CodeFragmentAnalyzer.Companion.getEXPECTED_TYPE_KEY(), (Object)kotlinTypeInfo.getType());
                    DaemonCodeAnalyzer.getInstance((Project)codeFragment.getProject()).restart((PsiFile)codeFragment);
                }
                if (!forPreview) {
                    AddFullQualifierIntention.Companion.addQualifiersRecursively((KtElement)codeFragment);
                }
                KtExpression oldDefaultValue = parameterInfo.getDefaultValueForCall();
                if (Intrinsics.areEqual((Object)codeFragment.getText(), (Object)(oldDefaultValue != null ? oldDefaultValue.getText() : "")) ^ true) {
                    parameterInfo.setDefaultValueForCall(codeFragment.getContentElement());
                }
                KotlinParameterInfo kotlinParameterInfo = parameterInfo;
                collection.add(kotlinParameterInfo);
            }
            List parameters2 = (List)destination$iv$iv;
            if (parametersModel.getReceiver() != null) {
                Iterable $this$sortedByDescending$iv = parameters2;
                boolean $i$f$sortedByDescending = false;
                boolean bl = false;
                list2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(parametersModel){
                    final /* synthetic */ KotlinCallableParameterTableModel $parametersModel$inlined;
                    {
                        this.$parametersModel$inlined = kotlinCallableParameterTableModel;
                    }

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        KotlinParameterInfo it = (KotlinParameterInfo)b;
                        boolean bl2 = false;
                        Comparable comparable = Boolean.valueOf(Intrinsics.areEqual((Object)it, (Object)this.$parametersModel$inlined.getReceiver()));
                        it = (KotlinParameterInfo)a;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Boolean bl3 = Intrinsics.areEqual((Object)it, (Object)this.$parametersModel$inlined.getReceiver());
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)bl3);
                    }
                });
            } else {
                list2 = parameters2;
            }
            List parametersWithReceiverInFirstPosition = list2;
            KotlinMethodDescriptor kotlinMethodDescriptor = methodDescriptor.getOriginal();
            KotlinTypeInfo kotlinTypeInfo = this.getTypeInfo(returnTypeCodeFragment, true, forPreview);
            DescriptorVisibility descriptorVisibility = visibility2;
            if (descriptorVisibility == null) {
                descriptorVisibility = DescriptorVisibilities.DEFAULT_VISIBILITY;
            }
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"visibility ?: Descriptor\u2026lities.DEFAULT_VISIBILITY");
            return new KotlinChangeInfo(kotlinMethodDescriptor, methodName2, kotlinTypeInfo, descriptorVisibility, parametersWithReceiverInFirstPosition, parametersModel.getReceiver(), defaultValueContext, null, false, 384, null);
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$isReceiverIn(Companion $this, ParameterTableModelItemBase $this$access_u24isReceiverIn, KotlinCallableParameterTableModel model2) {
            return $this.isReceiverIn((ParameterTableModelItemBase<KotlinParameterInfo>)$this$access_u24isReceiverIn, model2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

