/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.cutPaste;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.util.RangeUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.cutPaste.MoveDeclarationsProcessor;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J!\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsIntentionAction;", "Lcom/intellij/refactoring/BaseRefactoringIntentionAction;", "Lcom/intellij/codeInspection/HintAction;", "processor", "Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsProcessor;", "bounds", "Lcom/intellij/openapi/editor/RangeMarker;", "modificationCount", "", "(Lorg/jetbrains/kotlin/idea/refactoring/cutPaste/MoveDeclarationsProcessor;Lcom/intellij/openapi/editor/RangeMarker;J)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "showHint", "startInWriteAction", "kotlin.idea"})
public final class MoveDeclarationsIntentionAction
extends BaseRefactoringIntentionAction
implements HintAction {
    private final MoveDeclarationsProcessor processor;
    private final RangeMarker bounds;
    private final long modificationCount;

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getText() {
        return KotlinBundle.message("text.update.usages.to.reflect.declaration.0.move", this.processor.getPastedDeclarations().size());
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("family.name.update.usages.on.declarations.cut.paste", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        PsiModificationTracker psiModificationTracker = PsiModificationTracker.SERVICE.getInstance((Project)this.processor.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiModificationTracker, (String)"PsiModificationTracker.S\u2026stance(processor.project)");
        return psiModificationTracker.getModificationCount() == this.modificationCount;
    }

    public void invoke(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiElement element3) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        this.processor.performRefactoring();
    }

    public boolean showHint(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        TextRange textRange = RangeUtilsKt.getRange(this.bounds);
        if (textRange == null) {
            return false;
        }
        TextRange range = textRange;
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        if (caretModel.getOffset() != range.getEndOffset()) {
            return false;
        }
        PsiModificationTracker psiModificationTracker = PsiModificationTracker.SERVICE.getInstance((Project)this.processor.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiModificationTracker, (String)"PsiModificationTracker.S\u2026stance(processor.project)");
        if (psiModificationTracker.getModificationCount() != this.modificationCount) {
            return false;
        }
        String hintText = this.getText() + "? " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        HintManager.getInstance().showQuestionHint(editor2, hintText, range.getEndOffset(), range.getEndOffset(), new QuestionAction(this){
            final /* synthetic */ MoveDeclarationsIntentionAction this$0;

            public final boolean execute() {
                MoveDeclarationsIntentionAction.access$getProcessor$p(this.this$0).performRefactoring();
                return true;
            }
            {
                this.this$0 = moveDeclarationsIntentionAction;
            }
        });
        return true;
    }

    public MoveDeclarationsIntentionAction(@NotNull MoveDeclarationsProcessor processor2, @NotNull RangeMarker bounds, long modificationCount) {
        Intrinsics.checkNotNullParameter((Object)processor2, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.processor = processor2;
        this.bounds = bounds;
        this.modificationCount = modificationCount;
    }

    public static final /* synthetic */ MoveDeclarationsProcessor access$getProcessor$p(MoveDeclarationsIntentionAction $this) {
        return $this.processor;
    }
}

