/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.FrontendIndependentPsiUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinRenameDispatcherHandler;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameter;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\"\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KotlinVariableInplaceRenameHandler;", "Lcom/intellij/refactoring/rename/inplace/VariableInplaceRenameHandler;", "()V", "createRenamer", "Lcom/intellij/refactoring/rename/inplace/VariableInplaceRenamer;", "elementToRename", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "element", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "RenamerImpl", "kotlin.idea"})
public class KotlinVariableInplaceRenameHandler
extends VariableInplaceRenameHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    protected VariableInplaceRenamer createRenamer(@NotNull PsiElement elementToRename, @NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        PsiNameIdentifierOwner currentElementToRename = (PsiNameIdentifierOwner)elementToRename;
        Object object = currentElementToRename.getNameIdentifier();
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        Object currentName = object;
        return new RenamerImpl((PsiNamedElement)currentElementToRename, editor2, (String)currentName, (String)currentName);
    }

    public boolean isAvailable(@Nullable PsiElement element3, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        EditorSettings editorSettings = editor2.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
        return editorSettings.isVariableInplaceRenameEnabled() && element3 != null && Companion.isInplaceRenameAvailable(element3);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0014\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\bH\u0014J\u001c\u0010\u0012\u001a\u00020\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KotlinVariableInplaceRenameHandler$RenamerImpl;", "Lcom/intellij/refactoring/rename/inplace/VariableInplaceRenamer;", "elementToRename", "Lcom/intellij/psi/PsiNamedElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiNamedElement;Lcom/intellij/openapi/editor/Editor;)V", "currentName", "", "oldName", "(Lcom/intellij/psi/PsiNamedElement;Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;Ljava/lang/String;)V", "acceptReference", "", "reference", "Lcom/intellij/psi/PsiReference;", "createInplaceRenamerToRestart", "variable", "initialName", "startsOnTheSameElement", "handler", "Lcom/intellij/refactoring/RefactoringActionHandler;", "element", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
    protected static class RenamerImpl
    extends VariableInplaceRenamer {
        protected boolean acceptReference(@NotNull PsiReference reference2) {
            Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
            PsiElement psiElement2 = reference2.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"reference.element");
            PsiElement refElement2 = psiElement2;
            TextRange textRange = reference2.getRangeInElement();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"reference.rangeInElement");
            TextRange textRange2 = textRange;
            String string = refElement2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"refElement.text");
            String string2 = string;
            int n = textRange2.getStartOffset();
            int n2 = textRange2.getEndOffset();
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String referenceText = FrontendIndependentPsiUtilsKt.unquote(string4);
            PsiNamedElement psiNamedElement = this.myElementToRename;
            Intrinsics.checkNotNullExpressionValue((Object)psiNamedElement, (String)"myElementToRename");
            return Intrinsics.areEqual((Object)referenceText, (Object)psiNamedElement.getName());
        }

        protected boolean startsOnTheSameElement(@Nullable RefactoringActionHandler handler, @Nullable PsiElement element3) {
            return Intrinsics.areEqual((Object)this.getVariable(), (Object)element3) && (handler instanceof VariableInplaceRenameHandler || handler instanceof KotlinRenameDispatcherHandler);
        }

        @NotNull
        protected VariableInplaceRenamer createInplaceRenamerToRestart(@NotNull PsiNamedElement variable2, @NotNull Editor editor2, @NotNull String initialName2) {
            Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)initialName2, (String)"initialName");
            String string = this.myOldName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myOldName");
            return new RenamerImpl(variable2, editor2, initialName2, string);
        }

        public RenamerImpl(@NotNull PsiNamedElement elementToRename, @NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            super(elementToRename, editor2);
        }

        public RenamerImpl(@NotNull PsiNamedElement elementToRename, @NotNull Editor editor2, @NotNull String currentName, @NotNull String oldName) {
            Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)currentName, (String)"currentName");
            Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
            Project project2 = editor2.getProject();
            Intrinsics.checkNotNull((Object)project2);
            super(elementToRename, editor2, project2, currentName, oldName);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KotlinVariableInplaceRenameHandler$Companion;", "", "()V", "isInplaceRenameAvailable", "", "element", "Lcom/intellij/psi/PsiElement;", "kotlin.idea"})
    public static final class Companion {
        public final boolean isInplaceRenameAvailable(@NotNull PsiElement element3) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            PsiElement psiElement2 = element3;
            if (psiElement2 instanceof KtTypeParameter) {
                return true;
            }
            if (psiElement2 instanceof KtDestructuringDeclarationEntry) {
                return true;
            }
            if (psiElement2 instanceof KtParameter) {
                PsiElement parent2 = ((KtParameter)element3).getParent();
                if (parent2 instanceof KtForExpression) {
                    return true;
                }
                if (parent2 instanceof KtParameterList) {
                    PsiElement grandparent = ((KtParameterList)parent2).getParent();
                    return grandparent instanceof KtCatchClause || grandparent instanceof KtFunctionLiteral;
                }
            } else if (psiElement2 instanceof KtLabeledExpression || psiElement2 instanceof KtImportAlias) {
                return true;
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

