/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.compile;

import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetProgressIndicatorAdapter;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.PathsList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.core.KotlinCompilerIde;
import org.jetbrains.kotlin.idea.core.script.ScriptConfigurationManager;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.compile.KtCompilingExecutor;
import org.jetbrains.kotlin.idea.scratch.compile.KtScratchSourceFileProcessor;
import org.jetbrains.kotlin.idea.util.JavaParametersBuilder;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 12\u00020\u0001:\u00011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J6\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 J5\u0010!\u001a\u00020\u001e2\b\b\u0001\u0010\"\u001a\u00020\u00182!\u0010#\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020\u001e0$H\u0002J\u001e\u0010(\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u000b\u001a\u00020\fJL\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0002J\u0006\u0010/\u001a\u00020\u001eJ.\u00100\u001a\u00020\u001e2\u0006\u0010.\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession;", "", "file", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "executor", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;Lorg/jetbrains/kotlin/idea/scratch/compile/KtCompilingExecutor;)V", "backgroundProcessIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "compileFileToTempDir", "Ljava/io/File;", "psiFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "expressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "createCommandLine", "Lkotlin/Pair;", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "Lcom/intellij/execution/target/TargetedCommandLine;", "originalFile", "module", "Lcom/intellij/openapi/module/Module;", "mainClassName", "", "tempOutDir", "createFileWithLightClassSupport", "result", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result$OK;", "execute", "", "callback", "Lkotlin/Function0;", "executeInBackground", "title", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "indicator", "reportError", "e", "", "runCommandLine", "project", "Lcom/intellij/openapi/project/Project;", "modifiedScratchSourceFile", "stop", "tryRunCommandLine", "Companion", "kotlin.jvm"})
public final class KtScratchExecutionSession {
    private volatile ProgressIndicator backgroundProcessIndicator;
    private final ScratchFile file;
    private final KtCompilingExecutor executor;
    private static final int TIMEOUT_MS = 30000;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void execute(@NotNull Function0<Unit> callback2) {
        block3: {
            Intrinsics.checkNotNullParameter(callback2, (String)"callback");
            KtFile ktFile = this.file.getKtScratchFile();
            if (ktFile == null) {
                ScratchExecutor.errorOccurs$default(this.executor, KotlinJvmBundle.message("couldn.t.find.ktfile.for.current.editor", new Object[0]), null, true, 2, null);
                return;
            }
            KtFile psiFile2 = ktFile;
            List<ScratchExpression> expressions2 = this.file.getExpressions();
            if (!this.executor.checkForErrors(psiFile2, expressions2)) {
                return;
            }
            KtScratchSourceFileProcessor.Result result2 = (KtScratchSourceFileProcessor.Result)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtScratchSourceFileProcessor.Result>(expressions2){
                final /* synthetic */ List $expressions;

                @NotNull
                public final KtScratchSourceFileProcessor.Result invoke() {
                    return new KtScratchSourceFileProcessor().process(this.$expressions);
                }
                {
                    this.$expressions = list2;
                    super(0);
                }
            });
            if (result2 instanceof KtScratchSourceFileProcessor.Result.Error) {
                ScratchExecutor.errorOccurs$default(this.executor, ((KtScratchSourceFileProcessor.Result.Error)result2).getMessage(), null, true, 2, null);
                return;
            }
            if (!(result2 instanceof KtScratchSourceFileProcessor.Result.OK)) break block3;
            ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "After processing by KtScratchSourceFileProcessor:\n " + ((KtScratchSourceFileProcessor.Result.OK)result2).getCode());
            this.executeInBackground(KotlinJvmBundle.message("running.kotlin.scratch", new Object[0]), (Function1<? super ProgressIndicator, Unit>)((Function1)new Function1<ProgressIndicator, Unit>(this, result2, psiFile2, callback2){
                final /* synthetic */ KtScratchExecutionSession this$0;
                final /* synthetic */ KtScratchSourceFileProcessor.Result $result;
                final /* synthetic */ KtFile $psiFile;
                final /* synthetic */ Function0 $callback;

                public final void invoke(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    KtScratchExecutionSession.access$setBackgroundProcessIndicator$p(this.this$0, indicator);
                    KtFile modifiedScratchSourceFile = KtScratchExecutionSession.access$createFileWithLightClassSupport(this.this$0, (KtScratchSourceFileProcessor.Result.OK)this.$result, this.$psiFile);
                    KtScratchExecutionSession.access$tryRunCommandLine(this.this$0, modifiedScratchSourceFile, this.$psiFile, (KtScratchSourceFileProcessor.Result.OK)this.$result, this.$callback);
                }
                {
                    this.this$0 = ktScratchExecutionSession;
                    this.$result = result2;
                    this.$psiFile = ktFile;
                    this.$callback = function0;
                    super(1);
                }
            }));
        }
    }

    private final void executeInBackground(@NlsContexts.ProgressTitle String title, Function1<? super ProgressIndicator, Unit> block2) {
        new Task.Backgroundable(this, block2, title, this.file.getProject(), title, true){
            final /* synthetic */ KtScratchExecutionSession this$0;
            final /* synthetic */ Function1 $block;
            final /* synthetic */ String $title;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.$block.invoke((Object)indicator);
            }
            {
                this.this$0 = this$0;
                this.$block = $captured_local_variable$1;
                this.$title = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        }.queue();
    }

    private final KtFile createFileWithLightClassSupport(KtScratchSourceFileProcessor.Result.OK result2, KtFile psiFile2) {
        return (KtFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtFile>(this, result2, psiFile2){
            final /* synthetic */ KtScratchExecutionSession this$0;
            final /* synthetic */ KtScratchSourceFileProcessor.Result.OK $result;
            final /* synthetic */ KtFile $psiFile;

            @NotNull
            public final KtFile invoke() {
                return new KtPsiFactory(KtScratchExecutionSession.access$getFile$p(this.this$0).getProject(), false, 2, null).createFileWithLightClassSupport("tmp.kt", this.$result.getCode(), (PsiElement)this.$psiFile);
            }
            {
                this.this$0 = ktScratchExecutionSession;
                this.$result = oK;
                this.$psiFile = ktFile;
                super(0);
            }
        });
    }

    private final void tryRunCommandLine(KtFile modifiedScratchSourceFile, KtFile psiFile2, KtScratchSourceFileProcessor.Result.OK result2, Function0<Unit> callback2) {
        boolean bl = this.backgroundProcessIndicator != null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        try {
            Project project2 = this.file.getProject();
            List<ScratchExpression> list2 = this.file.getExpressions();
            ProgressIndicator progressIndicator = this.backgroundProcessIndicator;
            Intrinsics.checkNotNull((Object)progressIndicator);
            this.runCommandLine(project2, modifiedScratchSourceFile, list2, psiFile2, result2, progressIndicator, callback2);
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            this.reportError(result2, e, psiFile2);
        }
    }

    public final void reportError(@NotNull KtScratchSourceFileProcessor.Result.OK result2, @NotNull Throwable e, @NotNull KtFile psiFile2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), result2.getCode());
        String string = e.getMessage();
        if (string == null) {
            Object[] objectArray = new Object[1];
            String string2 = psiFile2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"psiFile.name");
            objectArray[0] = string2;
            string = KotlinJvmBundle.message("couldn.t.compile.0", objectArray);
        }
        this.executor.errorOccurs(string, e, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void runCommandLine(Project project2, KtFile modifiedScratchSourceFile, List<ScratchExpression> expressions2, KtFile psiFile2, KtScratchSourceFileProcessor.Result.OK result2, ProgressIndicator indicator, Function0<Unit> callback2) {
        File file2 = (File)DumbService.getInstance((Project)project2).runReadActionInSmartMode(new Computable(this, modifiedScratchSourceFile, expressions2){
            final /* synthetic */ KtScratchExecutionSession this$0;
            final /* synthetic */ KtFile $modifiedScratchSourceFile;
            final /* synthetic */ List $expressions;

            @Nullable
            public final File compute() {
                return KtScratchExecutionSession.access$compileFileToTempDir(this.this$0, this.$modifiedScratchSourceFile, this.$expressions);
            }
            {
                this.this$0 = ktScratchExecutionSession;
                this.$modifiedScratchSourceFile = ktFile;
                this.$expressions = list2;
            }
        });
        if (file2 == null) {
            return;
        }
        File tempDir2 = file2;
        try {
            void environmentRequest;
            Module module2 = this.file.getModule();
            String string = result2.getMainClassName();
            String string2 = tempDir2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tempDir.path");
            Pair<TargetEnvironmentRequest, TargetedCommandLine> pair = this.createCommandLine(psiFile2, module2, string, string2);
            TargetEnvironmentRequest targetEnvironmentRequest = (TargetEnvironmentRequest)pair.component1();
            TargetedCommandLine commandLine = (TargetedCommandLine)pair.component2();
            TargetEnvironment environment2 = environmentRequest.prepareEnvironment((TargetProgressIndicator)new TargetProgressIndicatorAdapter(indicator));
            String commandLinePresentation = commandLine.getCommandPresentation(environment2);
            Logger logger = ScratchUtilsKt.getLOG();
            String string3 = commandLinePresentation;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"commandLinePresentation");
            ScratchUtilsKt.printDebugMessage(logger, string3);
            CapturingProcessHandler processHandler = new CapturingProcessHandler(environment2.createProcess(commandLine, indicator), null, commandLinePresentation);
            ProcessOutput processOutput = processHandler.runProcessWithProgressIndicator(indicator, 30000);
            Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"processHandler.runProces\u2026or(indicator, TIMEOUT_MS)");
            ProcessOutput executionResult = processOutput;
            if (executionResult.isTimeout()) {
                ScratchExecutor.errorOccurs$default(this.executor, KotlinJvmBundle.message("couldn.t.get.scratch.execution.result.stopped.by.timeout.0.ms", 30000), null, false, 6, null);
            } else if (executionResult.isCancelled()) {
            } else {
                this.executor.parseOutput(executionResult, expressions2);
            }
        }
        finally {
            tempDir2.delete();
            callback2.invoke();
        }
    }

    public final void stop() {
        block0: {
            ProgressIndicator progressIndicator = this.backgroundProcessIndicator;
            if (progressIndicator == null) break block0;
            progressIndicator.cancel();
        }
    }

    private final File compileFileToTempDir(KtFile psiFile2, List<ScratchExpression> expressions2) {
        if (!this.executor.checkForErrors(psiFile2, expressions2)) {
            return null;
        }
        File file2 = FileUtil.createTempDirectory((String)"compile", (String)"scratch");
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"FileUtil.createTempDirectory(\"compile\", \"scratch\")");
        File tmpDir = file2;
        ScratchUtilsKt.printDebugMessage(ScratchUtilsKt.getLOG(), "Temp output dir: " + tmpDir.getPath());
        new KotlinCompilerIde(psiFile2, null, null, null, false, 30, null).compileToDirectory(tmpDir);
        return tmpDir;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<TargetEnvironmentRequest, TargetedCommandLine> createCommandLine(KtFile originalFile2, Module module2, String mainClassName, String tempOutDir) {
        WslTargetEnvironmentConfiguration wslTargetEnvironmentConfiguration;
        JavaParameters javaParameters;
        block7: {
            block6: {
                WslTargetEnvironmentConfiguration wslConfiguration;
                Project project2 = originalFile2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"originalFile.project");
                javaParameters = new JavaParametersBuilder(project2).withSdkFrom(module2, true).withMainClassName(mainClassName).build();
                javaParameters.getClassPath().add(tempOutDir);
                if (module2 != null) {
                    javaParameters.getClassPath().addAll(JavaParametersBuilder.Companion.getModuleDependencies(module2));
                }
                Project project3 = originalFile2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"originalFile.project");
                ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper = ScriptConfigurationManager.Companion.getInstance(project3).getConfiguration(originalFile2);
                if (scriptCompilationConfigurationWrapper != null) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    ScriptCompilationConfigurationWrapper scriptCompilationConfigurationWrapper2 = scriptCompilationConfigurationWrapper;
                    boolean bl = false;
                    boolean bl2 = false;
                    ScriptCompilationConfigurationWrapper it = scriptCompilationConfigurationWrapper2;
                    boolean bl3 = false;
                    Iterable iterable = it.getDependenciesClassPath();
                    PathsList pathsList = javaParameters.getClassPath();
                    boolean $i$f$map = false;
                    void var14_15 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void f2;
                        File file2 = (File)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl4 = false;
                        String string = f2.getAbsolutePath();
                        collection.add(string);
                    }
                    collection = (List)destination$iv$iv;
                    pathsList.addAll((List)collection);
                }
                if ((wslTargetEnvironmentConfiguration = (wslConfiguration = JavaCommandLineState.checkCreateWslConfiguration((Sdk)javaParameters.getJdk()))) == null) break block6;
                Project project4 = originalFile2.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"originalFile.project");
                if ((wslTargetEnvironmentConfiguration = wslTargetEnvironmentConfiguration.createEnvironmentRequest(project4)) != null) break block7;
            }
            wslTargetEnvironmentConfiguration = (TargetEnvironmentRequest)new LocalTargetEnvironmentRequest();
        }
        WslTargetEnvironmentConfiguration request2 = wslTargetEnvironmentConfiguration;
        TargetedCommandLine targetedCommandLine = javaParameters.toCommandLine((TargetEnvironmentRequest)request2).build();
        Intrinsics.checkNotNullExpressionValue((Object)targetedCommandLine, (String)"javaParameters.toCommandLine(request).build()");
        return TuplesKt.to((Object)request2, (Object)targetedCommandLine);
    }

    public KtScratchExecutionSession(@NotNull ScratchFile file2, @NotNull KtCompilingExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.file = file2;
        this.executor = executor;
    }

    public static final /* synthetic */ ProgressIndicator access$getBackgroundProcessIndicator$p(KtScratchExecutionSession $this) {
        return $this.backgroundProcessIndicator;
    }

    public static final /* synthetic */ void access$setBackgroundProcessIndicator$p(KtScratchExecutionSession $this, ProgressIndicator progressIndicator) {
        $this.backgroundProcessIndicator = progressIndicator;
    }

    public static final /* synthetic */ KtFile access$createFileWithLightClassSupport(KtScratchExecutionSession $this, KtScratchSourceFileProcessor.Result.OK result2, KtFile psiFile2) {
        return $this.createFileWithLightClassSupport(result2, psiFile2);
    }

    public static final /* synthetic */ void access$tryRunCommandLine(KtScratchExecutionSession $this, KtFile modifiedScratchSourceFile, KtFile psiFile2, KtScratchSourceFileProcessor.Result.OK result2, Function0 callback2) {
        $this.tryRunCommandLine(modifiedScratchSourceFile, psiFile2, result2, (Function0<Unit>)callback2);
    }

    public static final /* synthetic */ ScratchFile access$getFile$p(KtScratchExecutionSession $this) {
        return $this.file;
    }

    public static final /* synthetic */ File access$compileFileToTempDir(KtScratchExecutionSession $this, KtFile psiFile2, List expressions2) {
        return $this.compileFileToTempDir(psiFile2, expressions2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchExecutionSession$Companion;", "", "()V", "TIMEOUT_MS", "", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

