/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.compile;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.compile.KtScratchSourceFileProcessor;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \b2\u00020\u0001:\u0003\b\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor;", "", "()V", "process", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result;", "expressions", "", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "Companion", "KtSourceProcessor", "Result", "kotlin.jvm"})
public final class KtScratchSourceFileProcessor {
    @NotNull
    public static final String GENERATED_OUTPUT_PREFIX = "##scratch##generated##";
    @NotNull
    public static final String LINES_INFO_MARKER = "end##";
    @NotNull
    public static final String END_OUTPUT_MARKER = "end##!@#%^&*";
    @NotNull
    public static final String OBJECT_NAME = "ScratchFileRunnerGenerated";
    @NotNull
    public static final String INSTANCE_NAME = "instanceScratchFileRunner";
    @NotNull
    public static final String PACKAGE_NAME = "org.jetbrains.kotlin.idea.scratch.generated";
    @NotNull
    public static final String GET_RES_FUN_NAME_PREFIX = "generated_get_instance_res";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Result process(@NotNull List<ScratchExpression> expressions2) {
        Intrinsics.checkNotNullParameter(expressions2, (String)"expressions");
        KtSourceProcessor sourceProcessor = new KtSourceProcessor();
        Iterable $this$forEach$iv = expressions2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScratchExpression it = (ScratchExpression)element$iv;
            boolean bl = false;
            sourceProcessor.process(it);
        }
        String codeResult2 = "\n                package org.jetbrains.kotlin.idea.scratch.generated\n\n                " + CollectionsKt.joinToString$default((Iterable)sourceProcessor.getImports(), (CharSequence)"\n", null, null, (int)0, null, (Function1)process.codeResult.1.INSTANCE, (int)30, null) + "\n\n                object ScratchFileRunnerGenerated {\n                    class ScratchFileRunnerGenerated {\n                        " + sourceProcessor.getClassBuilder() + "\n                    }\n\n                    @JvmStatic fun main(args: Array<String>) {\n                        val instanceScratchFileRunner = ScratchFileRunnerGenerated()\n                        " + sourceProcessor.getObjectBuilder() + "\n                        println(\"end##!@#%^&*\")\n                    }\n                }\n            ";
        return new Result.OK("org.jetbrains.kotlin.idea.scratch.generated.ScratchFileRunnerGenerated", codeResult2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u0013*\u00060\u0004j\u0002`\u00052\u0006\u0010\u0017\u001a\u00020\u0015H\u0002J\u0018\u0010 \u001a\n !*\u0004\u0018\u00010\u00040\u0004*\u00060\u0004j\u0002`\u0005H\u0002J \u0010\"\u001a\n !*\u0004\u0018\u00010\u00040\u0004*\u00060\u0004j\u0002`\u00052\u0006\u0010#\u001a\u00020$H\u0002J \u0010%\u001a\n !*\u0004\u0018\u00010\u00040\u0004*\u00060\u0004j\u0002`\u00052\u0006\u0010#\u001a\u00020$H\u0002R\u0015\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0015\u0010\u000e\u001a\u00060\u0004j\u0002`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$KtSourceProcessor;", "", "()V", "classBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "getClassBuilder", "()Ljava/lang/StringBuilder;", "imports", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/psi/KtImportDirective;", "Lkotlin/collections/ArrayList;", "getImports", "()Ljava/util/ArrayList;", "objectBuilder", "getObjectBuilder", "resCount", "", "process", "", "expression", "Lorg/jetbrains/kotlin/idea/scratch/ScratchExpression;", "processDeclaration", "e", "c", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "processDestructuringDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "processExpression", "expr", "Lorg/jetbrains/kotlin/psi/KtExpression;", "appendLineInfo", "newLine", "kotlin.jvm.PlatformType", "println", "str", "", "printlnObj", "kotlin.jvm"})
    public static final class KtSourceProcessor {
        @NotNull
        private final StringBuilder classBuilder = new StringBuilder();
        @NotNull
        private final StringBuilder objectBuilder = new StringBuilder();
        @NotNull
        private final ArrayList<KtImportDirective> imports;
        private int resCount;

        @NotNull
        public final StringBuilder getClassBuilder() {
            return this.classBuilder;
        }

        @NotNull
        public final StringBuilder getObjectBuilder() {
            return this.objectBuilder;
        }

        @NotNull
        public final ArrayList<KtImportDirective> getImports() {
            return this.imports;
        }

        public final void process(@NotNull ScratchExpression expression2) {
            block1: {
                PsiElement psiElement2;
                PsiElement psiElement3;
                block5: {
                    block4: {
                        block3: {
                            block2: {
                                block0: {
                                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                                    psiElement2 = psiElement3 = expression2.getElement();
                                    if (!(psiElement2 instanceof KtDestructuringDeclaration)) break block0;
                                    this.processDestructuringDeclaration(expression2, (KtDestructuringDeclaration)psiElement3);
                                    break block1;
                                }
                                if (!(psiElement2 instanceof KtVariableDeclaration)) break block2;
                                this.processDeclaration(expression2, (KtDeclaration)psiElement3);
                                break block1;
                            }
                            if (!(psiElement2 instanceof KtFunction)) break block3;
                            this.processDeclaration(expression2, (KtDeclaration)psiElement3);
                            break block1;
                        }
                        if (!(psiElement2 instanceof KtClassOrObject)) break block4;
                        this.processDeclaration(expression2, (KtDeclaration)psiElement3);
                        break block1;
                    }
                    if (!(psiElement2 instanceof KtImportDirective)) break block5;
                    this.imports.add((KtImportDirective)psiElement3);
                    break block1;
                }
                if (!(psiElement2 instanceof KtExpression)) break block1;
                this.processExpression(expression2, (KtExpression)psiElement3);
            }
        }

        private final void processDeclaration(ScratchExpression e, KtDeclaration c) {
            StringBuilder stringBuilder = this.classBuilder.append(c.getText());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"classBuilder.append(c.text)");
            this.newLine(stringBuilder);
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)c, null, (int)1, null);
            if (declarationDescriptor == null) {
                return;
            }
            DeclarationDescriptor descriptor2 = declarationDescriptor;
            RenderingContext context2 = RenderingContext.Companion.of(new Object[]{descriptor2});
            this.println(this.objectBuilder, Renderers.COMPACT.render(descriptor2, context2));
            this.appendLineInfo(this.objectBuilder, e);
        }

        /*
         * WARNING - void declaration
         */
        private final void processDestructuringDeclaration(ScratchExpression e, KtDestructuringDeclaration c) {
            void $this$mapNotNullTo$iv$iv;
            List list2 = c.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"c.entries");
            Iterable $this$mapNotNull$iv = list2;
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                DeclarationDescriptor declarationDescriptor;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtDestructuringDeclarationEntry it = (KtDestructuringDeclarationEntry)element$iv$iv;
                boolean bl2 = false;
                KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktDestructuringDeclarationEntry, (String)"it");
                if ((UnderscoreUtilKt.isSingleUnderscore((KtNamedDeclaration)((KtNamedDeclaration)ktDestructuringDeclarationEntry)) ? null : ResolutionUtils.resolveToDescriptorIfAny$default((KtDeclaration)((KtDeclaration)it), null, (int)1, null)) == null) continue;
                declarationDescriptor = declarationDescriptor;
                boolean bl3 = false;
                boolean bl4 = false;
                DeclarationDescriptor it$iv$iv = declarationDescriptor;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List entries = (List)destination$iv$iv;
            Iterable $this$forEach$iv = entries;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                boolean bl = false;
                RenderingContext context2 = RenderingContext.Companion.of(new Object[]{it});
                String rendered2 = Renderers.COMPACT.render(it, context2);
                StringBuilder stringBuilder = this.classBuilder.append(rendered2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"classBuilder.append(rendered)");
                this.newLine(stringBuilder);
                this.println(this.objectBuilder, rendered2);
            }
            this.appendLineInfo(this.objectBuilder, e);
            StringBuilder stringBuilder = this.classBuilder.append("init {");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"classBuilder.append(\"init {\")");
            this.newLine(stringBuilder);
            StringBuilder stringBuilder2 = this.classBuilder.append(c.getText());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"classBuilder.append(c.text)");
            this.newLine(stringBuilder2);
            $this$forEach$iv = entries;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                boolean bl = false;
                StringBuilder stringBuilder3 = this.classBuilder.append("this." + it.getName() + " = " + it.getName());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"classBuilder.append(\"thi\u2026${it.name} = ${it.name}\")");
                this.newLine(stringBuilder3);
            }
            StringBuilder stringBuilder4 = this.classBuilder.append("}");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"classBuilder.append(\"}\")");
            this.newLine(stringBuilder4);
        }

        private final void processExpression(ScratchExpression e, KtExpression expr2) {
            String resName = KtScratchSourceFileProcessor.GET_RES_FUN_NAME_PREFIX + this.resCount;
            StringBuilder stringBuilder = this.classBuilder.append("fun " + resName + "() = run { " + expr2.getText() + " }");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"classBuilder.append(\"fun\u2026 = run { ${expr.text} }\")");
            this.newLine(stringBuilder);
            this.printlnObj(this.objectBuilder, "instanceScratchFileRunner." + resName + "()");
            this.appendLineInfo(this.objectBuilder, e);
            ++this.resCount;
        }

        private final void appendLineInfo(StringBuilder $this$appendLineInfo, ScratchExpression e) {
            this.println($this$appendLineInfo, KtScratchSourceFileProcessor.LINES_INFO_MARKER + e.getLineStart() + '|' + e.getLineEnd());
        }

        private final StringBuilder println(StringBuilder $this$println, String str) {
            StringBuilder stringBuilder = $this$println.append("println(\"##scratch##generated##" + str + "\")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(\"println(\\\"$GENER\u2026ED_OUTPUT_PREFIX$str\\\")\")");
            return this.newLine(stringBuilder);
        }

        private final StringBuilder printlnObj(StringBuilder $this$printlnObj, String str) {
            StringBuilder stringBuilder = $this$printlnObj.append("println(\"##scratch##generated##${" + str + "}\")");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(\"println(\\\"$GENER\u2026UTPUT_PREFIX\\${$str}\\\")\")");
            return this.newLine(stringBuilder);
        }

        private final StringBuilder newLine(StringBuilder $this$newLine) {
            return $this$newLine.append("\n");
        }

        public KtSourceProcessor() {
            boolean bl = false;
            this.imports = new ArrayList();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result;", "", "()V", "Error", "OK", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result$Error;", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result$OK;", "kotlin.jvm"})
    public static abstract class Result {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result$Error;", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result;", "message", "", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "kotlin.jvm"})
        public static final class Error
        extends Result {
            @NotNull
            private final String message;

            @NotNull
            public final String getMessage() {
                return this.message;
            }

            public Error(@NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                super(null);
                this.message = message2;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result$OK;", "Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Result;", "mainClassName", "", "code", "(Ljava/lang/String;Ljava/lang/String;)V", "getCode", "()Ljava/lang/String;", "getMainClassName", "kotlin.jvm"})
        public static final class OK
        extends Result {
            @NotNull
            private final String mainClassName;
            @NotNull
            private final String code;

            @NotNull
            public final String getMainClassName() {
                return this.mainClassName;
            }

            @NotNull
            public final String getCode() {
                return this.code;
            }

            public OK(@NotNull String mainClassName, @NotNull String code) {
                Intrinsics.checkNotNullParameter((Object)mainClassName, (String)"mainClassName");
                Intrinsics.checkNotNullParameter((Object)code, (String)"code");
                super(null);
                this.mainClassName = mainClassName;
                this.code = code;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/compile/KtScratchSourceFileProcessor$Companion;", "", "()V", "END_OUTPUT_MARKER", "", "GENERATED_OUTPUT_PREFIX", "GET_RES_FUN_NAME_PREFIX", "INSTANCE_NAME", "LINES_INFO_MARKER", "OBJECT_NAME", "PACKAGE_NAME", "kotlin.jvm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

