/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch.ui;

import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.TextEditorWithPreview;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.scratch.ScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.ScratchExpression;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchFileAutoRunner;
import org.jetbrains.kotlin.idea.scratch.SequentialScratchExecutor;
import org.jetbrains.kotlin.idea.scratch.output.InlayScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.PreviewEditorScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.PreviewOutputBlocksManager;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputBlock;
import org.jetbrains.kotlin.idea.scratch.output.ScratchOutputHandler;
import org.jetbrains.kotlin.idea.scratch.output.ToolWindowScratchOutputHandlerKt;
import org.jetbrains.kotlin.idea.scratch.ui.KtScratchFileEditorProviderKt;
import org.jetbrains.kotlin.idea.scratch.ui.LayoutDependantOutputHandler;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchEditorLinesTranslator;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchEditorSyncHighlighterKt;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchTopPanel;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 :2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001:B\u001f\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001fH\u0002J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020\u001fH\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020+H\u0014J\b\u0010,\u001a\u00020+H\u0014J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001c\u0010.\u001a\u00020\u001f2\b\u0010/\u001a\u0004\u0018\u0001002\b\u00101\u001a\u0004\u0018\u000100H\u0014J\u001e\u00102\u001a\u0010\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000204\u0018\u0001032\u0006\u00105\u001a\u000204H\u0016J\u0010\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\u001bH\u0007J\u001e\u00108\u001a\u0010\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u000204\u0018\u0001032\u0006\u00109\u001a\u000204H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/KtScratchFileEditorWithPreview;", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview;", "Lcom/intellij/openapi/fileEditor/TextEditor;", "Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchEditorLinesTranslator;", "scratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "sourceTextEditor", "previewTextEditor", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;Lcom/intellij/openapi/fileEditor/TextEditor;Lcom/intellij/openapi/fileEditor/TextEditor;)V", "commonPreviewOutputHandler", "Lorg/jetbrains/kotlin/idea/scratch/ui/LayoutDependantOutputHandler;", "inlayScratchOutputHandler", "Lorg/jetbrains/kotlin/idea/scratch/output/InlayScratchOutputHandler;", "previewEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "previewEditorScratchOutputHandler", "Lorg/jetbrains/kotlin/idea/scratch/output/PreviewEditorScratchOutputHandler;", "previewOutputManager", "Lorg/jetbrains/kotlin/idea/scratch/output/PreviewOutputBlocksManager;", "getScratchFile", "()Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "scratchTopPanel", "Lorg/jetbrains/kotlin/idea/scratch/ui/ScratchTopPanel;", "sourceEditor", "toolWindowHandler", "Lorg/jetbrains/kotlin/idea/scratch/output/ScratchOutputHandler;", "canNavigateTo", "", "navigatable", "Lcom/intellij/pom/Navigatable;", "clearOutputHandlers", "", "configureSyncScrollForSourceAndPreview", "createToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "createViewActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "dispose", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getShowEditorAction", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "getShowEditorAndPreviewAction", "navigateTo", "onLayoutChange", "oldValue", "Lcom/intellij/openapi/fileEditor/TextEditorWithPreview$Layout;", "newValue", "previewLineToSourceLines", "Lkotlin/Pair;", "", "previewLine", "setPreviewEnabled", "isPreviewEnabled", "sourceLineToPreviewLines", "sourceLine", "Companion", "kotlin.jvm"})
public final class KtScratchFileEditorWithPreview
extends TextEditorWithPreview
implements TextEditor,
ScratchEditorLinesTranslator {
    private final EditorEx sourceEditor;
    private final EditorEx previewEditor;
    private final PreviewOutputBlocksManager previewOutputManager;
    private final ScratchOutputHandler toolWindowHandler;
    private final InlayScratchOutputHandler inlayScratchOutputHandler;
    private final PreviewEditorScratchOutputHandler previewEditorScratchOutputHandler;
    private final LayoutDependantOutputHandler commonPreviewOutputHandler;
    private final ScratchTopPanel scratchTopPanel;
    @NotNull
    private final ScratchFile scratchFile;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public VirtualFile getFile() {
        return this.scratchFile.getFile();
    }

    @Override
    @Nullable
    public Pair<Integer, Integer> previewLineToSourceLines(int previewLine) {
        ScratchExpression scratchExpression = this.scratchFile.getExpressionAtLine(previewLine);
        if (scratchExpression == null) {
            return null;
        }
        ScratchExpression expressionUnderCaret = scratchExpression;
        ScratchOutputBlock scratchOutputBlock = this.previewOutputManager.getBlock(expressionUnderCaret);
        if (scratchOutputBlock == null) {
            return null;
        }
        ScratchOutputBlock outputBlock = scratchOutputBlock;
        return TuplesKt.to((Object)outputBlock.getLineStart(), (Object)outputBlock.getLineEnd());
    }

    @Override
    @Nullable
    public Pair<Integer, Integer> sourceLineToPreviewLines(int sourceLine) {
        ScratchOutputBlock scratchOutputBlock = this.previewOutputManager.getBlockAtLine(sourceLine);
        if (scratchOutputBlock == null) {
            return null;
        }
        ScratchOutputBlock block2 = scratchOutputBlock;
        if (!KtScratchFileEditorProviderKt.access$linesInformationIsCorrect(block2.getSourceExpression())) {
            return null;
        }
        return TuplesKt.to((Object)block2.getSourceExpression().getLineStart(), (Object)block2.getSourceExpression().getLineEnd());
    }

    private final void configureSyncScrollForSourceAndPreview() {
        BaseSyncScrollable scrollable2 = new BaseSyncScrollable(this){
            final /* synthetic */ KtScratchFileEditorWithPreview this$0;

            /*
             * WARNING - void declaration
             */
            protected void processHelper(@NotNull BaseSyncScrollable.ScrollHelper helper2) {
                Intrinsics.checkNotNullParameter((Object)helper2, (String)"helper");
                if (!helper2.process(0, 0)) {
                    return;
                }
                List<Pair<Integer, Integer>> alignments = KtScratchFileEditorWithPreview.access$getPreviewOutputManager$p(this.this$0).computeSourceToPreviewAlignments();
                for (Pair<Integer, Integer> pair : alignments) {
                    void fromSource;
                    int n = ((Number)pair.component1()).intValue();
                    int fromPreview = ((Number)pair.component2()).intValue();
                    if (!helper2.process((int)fromSource, fromPreview)) {
                        return;
                    }
                    if (helper2.process((int)fromSource, fromPreview)) continue;
                    return;
                }
                DocumentEx documentEx = KtScratchFileEditorWithPreview.access$getSourceEditor$p(this.this$0).getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"sourceEditor.document");
                int n = documentEx.getLineCount();
                DocumentEx documentEx2 = KtScratchFileEditorWithPreview.access$getPreviewEditor$p(this.this$0).getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)documentEx2, (String)"previewEditor.document");
                helper2.process(n, documentEx2.getLineCount());
            }

            public boolean isSyncScrollEnabled() {
                return true;
            }
            {
                this.this$0 = this$0;
            }
        };
        SyncScrollSupport.TwosideSyncScrollSupport scrollSupport = new SyncScrollSupport.TwosideSyncScrollSupport(CollectionsKt.listOf((Object[])new EditorEx[]{this.sourceEditor, this.previewEditor}), (SyncScrollSupport.SyncScrollable)scrollable2);
        VisibleAreaListener listener2 = new VisibleAreaListener(scrollSupport){
            final /* synthetic */ SyncScrollSupport.TwosideSyncScrollSupport $scrollSupport;

            public final void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$scrollSupport.visibleAreaChanged(e);
            }
            {
                this.$scrollSupport = twosideSyncScrollSupport;
            }
        };
        this.sourceEditor.getScrollingModel().addVisibleAreaListener(listener2);
        this.previewEditor.getScrollingModel().addVisibleAreaListener(listener2);
    }

    public void dispose() {
        SequentialScratchExecutor sequentialScratchExecutor = this.scratchFile.getReplScratchExecutor();
        if (sequentialScratchExecutor != null) {
            sequentialScratchExecutor.stop();
        }
        ScratchExecutor scratchExecutor = this.scratchFile.getCompilingScratchExecutor();
        if (scratchExecutor != null) {
            scratchExecutor.stop();
        }
        ToolWindowScratchOutputHandlerKt.releaseToolWindowHandler(this.toolWindowHandler);
        super.dispose();
    }

    public void navigateTo(@NotNull Navigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        this.myEditor.navigateTo(navigatable);
    }

    public boolean canNavigateTo(@NotNull Navigatable navigatable) {
        Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
        return this.myEditor.canNavigateTo(navigatable);
    }

    @NotNull
    public Editor getEditor() {
        TextEditor textEditor = this.myEditor;
        Intrinsics.checkNotNullExpressionValue((Object)textEditor, (String)"myEditor");
        Editor editor2 = textEditor.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"myEditor.editor");
        return editor2;
    }

    @NotNull
    protected ActionToolbar createToolbar() {
        return this.scratchTopPanel.getActionsToolbar();
    }

    public final void clearOutputHandlers() {
        this.commonPreviewOutputHandler.clear(this.scratchFile);
    }

    @NotNull
    protected ActionGroup createViewActionGroup() {
        return (ActionGroup)new DefaultActionGroup(new AnAction[]{(AnAction)this.getShowEditorAction(), (AnAction)this.getShowEditorAndPreviewAction()});
    }

    @NotNull
    protected ToggleAction getShowEditorAction() {
        ToggleAction toggleAction = super.getShowEditorAction();
        Intrinsics.checkNotNullExpressionValue((Object)toggleAction, (String)"super.getShowEditorAction()");
        ToggleAction toggleAction2 = toggleAction;
        boolean bl = false;
        boolean bl2 = false;
        ToggleAction $this$apply = toggleAction2;
        boolean bl3 = false;
        Presentation presentation = $this$apply.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"templatePresentation");
        presentation.setText(KotlinJvmBundle.message("scratch.inlay.output.mode.title", new Object[0]));
        Presentation presentation2 = $this$apply.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"templatePresentation");
        presentation2.setDescription(KotlinJvmBundle.message("scratch.inlay.output.mode.description", new Object[0]));
        return toggleAction2;
    }

    @NotNull
    protected ToggleAction getShowEditorAndPreviewAction() {
        ToggleAction toggleAction = super.getShowEditorAndPreviewAction();
        Intrinsics.checkNotNullExpressionValue((Object)toggleAction, (String)"super.getShowEditorAndPreviewAction()");
        ToggleAction toggleAction2 = toggleAction;
        boolean bl = false;
        boolean bl2 = false;
        ToggleAction $this$apply = toggleAction2;
        boolean bl3 = false;
        Presentation presentation = $this$apply.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"templatePresentation");
        presentation.setText(KotlinJvmBundle.message("scratch.side.panel.output.mode.title", new Object[0]));
        Presentation presentation2 = $this$apply.getTemplatePresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"templatePresentation");
        presentation2.setDescription(KotlinJvmBundle.message("scratch.side.panel.output.mode.description", new Object[0]));
        return toggleAction2;
    }

    protected void onLayoutChange(@Nullable TextEditorWithPreview.Layout oldValue, @Nullable TextEditorWithPreview.Layout newValue2) {
        block0: {
            if (oldValue == newValue2) break block0;
            this.clearOutputHandlers();
        }
    }

    @TestOnly
    public final void setPreviewEnabled(boolean isPreviewEnabled) {
        this.setLayout(isPreviewEnabled ? TextEditorWithPreview.Layout.SHOW_EDITOR_AND_PREVIEW : TextEditorWithPreview.Layout.SHOW_EDITOR);
    }

    @NotNull
    public final ScratchFile getScratchFile() {
        return this.scratchFile;
    }

    private KtScratchFileEditorWithPreview(ScratchFile scratchFile, TextEditor sourceTextEditor, TextEditor previewTextEditor) {
        super(sourceTextEditor, (FileEditor)previewTextEditor);
        this.scratchFile = scratchFile;
        Editor editor2 = sourceTextEditor.getEditor();
        if (editor2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        }
        this.sourceEditor = (EditorEx)editor2;
        Editor editor3 = previewTextEditor.getEditor();
        if (editor3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        }
        this.previewEditor = (EditorEx)editor3;
        this.previewOutputManager = new PreviewOutputBlocksManager((Editor)this.previewEditor);
        this.toolWindowHandler = ToolWindowScratchOutputHandlerKt.requestToolWindowHandler();
        this.inlayScratchOutputHandler = new InlayScratchOutputHandler(sourceTextEditor, this.toolWindowHandler);
        TextEditor textEditor = previewTextEditor;
        if (textEditor == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.Disposable");
        }
        this.previewEditorScratchOutputHandler = new PreviewEditorScratchOutputHandler(this.previewOutputManager, this.toolWindowHandler, (Disposable)textEditor);
        this.commonPreviewOutputHandler = new LayoutDependantOutputHandler(this.inlayScratchOutputHandler, this.previewEditorScratchOutputHandler, (Function0<? extends TextEditorWithPreview.Layout>)((Function0)new Function0<TextEditorWithPreview.Layout>(this){

            public final TextEditorWithPreview.Layout invoke() {
                return ((KtScratchFileEditorWithPreview)this.receiver).getLayout();
            }
        }));
        this.scratchTopPanel = new ScratchTopPanel(this.scratchFile);
        KtScratchFileEditorProviderKt.access$setParentScratchEditorWithPreview$p(sourceTextEditor, this);
        KtScratchFileEditorProviderKt.access$setParentScratchEditorWithPreview$p(previewTextEditor, this);
        ScratchExecutor scratchExecutor = this.scratchFile.getCompilingScratchExecutor();
        if (scratchExecutor != null) {
            scratchExecutor.addOutputHandler(this.commonPreviewOutputHandler);
        }
        SequentialScratchExecutor sequentialScratchExecutor = this.scratchFile.getReplScratchExecutor();
        if (sequentialScratchExecutor != null) {
            sequentialScratchExecutor.addOutputHandler(this.commonPreviewOutputHandler);
        }
        this.configureSyncScrollForSourceAndPreview();
        ScratchEditorSyncHighlighterKt.configureSyncHighlighting(this.sourceEditor, this.previewEditor, this);
        ScratchFileAutoRunner.Companion.addListener(this.scratchFile.getProject(), sourceTextEditor);
    }

    public static final /* synthetic */ PreviewOutputBlocksManager access$getPreviewOutputManager$p(KtScratchFileEditorWithPreview $this) {
        return $this.previewOutputManager;
    }

    public static final /* synthetic */ EditorEx access$getSourceEditor$p(KtScratchFileEditorWithPreview $this) {
        return $this.sourceEditor;
    }

    public static final /* synthetic */ EditorEx access$getPreviewEditor$p(KtScratchFileEditorWithPreview $this) {
        return $this.previewEditor;
    }

    public /* synthetic */ KtScratchFileEditorWithPreview(ScratchFile scratchFile, TextEditor sourceTextEditor, TextEditor previewTextEditor, DefaultConstructorMarker $constructor_marker) {
        this(scratchFile, sourceTextEditor, previewTextEditor);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ui/KtScratchFileEditorWithPreview$Companion;", "", "()V", "create", "Lorg/jetbrains/kotlin/idea/scratch/ui/KtScratchFileEditorWithPreview;", "scratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "kotlin.jvm"})
    public static final class Companion {
        @NotNull
        public final KtScratchFileEditorWithPreview create(@NotNull ScratchFile scratchFile) {
            Intrinsics.checkNotNullParameter((Object)scratchFile, (String)"scratchFile");
            TextEditorProvider textEditorProvider = TextEditorProvider.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)textEditorProvider, (String)"TextEditorProvider.getInstance()");
            TextEditorProvider textEditorProvider2 = textEditorProvider;
            FileEditor fileEditor = textEditorProvider2.createEditor(scratchFile.getProject(), scratchFile.getFile());
            if (fileEditor == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
            }
            TextEditor mainEditor = (TextEditor)fileEditor;
            EditorFactory editorFactory = EditorFactory.getInstance();
            Editor viewer = editorFactory.createViewer(editorFactory.createDocument((CharSequence)""), scratchFile.getProject(), EditorKind.PREVIEW);
            Disposer.register((Disposable)((Disposable)mainEditor), (Disposable)new Disposable(editorFactory, viewer){
                final /* synthetic */ EditorFactory $editorFactory;
                final /* synthetic */ Editor $viewer;

                public final void dispose() {
                    this.$editorFactory.releaseEditor(this.$viewer);
                }
                {
                    this.$editorFactory = editorFactory;
                    this.$viewer = editor2;
                }
            });
            TextEditor textEditor = textEditorProvider2.getTextEditor(viewer);
            Intrinsics.checkNotNullExpressionValue((Object)textEditor, (String)"textEditorProvider.getTextEditor(viewer)");
            TextEditor previewEditor = textEditor;
            return new KtScratchFileEditorWithPreview(scratchFile, mainEditor, previewEditor, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

