/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa;

import com.jetbrains.sa.SaJdwpUtils;
import com.jetbrains.sa.jdi.VirtualMachineImpl;
import com.jetbrains.sa.jdwp.JDWPProxy;
import com.sun.jdi.connect.spi.Connection;
import com.sun.jdi.connect.spi.TransportService;
import com.sun.tools.jdi.SocketTransportService;
import java.io.IOException;

public class SaJdwpListeningServer {
    static final String WAITING_FOR_DEBUGGER = "Waiting for debugger on: ";

    private SaJdwpListeningServer() {
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("sun.jvm.hotspot.debugger.useWindbgDebugger", "true");
        final VirtualMachineImpl vm = SaJdwpUtils.createVirtualMachine(args[0]);
        final SocketTransportService socketTransportService = new SocketTransportService();
        final TransportService.ListenKey listenKey = socketTransportService.startListening(args.length > 1 ? args[1] : null);
        System.err.println(WAITING_FOR_DEBUGGER + listenKey.address());
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    vm.dispose();
                    socketTransportService.stopListening(listenKey);
                }
                catch (IllegalArgumentException ignored) {
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }));
        Connection connection = socketTransportService.accept(listenKey, 0L, 0L);
        socketTransportService.stopListening(listenKey);
        JDWPProxy.reply(connection, vm);
    }
}

