/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mercury.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.mercury.artifact.ArtifactCoordinates;
import org.apache.maven.mercury.artifact.ArtifactScopeEnum;
import org.apache.maven.mercury.artifact.Quality;
import org.apache.maven.mercury.artifact.version.DefaultArtifactVersion;
import org.apache.maven.mercury.artifact.version.VersionException;
import org.apache.maven.mercury.artifact.version.VersionRange;
import org.apache.maven.mercury.artifact.version.VersionRangeFactory;
import org.codehaus.plexus.lang.DefaultLanguage;
import org.codehaus.plexus.lang.Language;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactMetadata {
    public static final String DEFAULT_ARTIFACT_TYPE = "jar";
    private static final Language LANG = new DefaultLanguage(ArtifactMetadata.class);
    protected String groupId;
    protected String artifactId;
    private String version;
    private transient VersionRange versionRange;
    private Quality quality;
    protected List<ArtifactCoordinates> relocations;
    protected ArtifactCoordinates effectiveCoordinates;
    protected String classifier;
    protected String type = "jar";
    protected ArtifactScopeEnum artifactScope;
    protected String scope;
    protected boolean optional;
    protected Collection<ArtifactMetadata> inclusions;
    protected Collection<ArtifactMetadata> exclusions;
    protected Map<String, String> attributes;
    transient Object tracker;
    transient Boolean local = false;
    transient Object datum;
    protected List<ArtifactMetadata> dependencies;
    protected String artifactUri;

    public ArtifactMetadata() {
    }

    private void processAttributes(String as) {
        String[] entries;
        if (as == null || as.length() < 1) {
            return;
        }
        String attrString = as.trim();
        if (attrString == null || attrString.length() < 1) {
            return;
        }
        int fromCh = attrString.indexOf(123);
        int toCh = attrString.indexOf(125);
        if (fromCh != -1 && toCh != -1) {
            attrString = attrString.substring(fromCh + 1, toCh);
        }
        if ((entries = attrString.split(",")) != null) {
            for (int i = 0; i < entries.length; ++i) {
                String name;
                int eq;
                String e = entries[i];
                if (e == null || (eq = e.indexOf(61)) == -1) continue;
                if (this.attributes == null) {
                    this.attributes = new LinkedHashMap<String, String>(entries.length);
                }
                if ((name = e.substring(0, eq)) == null) continue;
                name = name.trim();
                String val = e.substring(eq + 1);
                if (val != null) {
                    val = val.trim();
                }
                this.attributes.put(name, val);
            }
        }
    }

    public ArtifactMetadata(String gavQuery) {
        if (gavQuery == null) {
            return;
        }
        String[] tokens = gavQuery.split(":");
        if (tokens == null || tokens.length < 1) {
            return;
        }
        int count = tokens.length;
        this.groupId = ArtifactMetadata.nullify(tokens[0]);
        if (count > 1) {
            this.artifactId = ArtifactMetadata.nullify(tokens[1]);
        }
        if (count > 2) {
            this.version = ArtifactMetadata.nullify(tokens[2]);
        }
        if (count > 3) {
            this.classifier = ArtifactMetadata.nullify(tokens[3]);
        }
        if (count > 4) {
            this.setType(ArtifactMetadata.nullify(tokens[4]));
        }
        if (this.type == null || this.type.length() < 1) {
            this.type = DEFAULT_ARTIFACT_TYPE;
        }
        if (count > 5) {
            this.scope = ArtifactMetadata.nullify(tokens[5]);
        }
        if (count > 6) {
            this.processAttributes(ArtifactMetadata.nullify(tokens[6]));
        }
    }

    public ArtifactMetadata(ArtifactMetadata copyFrom) {
        if (copyFrom == null) {
            throw new IllegalArgumentException(LANG.getMessage("null.copy.from.md", new String[0]));
        }
        this.setGroupId(copyFrom.getGroupId());
        this.setArtifactId(copyFrom.getArtifactId());
        this.setVersion(copyFrom.getVersion());
        this.setClassifier(copyFrom.getClassifier());
        this.setType(copyFrom.getType());
        this.setScope(copyFrom.getScope());
        Map<String, String> a = copyFrom.getAttributes();
        if (a != null && a.size() > 0) {
            this.attributes = new HashMap<String, String>(a.size());
            this.attributes.putAll(a);
        }
        this.setTracker(copyFrom.getTracker());
    }

    public static ArtifactMetadata create(String query) {
        ArtifactMetadata mdq = new ArtifactMetadata(query);
        return mdq;
    }

    private static final String nullify(String s) {
        if (s == null || s.length() < 1) {
            return null;
        }
        return s;
    }

    public boolean sameGAV(ArtifactMetadata md) {
        if (md == null) {
            return false;
        }
        return this.sameGA(md) && this.version != null && this.version.equals(md.getVersion());
    }

    public boolean sameGA(ArtifactMetadata md) {
        if (md == null) {
            return false;
        }
        return this.groupId != null && this.artifactId != null && this.groupId.equals(md.getGroupId()) && this.artifactId.equals(md.getArtifactId());
    }

    public String getGA() {
        return this.toDomainString();
    }

    public String getGAV() {
        return this.toString();
    }

    private static final String nvl(String val, String dflt) {
        return val == null ? dflt : val;
    }

    private static final String nvl(String val) {
        return ArtifactMetadata.nvl(val, "");
    }

    public String toString() {
        return ArtifactMetadata.nvl(this.groupId) + ":" + ArtifactMetadata.nvl(this.artifactId) + ":" + ArtifactMetadata.nvl(this.version) + ":" + ArtifactMetadata.nvl(this.classifier) + ":" + ArtifactMetadata.nvl(this.type, DEFAULT_ARTIFACT_TYPE);
    }

    public String toScopedString() {
        return this.toString() + "-scope:" + (Object)((Object)this.getArtifactScope());
    }

    public String toDomainString() {
        return this.groupId + ":" + this.artifactId;
    }

    public String toManagementString() {
        return this.groupId + ":" + this.artifactId + ":" + this.type + (this.classifier != null ? ":" + this.classifier : "");
    }

    public String getBaseName() {
        return this.artifactId + "-" + this.version + (this.classifier == null ? "" : "-" + this.classifier);
    }

    public String getFileName() {
        return this.getBaseName() + "." + (this.type == null ? DEFAULT_ARTIFACT_TYPE : this.type);
    }

    public String getBaseName(String classifier) {
        return this.artifactId + "-" + this.version + (classifier == null || classifier.length() < 1 ? "" : "-" + classifier);
    }

    public String getCheckedType() {
        return this.type == null ? DEFAULT_ARTIFACT_TYPE : this.type;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasVersion() {
        return this.version != null && this.version.length() > 0;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    private void checkRangeExists() {
        if (this.versionRange == null) {
            if (this.version == null) {
                throw new IllegalArgumentException(LANG.getMessage("artifact.metadata.no.version", new String[]{this.toString()}));
            }
            try {
                this.versionRange = VersionRangeFactory.create(this.version);
            }
            catch (VersionException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
    }

    public boolean isSingleton() {
        this.checkRangeExists();
        return this.versionRange.isSingleton();
    }

    public boolean isRange() {
        return !this.isSingleton();
    }

    public Quality getRequestedQuality() {
        if (this.isRange()) {
            return null;
        }
        if (this.isVirtual()) {
            if (this.isVirtualSnapshot()) {
                return Quality.SNAPSHOT_QUALITY;
            }
            if (this.isVirtualRelease()) {
                return Quality.RELEASE_QUALITY;
            }
            return null;
        }
        if (this.quality != null) {
            return this.quality;
        }
        this.quality = new Quality(this.getVersion());
        return this.quality;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if ("test-jar".equals(type)) {
            this.setClassifier("tests");
            this.setType(DEFAULT_ARTIFACT_TYPE);
        } else {
            this.type = type;
        }
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getScope() {
        return this.getArtifactScope().getScope();
    }

    public ArtifactScopeEnum getScopeAsEnum() {
        return this.artifactScope == null ? ArtifactScopeEnum.DEFAULT_SCOPE : this.artifactScope;
    }

    public ArtifactScopeEnum getArtifactScope() {
        return this.artifactScope == null ? ArtifactScopeEnum.DEFAULT_SCOPE : this.artifactScope;
    }

    public void setArtifactScope(ArtifactScopeEnum artifactScope) {
        this.artifactScope = artifactScope;
    }

    public void setScope(String scope) {
        this.artifactScope = scope == null ? ArtifactScopeEnum.DEFAULT_SCOPE : ArtifactScopeEnum.valueOf(scope);
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public void setOptional(String optional) {
        this.optional = "true".equals(optional);
    }

    public Object getTracker() {
        return this.tracker;
    }

    public void setTracker(Object tracker) {
        this.tracker = tracker;
    }

    public boolean hasClassifier() {
        return this.classifier != null && this.classifier.length() > 0;
    }

    public Boolean isLocal() {
        return this.local;
    }

    public void setLocal(Boolean local) {
        this.local = local;
    }

    public boolean isPom() {
        return "pom".regionMatches(0, this.type, 0, 3);
    }

    public boolean isVirtual() {
        return DefaultArtifactVersion.isVirtual(this.version);
    }

    public boolean isVirtualSnapshot() {
        return DefaultArtifactVersion.isVirtualSnapshot(this.version);
    }

    public boolean isVirtualRelease() {
        return DefaultArtifactVersion.isVirtualRelease(this.version);
    }

    public boolean isVirtualLatest() {
        return DefaultArtifactVersion.isVirtualLatest(this.version);
    }

    public ArtifactCoordinates getEffectiveCoordinates() {
        if (this.relocations == null || this.relocations.isEmpty()) {
            return new ArtifactCoordinates(this.groupId, this.artifactId, this.version);
        }
        return this.relocations.get(this.relocations.size() - 1);
    }

    public ArtifactMetadata addRelocation(ArtifactCoordinates coord) {
        if (coord == null) {
            return this;
        }
        if (this.relocations == null) {
            this.relocations = new ArrayList<ArtifactCoordinates>(2);
        }
        if (coord.getGroupId() == null) {
            coord.setGroupId(this.groupId);
        }
        if (coord.getArtifactId() == null) {
            coord.setArtifactId(this.artifactId);
        }
        if (coord.getVersion() == null) {
            coord.setVersion(this.version);
        }
        this.relocations.add(coord);
        this.effectiveCoordinates = coord;
        return this;
    }

    public String getEffectiveGroupId() {
        return this.effectiveCoordinates == null ? this.groupId : this.effectiveCoordinates.getGroupId();
    }

    public String getEffectiveArtifactId() {
        return this.effectiveCoordinates == null ? this.artifactId : this.effectiveCoordinates.getArtifactId();
    }

    public String getEffectiveersion() {
        return this.effectiveCoordinates == null ? this.version : this.effectiveCoordinates.getVersion();
    }

    public boolean hasInclusions() {
        return this.inclusions == null ? false : !this.inclusions.isEmpty();
    }

    public Collection<ArtifactMetadata> getInclusions() {
        return this.inclusions;
    }

    public void setInclusions(Collection<ArtifactMetadata> inclusions) {
        this.inclusions = inclusions;
    }

    public boolean hasExclusions() {
        return this.exclusions == null ? false : !this.exclusions.isEmpty();
    }

    public Collection<ArtifactMetadata> getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(Collection<ArtifactMetadata> exclusions) {
        this.exclusions = exclusions;
    }

    public boolean allowDependency(ArtifactMetadata dep) throws VersionException {
        boolean includeDependency = true;
        if (this.hasInclusions()) {
            boolean bl = includeDependency = !this.passesFilter(this.inclusions, dep);
        }
        if (!includeDependency) {
            return false;
        }
        if (!this.hasExclusions()) {
            return true;
        }
        return this.passesFilter(this.exclusions, dep);
    }

    private boolean passesFilter(Collection<ArtifactMetadata> filter, ArtifactMetadata dep) throws VersionException {
        for (ArtifactMetadata filterMd : filter) {
            if (!filterMd.sameGA(dep)) continue;
            if (!filterMd.hasVersion()) {
                return false;
            }
            VersionRange vr = VersionRangeFactory.create(filterMd.getVersion());
            if (!vr.includes(dep.getVersion())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ArtifactMetadata)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public List<ArtifactMetadata> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<ArtifactMetadata> dependencies) {
        this.dependencies = dependencies;
    }

    public String getArtifactUri() {
        return this.artifactUri;
    }

    public void setArtifactUri(String artifactUri) {
        this.artifactUri = artifactUri;
    }

    public Object getDatum() {
        return this.datum;
    }

    public void setDatum(Object datum) {
        this.datum = datum;
    }
}

