/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util;

import com.jetbrains.rd.util.ILoggerFactory;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.PlatformDependentKt;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rd/util/ConsoleLoggerFactory;", "Lcom/jetbrains/rd/util/ILoggerFactory;", "()V", "levelToLogStderr", "Lcom/jetbrains/rd/util/LogLevel;", "getLevelToLogStderr", "()Lcom/jetbrains/rd/util/LogLevel;", "setLevelToLogStderr", "(Lcom/jetbrains/rd/util/LogLevel;)V", "minLevelToLog", "getMinLevelToLog", "setMinLevelToLog", "traceCategories", "", "", "getTraceCategories", "()Ljava/util/Set;", "setTraceCategories", "(Ljava/util/Set;)V", "getLogger", "Lcom/jetbrains/rd/util/Logger;", "category", "rd-core"})
public final class ConsoleLoggerFactory
implements ILoggerFactory {
    @NotNull
    private static LogLevel minLevelToLog;
    @Nullable
    private static LogLevel levelToLogStderr;
    @NotNull
    private static Set<String> traceCategories;
    public static final ConsoleLoggerFactory INSTANCE;

    @NotNull
    public final LogLevel getMinLevelToLog() {
        return minLevelToLog;
    }

    public final void setMinLevelToLog(@NotNull LogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"<set-?>");
        minLevelToLog = logLevel;
    }

    @Nullable
    public final LogLevel getLevelToLogStderr() {
        return levelToLogStderr;
    }

    public final void setLevelToLogStderr(@Nullable LogLevel logLevel) {
        levelToLogStderr = logLevel;
    }

    @NotNull
    public final Set<String> getTraceCategories() {
        return traceCategories;
    }

    public final void setTraceCategories(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        traceCategories = set;
    }

    @Override
    @NotNull
    public Logger getLogger(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        return new Logger(category){
            final /* synthetic */ String $category;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void log(@NotNull LogLevel level, @Nullable Object message, @Nullable Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
                if (!this.isEnabled(level)) {
                    return;
                }
                String msg = LoggerKt.defaultLogFormat(this.$category, level, message, throwable);
                LogLevel logLevel = ConsoleLoggerFactory.INSTANCE.getLevelToLogStderr();
                if (logLevel != null) {
                    LogLevel logLevel2 = logLevel;
                    boolean bl = false;
                    boolean bl2 = false;
                    LogLevel it = logLevel2;
                    boolean bl3 = false;
                    if (level.compareTo((Enum)it) > 0) {
                        PlatformDependentKt.printlnError(msg);
                        return;
                    }
                }
                boolean bl = false;
                System.out.println((Object)msg);
            }

            public boolean isEnabled(@NotNull LogLevel level) {
                Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
                return level.compareTo((Enum)ConsoleLoggerFactory.INSTANCE.getMinLevelToLog()) >= 0 || ConsoleLoggerFactory.INSTANCE.getTraceCategories().contains(this.$category) || ConsoleLoggerFactory.INSTANCE.getTraceCategories().contains(StringsKt.substringBefore$default((String)this.$category, (char)'.', null, (int)2, null));
            }
            {
                this.$category = $captured_local_variable$0;
            }
        };
    }

    private ConsoleLoggerFactory() {
    }

    static {
        ConsoleLoggerFactory consoleLoggerFactory;
        INSTANCE = consoleLoggerFactory = new ConsoleLoggerFactory();
        minLevelToLog = LogLevel.Debug;
        levelToLogStderr = LogLevel.Warn;
        boolean bl = false;
        traceCategories = new LinkedHashSet();
    }
}

