/*
 * Decompiled with CFR 0.152.
 */
package fleet.util;

import com.sun.jna.platform.win32.WinReg;
import fleet.util.OsUtil;
import fleet.util.Platform;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import java.net.InetAddress;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000eJ\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000eR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lfleet/util/OsUtil;", "", "()V", "fileBrowserAppName", "", "getFileBrowserAppName", "()Ljava/lang/String;", "log", "Lfleet/util/logging/KLogger;", "getUserMail", "installProtocolHandler", "", "path", "navigate", "Ljava/nio/file/Path;", "select", "", "openFile", "showFile", "Linux", "Windows", "fleet.util"})
public final class OsUtil {
    private static final KLogger log;
    @NotNull
    public static final OsUtil INSTANCE;

    @Nullable
    public final String getFileBrowserAppName() {
        return Platform.INSTANCE.isMac() ? "Finder" : (Platform.INSTANCE.isWindows() ? "Explorer" : null);
    }

    public final void openFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.navigate(path, false);
    }

    public final void showFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.navigate(path, true);
    }

    public final void installProtocolHandler(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (Platform.INSTANCE.isWindows()) {
            Windows.INSTANCE.installProtocolHandlers(path);
        } else if (Platform.INSTANCE.isLinux()) {
            Linux.INSTANCE.installProtocolHandler(path);
        }
    }

    @Nullable
    public final String getUserMail() {
        StringBuilder stringBuilder = new StringBuilder().append(System.getProperty("user.name")).append('@');
        InetAddress inetAddress = InetAddress.getLocalHost();
        Intrinsics.checkNotNullExpressionValue((Object)inetAddress, (String)"InetAddress.getLocalHost()");
        return stringBuilder.append(inetAddress.getCanonicalHostName()).toString();
    }

    private final void navigate(Path path, boolean select2) {
        String[] stringArray;
        String normalized = ((Object)path.toAbsolutePath().normalize()).toString();
        if (Platform.INSTANCE.isMac()) {
            if (select2) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "open";
                stringArray2[1] = "-R";
                stringArray = stringArray2;
                stringArray2[2] = normalized;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "open";
                stringArray = stringArray3;
                stringArray3[1] = normalized;
            }
        } else if (Platform.INSTANCE.isWindows()) {
            String[] stringArray4 = new String[2];
            stringArray4[0] = "explorer";
            stringArray = stringArray4;
            stringArray4[1] = select2 ? "/select,\"" + normalized : "/root,\"" + normalized;
        } else if (Platform.INSTANCE.isLinux()) {
            String normalizedParent = ((Object)path.getParent().toAbsolutePath().normalize()).toString();
            String[] stringArray5 = new String[2];
            stringArray5[0] = "xdg-open";
            stringArray = stringArray5;
            stringArray5[1] = select2 ? normalizedParent : normalized;
        } else {
            throw (Throwable)new UnsupportedOperationException();
        }
        String[] command = stringArray;
        Runtime.getRuntime().exec(command);
    }

    private OsUtil() {
    }

    static {
        OsUtil osUtil;
        INSTANCE = osUtil = new OsUtil();
        boolean $i$f$logger = false;
        log = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(OsUtil.class));
    }

    public static final /* synthetic */ KLogger access$getLog$p(OsUtil $this) {
        OsUtil osUtil = $this;
        return log;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lfleet/util/OsUtil$Linux;", "", "()V", "installProtocolHandler", "", "path", "", "fleet.util"})
    private static final class Linux {
        @NotNull
        public static final Linux INSTANCE;

        public final void installProtocolHandler(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            installProtocolHandler.1 $fun$generateProperties$1 = installProtocolHandler.1.INSTANCE;
            installProtocolHandler.2 $fun$getCurrentProperties$2 = installProtocolHandler.2.INSTANCE;
            installProtocolHandler.3 $fun$writeDesktopFile$3 = installProtocolHandler.3.INSTANCE;
            installProtocolHandler.4 $fun$setupProtocolHandler$4 = installProtocolHandler.4.INSTANCE;
            $fun$writeDesktopFile$3.invoke(path);
            $fun$setupProtocolHandler$4.invoke();
        }

        private Linux() {
        }

        static {
            Linux linux;
            INSTANCE = linux = new Linux();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lfleet/util/OsUtil$Windows;", "", "()V", "containsCharsToBeQuoted", "", "str", "", "installProtocolHandlers", "", "path", "quoteArgument", "arg", "fleet.util"})
    private static final class Windows {
        @NotNull
        public static final Windows INSTANCE;

        public final void installProtocolHandlers(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            installProtocolHandlers.1 $fun$writeRegValue$1 = installProtocolHandlers.1.INSTANCE;
            WinReg.HKEY hKEY = WinReg.HKEY_CURRENT_USER;
            Intrinsics.checkNotNullExpressionValue((Object)hKEY, (String)"WinReg.HKEY_CURRENT_USER");
            $fun$writeRegValue$1.invoke(hKEY, "Software\\Classes\\fleet", "", "\"URL: fleet Protocol\"");
            WinReg.HKEY hKEY2 = WinReg.HKEY_CURRENT_USER;
            Intrinsics.checkNotNullExpressionValue((Object)hKEY2, (String)"WinReg.HKEY_CURRENT_USER");
            $fun$writeRegValue$1.invoke(hKEY2, "Software\\Classes\\fleet", "URL Protocol", "\"\"");
            String executable = this.quoteArgument(path) + " %1";
            WinReg.HKEY hKEY3 = WinReg.HKEY_CURRENT_USER;
            Intrinsics.checkNotNullExpressionValue((Object)hKEY3, (String)"WinReg.HKEY_CURRENT_USER");
            $fun$writeRegValue$1.invoke(hKEY3, "Software\\Classes\\fleet\\shell\\open\\command", "", executable);
        }

        private final boolean containsCharsToBeQuoted(String str) {
            return StringsKt.contains$default((CharSequence)str, (char)' ', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)str, (char)'\"', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)str, (char)'\n', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)str, (char)'\t', (boolean)false, (int)2, null);
        }

        private final String quoteArgument(String arg) {
            CharSequence charSequence = arg;
            boolean bl = false;
            if (charSequence.length() == 0) {
                return "\"\"";
            }
            if (!this.containsCharsToBeQuoted(arg)) {
                return arg;
            }
            boolean bl2 = false;
            bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            $this$buildString.append('\"');
            int length = arg.length();
            for (int i = 0; i < length; ++i) {
                int backslashes = 0;
                while (i < length && arg.charAt(i) == '\\') {
                    ++backslashes;
                    ++i;
                }
                if (i == length) {
                    $this$buildString.append(StringsKt.repeat((CharSequence)"\\", (int)(backslashes * 2)));
                    continue;
                }
                if (arg.charAt(i) == '\"') {
                    $this$buildString.append(StringsKt.repeat((CharSequence)"\\", (int)(backslashes * 2 + 1)));
                    $this$buildString.append('\"');
                    continue;
                }
                $this$buildString.append(StringsKt.repeat((CharSequence)"\\", (int)backslashes));
                $this$buildString.append(arg.charAt(i));
            }
            $this$buildString.append('\"');
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        private Windows() {
        }

        static {
            Windows windows;
            INSTANCE = windows = new Windows();
        }
    }
}

